! f90 include file
!
! list of Fortran 90 interfaces for the RngStream wrapper routines,
! stored in the file: 'RngStream_f90wrapper.c'.
!
! Copyright É. Canot 2003-2025 -- IPR/CNRS

interface
!_______________________________________________________________________
!
subroutine rng_create_stream( g_addr )
   import :: MF_ADDRESS
   integer(kind=MF_ADDRESS) :: g_addr
end subroutine
!_______________________________________________________________________
!
subroutine rng_increased_precis( g_addr, incp )
   import :: MF_ADDRESS
   integer(kind=MF_ADDRESS), intent(in) :: g_addr
   integer,                  intent(in) :: incp
end subroutine
!_______________________________________________________________________
!
subroutine rng_set_seed( g_addr, r_seed )
   import :: MF_ADDRESS, MF_DOUBLE
   integer(kind=MF_ADDRESS), intent(in) :: g_addr
   real(kind=MF_DOUBLE),     intent(in) :: r_seed(6)
end subroutine
!_______________________________________________________________________
!
subroutine rng_get_state( g_addr, r_seed )
   import :: MF_ADDRESS, MF_DOUBLE
   integer(kind=MF_ADDRESS), intent(in) :: g_addr
   real(kind=MF_DOUBLE)                 :: r_seed(6)
end subroutine
!_______________________________________________________________________
!
subroutine rng_rand_u01( g_addr, x )
   import :: MF_ADDRESS, MF_DOUBLE
   integer(kind=MF_ADDRESS), intent(in) :: g_addr
   real(kind=MF_DOUBLE)                 :: x
end subroutine
!_______________________________________________________________________
!
subroutine rng_delete_stream( g_addr )
   import :: MF_ADDRESS
   integer(kind=MF_ADDRESS), intent(in) :: g_addr
end subroutine
!_______________________________________________________________________
!
end interface
