#include <stdio.h>
#include "RngStream.h"

/* Address type: ADDRESS */
#ifdef _64_BITS
#define ADDRESS long long int
#else
#define ADDRESS int
#endif

#ifdef UNDERSCORE
#define rng_create_stream rng_create_stream_
#endif
void rng_create_stream( ADDRESS* g_addr )
{
   *g_addr = (ADDRESS) RngStream_CreateStream ("");
}

#ifdef UNDERSCORE
#define rng_increased_precis rng_increased_precis_
#endif
void rng_increased_precis( ADDRESS* g_addr, int * incp )
{
   RngStream_IncreasedPrecis ( (RngStream)*g_addr, *incp );
}

#ifdef UNDERSCORE
#define rng_set_seed rng_set_seed_
#endif
void rng_set_seed( ADDRESS* g_addr, double r_seed[] )
{
   unsigned long seed[6];
   int i;

   for (i = 0; i < 6; i++) {
      seed[i] = r_seed[i];
   }
   RngStream_SetSeed( (RngStream)*g_addr, seed );
}

#ifdef UNDERSCORE
#define rng_get_state rng_get_state_
#endif
void rng_get_state( ADDRESS* g_addr, double r_seed[] )
{
   unsigned long seed[6];
   int i;

   RngStream_GetState ( (RngStream)*g_addr, seed );
   for (i = 0; i < 6; i++) {
      r_seed[i] = seed[i];
   }
}

#ifdef UNDERSCORE
#define rng_rand_u01 rng_rand_u01_
#endif
void rng_rand_u01( ADDRESS* g_addr, double* x )
{
   *x = RngStream_RandU01 ( (RngStream)*g_addr );
}

#ifdef UNDERSCORE
#define rng_delete_stream rng_delete_stream_
#endif
void rng_delete_stream( ADDRESS* g_addr )
{
   RngStream_DeleteStream ( (RngStream *)g_addr );
}
