! Modification É. Canot -- IPR/CNRS
!
! * 22/12/09 : suppression de l'écriture du copyright
! *            prise en compte du code de retour 'code'

!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!! -*- Mode: F90 -*- !!!!!!!!!!!!!!!!!!!!!!!!!!!!!
!! GFT_set.f90 --- GFT initialization routines
!!
!! Auteur          : Jalel Chergui (CNRS/IDRIS) <Jalel.Chergui@idris.fr>
!! Créé le         : Tue Feb 19 10:26:52 2002
!! Dern. mod. par  : Jalel Chergui (CNRS/IDRIS) <Jalel.Chergui@idris.fr>
!! Dern. mod. le   : Wed May 15 14:19:14 2002
!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
!
! Permission is granted to copy and distribute this file or modified
! versions of this file for no fee, provided the copyright notice and
! this permission notice are preserved on all copies.
! Copyright February 2002, CNRS/IDRIS, Jalel.Chergui@idris.fr
!
MODULE GFT_set

  USE GFT_JMFFT

  IMPLICIT NONE

  PRIVATE

  PUBLIC :: GFT_set_bf
  INTERFACE GFT_set_bf
     MODULE PROCEDURE GFT_set_bf_cc, GFT_set_bf_rcr, GFT_set_bf_mcc, &
                      GFT_set_bf_mrcr
  END INTERFACE GFT_set_bf

  PUBLIC :: GFT_set_fft
  INTERFACE GFT_set_fft
     MODULE PROCEDURE GFT_set_cc_1d,  GFT_set_cc_2d,  GFT_set_cc_3d,  &
                      GFT_set_rcr_1d, GFT_set_rcr_2d, GFT_set_rcr_3d, &
                      GFT_set_mcc,   GFT_set_mrcr
  END INTERFACE GFT_set_fft

CONTAINS
!_______________________________________________________________________
!
  SUBROUTINE GFT_set_bf_cc( BF, FFT, code )

    !... Input dummy arguments
    INTEGER, INTENT(IN) :: BF

    !... Output dummy arguments
    TYPE(GFT_CC), INTENT(OUT)      :: FFT
    INTEGER, OPTIONAL, INTENT(OUT) :: code

    FFT%BF=BF
    IF( PRESENT(code) ) code = 0

  END SUBROUTINE GFT_set_bf_cc
!_______________________________________________________________________
!
  SUBROUTINE GFT_set_bf_rcr( BF, FFT, code )

    !... Input dummy arguments
    INTEGER, INTENT(IN) :: BF

    !... Output dummy arguments
    TYPE(GFT_RCR), INTENT(OUT)     :: FFT
    INTEGER, OPTIONAL, INTENT(OUT) :: code

    FFT%BF=BF
    IF( PRESENT(code) ) code = 0

  END SUBROUTINE GFT_set_bf_rcr
!_______________________________________________________________________
!
  SUBROUTINE GFT_set_bf_mcc( BF, FFT, code )

    !... Input dummy arguments
    INTEGER, INTENT(IN) :: BF

    !... Output dummy arguments
    TYPE(GFT_MCC), INTENT(OUT)     :: FFT
    INTEGER, OPTIONAL, INTENT(OUT) :: code

    FFT%BF=BF
    IF( PRESENT(code) ) code = 0

  END SUBROUTINE GFT_set_bf_mcc
!_______________________________________________________________________
!
  SUBROUTINE GFT_set_bf_mrcr( BF, FFT, code )

    !... Input dummy arguments
    INTEGER, INTENT(IN) :: BF

    !... Output dummy arguments
    TYPE(GFT_MRCR), INTENT(OUT)    :: FFT
    INTEGER, OPTIONAL, INTENT(OUT) :: code

    FFT%BF=BF
    IF( PRESENT(code) ) code = 0

  END SUBROUTINE GFT_set_bf_mrcr
!_______________________________________________________________________
!
  SUBROUTINE GFT_set_cc_1d( Nx, FFT, code )

    !... Input dummy arguments
    INTEGER, INTENT(IN)           :: Nx

    !... Output dummy arguments
    TYPE(GFT_CC), INTENT(OUT)      :: FFT
    INTEGER, OPTIONAL, INTENT(OUT) :: code

    !... Local variables
    INTEGER, DIMENSION(0:99)    :: fact
    INTEGER                     :: nfact
    CHARACTER(LEN=*), PARAMETER :: spname="GFT_set_cc_1d"
    INTEGER                     :: ier

    IF( PRESENT(code) ) code = 0

!!    CALL GFT_CopyRight()

    IF( Nx < 1 ) then
!!      CALL GFT_Error(spname//": Error: Nx < 1")
      ier = 23 ! Nx must be >= 1
      if( present(code) ) then
        code = ier
      else
        call jmerreur0('GFT_set_cc_1d',ier)
      end if
    END IF
    FFT%Nx = Nx

    FFT%Init      = .TRUE.
    FFT%TableSize = 100+2*FFT%Nx
    ALLOCATE(FFT%Table(0:FFT%TableSize-1))

    FFT%WorkSize = 4*FFT%BF*FFT%Nx
    ALLOCATE(FFT%Work(0:FFT%WorkSize-1))

    ! Pour la factorisation
    CALL jmfact(FFT%Nx,fact,100,0,nfact,ier)
    if( present(code) ) then
      code = ier
    else
      call jmerreur0('JMFACT',ier)
    end if
    FFT%Table(0:nfact-1) = fact(0:nfact-1)

    ! Pour les sinus et cosinus
    CALL jmtable(FFT%Table,FFT%TableSize,100+0,FFT%Nx)

  END SUBROUTINE GFT_set_cc_1d
!_______________________________________________________________________
!
  SUBROUTINE GFT_set_cc_2d( Nx, Ny, FFT, code )

    !... Input dummy arguments
    INTEGER, INTENT(IN)           :: Nx, Ny

    !... Output dummy arguments
    TYPE(GFT_CC), INTENT(OUT)      :: FFT
    INTEGER, OPTIONAL, INTENT(OUT) :: code

    !... Internal variables
    INTEGER, DIMENSION(0:99)    :: fact
    INTEGER                     :: nfact, mfact
    CHARACTER(LEN=*), PARAMETER :: spname="GFT_set_cc_2d"
    INTEGER                     :: ier

    IF( PRESENT(code) ) code = 0

!!    CALL GFT_CopyRight()

    IF( Nx < 1 ) then
!!      CALL GFT_Error(spname//": Error: Nx < 1")
      ier = 23 ! Nx must be >= 1
      if( present(code) ) then
        code = ier
      else
        call jmerreur0('GFT_set_cc_2d',ier)
      end if
    end if
    IF( Ny < 1 ) then
!!      CALL GFT_Error(spname//": Error: Ny < 1")
      ier = 26 ! Ny must be >= 1
      if( present(code) ) then
        code = ier
      else
        call jmerreur0('GFT_set_cc_2d',ier)
      end if
    end if
    FFT%Nx = Nx
    FFT%Ny = Ny

    FFT%Init      = .TRUE.
    FFT%TableSize = 100+2*(FFT%Nx + FFT%Ny)
    ALLOCATE(FFT%Table(0:FFT%TableSize-1))

    FFT%WorkSize = 4*FFT%BF*MAX(FFT%Nx, FFT%Ny)
    CALL JMsetnwork(FFT%WorkSize)
    ALLOCATE(FFT%Work(0:FFT%WorkSize-1))

    !... Pour la factorisation
    CALL jmfact(FFT%Nx,fact,100,0,nfact,ier)
    if( present(code) ) then
      code = ier
    else
      call jmerreur0('JMFACT',ier)
    end if
    CALL jmfact(FFT%Ny,fact,100,nfact,mfact,ier)
    if( present(code) ) then
      code = ier
    else
      call jmerreur0('JMFACT',ier)
    end if
    FFT%Table(0:mfact-1) = fact(0:mfact-1)

    !... Pour les sinus et cosinus
    CALL jmtable(FFT%Table,FFT%TableSize,100+0,FFT%Nx)
    CALL jmtable(FFT%Table,FFT%TableSize,100+2*FFT%Nx,FFT%Ny)

  END SUBROUTINE GFT_set_cc_2d
!_______________________________________________________________________
!
  SUBROUTINE GFT_set_cc_3d( Nx, Ny, Nz, FFT, code )

    !... Input dummy arguments
    INTEGER, INTENT(IN)           :: Nx, Ny, Nz

    !... Output dummy arguments
    TYPE(GFT_CC), INTENT(OUT)      :: FFT
    INTEGER, OPTIONAL, INTENT(OUT) :: code

    !... Internal variables
    INTEGER, DIMENSION(0:99)    :: fact
    INTEGER                     :: nfact, mfact, lfact
    CHARACTER(LEN=*), PARAMETER :: spname="GFT_set_cc_3d"
    INTEGER                     :: ier

    IF( PRESENT(code) ) code = 0

!!    CALL GFT_CopyRight()

    IF( Nx < 1 ) then
!!      CALL GFT_Error(spname//": Error: Nx < 1")
      ier = 23 ! Nx must be >= 1
      if( present(code) ) then
        code = ier
      else
        call jmerreur0('GFT_set_cc_3d',ier)
      end if
    END IF
    IF( Ny < 1 ) then
!!      CALL GFT_Error(spname//": Error: Ny < 1")
      ier = 26 ! Ny must be >= 1
      if( present(code) ) then
        code = ier
      else
        call jmerreur0('GFT_set_cc_3d',ier)
      end if
    END IF
    IF( Nz < 1 ) then
!!      CALL GFT_Error(spname//": Error: Nz < 1")
      ier = 21 ! Nz must be >= 1
      if( present(code) ) then
        code = ier
      else
        call jmerreur0('GFT_set_cc_3d',ier)
      end if
    END IF
    FFT%Nx = Nx
    FFT%Ny = Ny
    FFT%Nz = Nz

    FFT%Init      = .TRUE.
    FFT%TableSize = 100+2*(FFT%Nx + FFT%Ny + FFT%Nz)
    ALLOCATE(FFT%Table(0:FFT%TableSize-1))

    FFT%WorkSize = 4*FFT%BF*MAX(FFT%Nx, FFT%Ny, FFT%Nz)
    CALL JMsetnwork(FFT%WorkSize)
    ALLOCATE(FFT%Work(0:FFT%WorkSize-1))

    !... Pour la factorisation
    CALL jmfact(FFT%Nx,fact,100,0,nfact,ier)
    if( present(code) ) then
      code = ier
    else
      call jmerreur0('JMFACT',ier)
    end if
    CALL jmfact(FFT%Ny,fact,100,nfact,mfact,ier)
    if( present(code) ) then
      code = ier
    else
      call jmerreur0('JMFACT',ier)
    end if
    CALL jmfact(FFT%Nz,fact,100,mfact,lfact,ier)
    if( present(code) ) then
      code = ier
    else
      call jmerreur0('JMFACT',ier)
    end if
    FFT%Table(0:lfact-1) = fact(0:lfact-1)

    !... Pour les sinus et cosinus
    CALL jmtable(FFT%Table,FFT%TableSize,100+0,FFT%Nx)
    CALL jmtable(FFT%Table,FFT%TableSize,100+2*FFT%Nx,FFT%Ny)
    CALL jmtable(FFT%Table,FFT%TableSize,100+2*(FFT%Nx+FFT%Ny),FFT%Nz)

  END SUBROUTINE GFT_set_cc_3d
!_______________________________________________________________________
!
  SUBROUTINE GFT_set_rcr_1d( Nx, FFT, code )

    !... Input dummy arguments
    INTEGER, INTENT(IN)           :: Nx

    !... Output dummy arguments
    TYPE(GFT_RCR), INTENT(OUT)     :: FFT
    INTEGER, OPTIONAL, INTENT(OUT) :: code

    !... Local variables
    INTEGER, DIMENSION(0:99)    :: fact
    INTEGER                     :: nfact
    CHARACTER(LEN=*), PARAMETER :: spname="GFT_set_rcr_1d"
    INTEGER                     :: ier

    IF( PRESENT(code) ) code = 0

!!    CALL GFT_CopyRight()

    IF( Nx < 1 ) then
!!      CALL GFT_Error(spname//": Error: Nx < 1")
      ier = 23 ! Nx must be >= 1
      if( present(code) ) then
        code = ier
      else
        call jmerreur0('GFT_set_rcr_1d',ier)
      end if
    END IF
    FFT%Nx = Nx

    FFT%even_x = (MOD(FFT%Nx,2) == 0 )
    IF( .NOT. FFT%even_x ) then
!!      CALL GFT_Error(spname//": Error: Nx not even")
      ier = 24 ! Nx must be even
      if( present(code) ) then
        code = ier
      else
        call jmerreur0('GFT_set_rcr_1d',ier)
      end if
    END IF

    FFT%Init      = .TRUE.
    FFT%TableSize = 100+2*FFT%Nx
    ALLOCATE(FFT%Table(0:FFT%TableSize-1))

    FFT%WorkSize = 2*FFT%BF*FFT%Nx
    ALLOCATE(FFT%Work(0:FFT%WorkSize-1))

    ! Pour la factorisation
    CALL jmfact(FFT%Nx,fact,100,0,nfact,ier)
    if( present(code) ) then
      code = ier
    else
      call jmerreur0('JMFACT',ier)
    end if
    FFT%Table(0:nfact-1) = fact(0:nfact-1)

    ! Pour les sinus et cosinus
    CALL jmtable(FFT%Table,FFT%TableSize,100+0,FFT%Nx)

  END SUBROUTINE GFT_set_rcr_1d
!_______________________________________________________________________
!
  SUBROUTINE GFT_set_rcr_2d( Nx, Ny, FFT, code )

    !... Input dummy arguments
    INTEGER, INTENT(IN)           :: Nx, Ny

    !... Output dummy arguments
    TYPE(GFT_RCR), INTENT(OUT)     :: FFT
    INTEGER, OPTIONAL, INTENT(OUT) :: code

    !... Internal variables
    INTEGER, DIMENSION(0:99)    :: fact
    INTEGER                     :: nfact, mfact
    CHARACTER(LEN=*), PARAMETER :: spname="GFT_set_rcr_2d"
    INTEGER                     :: ier

    IF( PRESENT(code) ) code = 0

!!    CALL GFT_CopyRight()

    IF( Nx < 1 ) then
!!      CALL GFT_Error(spname//": Error: Nx < 1")
      ier = 23 ! Nx must be >= 1
      if( present(code) ) then
        code = ier
      else
        call jmerreur0('GFT_set_rcr_2d',ier)
      end if
    END IF
    IF( Ny < 1 ) then
!!      CALL GFT_Error(spname//": Error: Ny < 1")
      ier = 26 ! Ny must be >= 1
      if( present(code) ) then
        code = ier
      else
        call jmerreur0('GFT_set_rcr_2d',ier)
      end if
    END IF
    FFT%Nx = Nx
    FFT%Ny = Ny

    FFT%even_x = (MOD(FFT%Nx,2) == 0)
    FFT%even_y = (MOD(FFT%Ny,2) == 0)
    IF( .NOT.FFT%even_x .AND. .NOT.FFT%even_y) then
!!      CALL GFT_Error(spname//": Error: Nx and Ny not even")
      ier = 22 ! Ny or Nx must be even
      if( present(code) ) then
        code = ier
      else
        call jmerreur0('GFT_set_rcr_2d',ier)
      end if
    END IF

    FFT%Init      = .TRUE.
    FFT%TableSize = 100+2*(FFT%Nx + FFT%Ny)
    ALLOCATE(FFT%Table(0:FFT%TableSize-1))

    FFT%WorkSize = 4*FFT%BF*MAX(FFT%Nx, FFT%Ny)
    CALL JMsetnwork(FFT%WorkSize)
    ALLOCATE(FFT%Work(0:FFT%WorkSize-1))

    !... Pour la factorisation
    CALL jmfact(FFT%Nx,fact,100,0,nfact,ier)
    if( present(code) ) then
      code = ier
    else
      call jmerreur0('JMFACT',ier)
    end if
    CALL jmfact(FFT%Ny,fact,100,nfact,mfact,ier)
    if( present(code) ) then
      code = ier
    else
      call jmerreur0('JMFACT',ier)
    end if
    FFT%Table(0:mfact-1) = fact(0:mfact-1)

    !... Pour les sinus et cosinus
    CALL jmtable(FFT%Table,FFT%TableSize,100+0,FFT%Nx)
    CALL jmtable(FFT%Table,FFT%TableSize,100+2*FFT%Nx,FFT%Ny)

  END SUBROUTINE GFT_set_rcr_2d
!_______________________________________________________________________
!
  SUBROUTINE GFT_set_rcr_3d( Nx, Ny, Nz, FFT, code )

    !... Input dummy arguments
    INTEGER, INTENT(IN)           :: Nx, Ny, Nz

    !... Output dummy arguments
    TYPE(GFT_RCR), INTENT(OUT)     :: FFT
    INTEGER, OPTIONAL, INTENT(OUT) :: code

    !... Internal variables
    INTEGER, DIMENSION(0:99)    :: fact
    INTEGER                     :: nfact, mfact, lfact
    CHARACTER(LEN=*), PARAMETER :: spname="GFT_set_rcr_3d"
    INTEGER                     :: ier

    IF( PRESENT(code) ) code = 0

!!    CALL GFT_CopyRight()

    IF( Nx < 1 ) then
!!      CALL GFT_Error(spname//": Error: Nx < 1")
      ier = 23 ! Nx must be >= 1
      if( present(code) ) then
        code = ier
      else
        call jmerreur0('GFT_set_rcr_3d',ier)
      end if
    END IF
    IF( Ny < 1 ) then
!!      CALL GFT_Error(spname//": Error: Ny < 1")
      ier = 26 ! Ny must be >= 1
      if( present(code) ) then
        code = ier
      else
        call jmerreur0('GFT_set_rcr_3d',ier)
      end if
    END IF
    IF( Nz < 1 ) then
!!      CALL GFT_Error(spname//": Error: Nz < 1")
      ier = 21 ! Nz must be >= 1
      if( present(code) ) then
        code = ier
      else
        call jmerreur0('GFT_set_rcr_3d',ier)
      end if
    END IF
    FFT%Nx = Nx
    FFT%Ny = Ny
    FFT%Nz = Nz

    FFT%even_x = (MOD(FFT%Nx,2) == 0)
    FFT%even_y = (MOD(FFT%Ny,2) == 0)
    FFT%even_z = (MOD(FFT%Nz,2) == 0)
    IF( .NOT.FFT%even_x .AND. .NOT.FFT%even_y .AND. .NOT.FFT%even_z) then
!!      CALL GFT_Error(spname//": Error: Nx and Ny and Nz not even")
      ier = 25 ! Nx or Ny or Nz must be even
      if( present(code) ) then
        code = ier
      else
        call jmerreur0('GFT_set_rcr_3d',ier)
      end if
    END IF

    FFT%Init      = .TRUE.
    FFT%TableSize = 100+2*(FFT%Nx + FFT%Ny + FFT%Nz)
    ALLOCATE(FFT%Table(0:FFT%TableSize-1))

    FFT%WorkSize = 4*FFT%BF*MAX(FFT%Nx, FFT%Ny, FFT%Nz)
    CALL JMsetnwork(FFT%WorkSize)
    ALLOCATE(FFT%Work(0:FFT%WorkSize-1))

    !... Pour la factorisation
    CALL jmfact(FFT%Nx,fact,100,0,nfact,ier)
    if( present(code) ) then
      code = ier
    else
      call jmerreur0('JMFACT',ier)
    end if
    CALL jmfact(FFT%Ny,fact,100,nfact,mfact,ier)
    if( present(code) ) then
      code = ier
    else
      call jmerreur0('JMFACT',ier)
    end if
    CALL jmfact(FFT%Nz,fact,100,mfact,lfact,ier)
    if( present(code) ) then
      code = ier
    else
      call jmerreur0('JMFACT',ier)
    end if
    FFT%Table(0:lfact-1) = fact(0:lfact-1)

    !... Pour les sinus et cosinus
    CALL jmtable(FFT%Table,FFT%TableSize,100+0,FFT%Nx)
    CALL jmtable(FFT%Table,FFT%TableSize,100+2*FFT%Nx,FFT%Ny)
    CALL jmtable(FFT%Table,FFT%TableSize,100+2*(FFT%Nx+FFT%Ny),FFT%Nz)

  END SUBROUTINE GFT_set_rcr_3d
!_______________________________________________________________________
!
  SUBROUTINE GFT_set_mcc( Nx, Ny, FFT, code )

    !... Input dummy arguments
    INTEGER, INTENT(IN)           :: Nx, Ny

    !... Output dummy arguments
    TYPE(GFT_MCC), INTENT(OUT)     :: FFT
    INTEGER, OPTIONAL, INTENT(OUT) :: code

    !... Internal variables
    INTEGER, DIMENSION(0:99)    :: fact
    INTEGER                     :: nfact
    CHARACTER(LEN=*), PARAMETER :: spname="GFT_set_mcc"
    INTEGER                     :: ier

    IF( PRESENT(code) ) code = 0

!!    CALL GFT_CopyRight()

    IF( Nx < 1 ) then
!!      CALL GFT_Error(spname//": Error: Nx < 1")
      ier = 23 ! Nx must be >= 1
      if( present(code) ) then
        code = ier
      else
        call jmerreur0('GFT_set_mcc',ier)
      end if
    END IF
    IF( Ny < 1 ) then
!!      CALL GFT_Error(spname//": Error: Ny < 1")
      ier = 26 ! Ny must be >= 1
      if( present(code) ) then
        code = ier
      else
        call jmerreur0('GFT_set_mcc',ier)
      end if
    END IF
    FFT%Nx = Nx
    FFT%Ny = Ny

    FFT%Init      = .TRUE.
    FFT%TableSize = 100+2*FFT%Nx
    ALLOCATE(FFT%Table(0:FFT%TableSize-1))

    FFT%WorkSize = 4*FFT%BF*FFT%Nx*FFT%Ny
    ALLOCATE(FFT%Work(0:FFT%WorkSize-1))

    !... Pour la factorisation
    CALL jmfact(FFT%Nx,fact,100,0,nfact,ier)
    if( present(code) ) then
      code = ier
    else
      call jmerreur0('JMFACT',ier)
    end if
    FFT%Table(0:nfact-1) = fact(0:nfact-1)

    !... Pour les sinus et cosinus
    CALL jmtable(FFT%Table,FFT%TableSize,100+0,FFT%Nx)

  END SUBROUTINE GFT_set_mcc
!_______________________________________________________________________
!
  SUBROUTINE GFT_set_mrcr( Nx, Ny, FFT, code )

    !... Input dummy arguments
    INTEGER, INTENT(IN)           :: Nx, Ny

    !... Output dummy arguments
    TYPE(GFT_MRCR), INTENT(OUT)    :: FFT
    INTEGER, OPTIONAL, INTENT(OUT) :: code

    !... Internal variables
    INTEGER, DIMENSION(0:99)    :: fact
    INTEGER                     :: nfact
    CHARACTER(LEN=*), PARAMETER :: spname="GFT_set_mrcr"
    INTEGER                     :: ier

    IF( PRESENT(code) ) code = 0

!!    CALL GFT_CopyRight()

    IF( Nx < 1 ) then
!!      CALL GFT_Error(spname//": Error: Nx < 1")
      ier = 23 ! Nx must be >= 1
      if( present(code) ) then
        code = ier
      else
        call jmerreur0('GFT_set_mrcr',ier)
      end if
    END IF
    IF( Ny < 1 ) then
!!      CALL GFT_Error(spname//": Error: Ny < 1")
      ier = 23 ! Ny must be >= 1
      if( present(code) ) then
        code = ier
      else
        call jmerreur0('GFT_set_mrcr',ier)
      end if
    END IF
    FFT%Nx = Nx
    FFT%Ny = Ny

    FFT%even_x = (MOD(FFT%Nx,2) == 0)
    FFT%even_y = (MOD(FFT%Ny,2) == 0)
    IF( .NOT.FFT%even_x .AND. .NOT.FFT%even_y ) then
!!      CALL GFT_Error(spname//": Error: Nx and Ny not even")
      ier = 22 ! Ny or Nx must be even
      if( present(code) ) then
        code = ier
      else
        call jmerreur0('GFT_set_mrcr',ier)
      end if
    END IF

    FFT%Init      = .TRUE.
    FFT%TableSize = 100+2*FFT%Nx
    ALLOCATE(FFT%Table(0:FFT%TableSize-1))

    FFT%WorkSize = 2*FFT%BF*FFT%Nx*FFT%Ny
    ALLOCATE(FFT%Work(0:FFT%WorkSize-1))

    ! Pour la factorisation
    CALL jmfact(FFT%Nx,fact,100,0,nfact,ier)
    if( present(code) ) then
      code = ier
    else
      call jmerreur0('JMFACT',ier)
    end if
    FFT%Table(0:nfact-1) = fact(0:nfact-1)

    ! Pour les sinus et cosinus
    CALL jmtable(FFT%Table,FFT%TableSize,100+0,FFT%Nx)

  END SUBROUTINE GFT_set_mrcr
!_______________________________________________________________________
!
END MODULE GFT_set
