! f90 include file

!_______________________________________________________________________
!
   subroutine cei_double( d, vk, ve)

      real(kind=MF_DOUBLE), intent(in) :: d
      real(kind=MF_DOUBLE) :: vk, ve
      !------ API end ------
#ifdef _DEVLP

      !-----------------------------------------------------------------
      ! purpose
      !    computes the Complete Elliptic Integrals of First and
      !    Second Kind
      !
      ! usage
      !    call cei(d,vk,ve)
      !
      ! description of parameters
      !    d  = 1 - k^2    (k: modulus)
      !    vk = result value for the C.E.I. of First Kind
      !    ve = result value for the C.E.I. of Second Kind
      !
      ! remarks
      !    definition
      !       vk = int( 1/sqrt(1-k^2*sin(t)^2), t = 0 .. pi/2 )
      !       d must be in [0,1]
      !
      ! subroutines and function subprograms required
      !    none
      !
      ! method
      !    evaluation
      !       double precision
      !       uniform polynomial approximation with abs. prec. ~ 1.e-16
      !    reference
      !       Abramowitz & Stegun
      !       Handbook of Mathematical Functions
      !-----------------------------------------------------------------
      real(kind=MF_DOUBLE) :: e

   !------ end of declarations -- execution starts hereafter  ------

      if( d < 0.0d0 .or. 1.0d0 < d ) then
         vk = MF_NAN
         ve = MF_NAN
         return
      end if

      if( d == 0.0d0 ) then
         vk = MF_INF
         ve = 1.0d0
         return
      end if

      e = -log(d)

      ve = e*((((((((((                                                 &
          0.318591956555015718d-4*d  + 0.989833284622538479d-3)*d       &
        + 0.643214658643830177d-2)*d + 0.168040233463633850d-1)*d       &
        + 0.261450147003138789d-1)*d + 0.334789436657616262d-1)*d       &
        + 0.427178905473830956d-1)*d + 0.585936612555314917d-1)*d       &
        + 0.937499997212031407d-1)*d + 0.249999999999901772d0)*d)       &
        +(((((((((                                                      &
          0.149466217571813268d-3*d  + 0.246850333046072273d-2)*d       &
        + 0.863844217360407443d-2)*d + 0.107706350398664555d-1)*d       &
        + 0.782040406095955417d-2)*d + 0.759509342255943228d-2)*d       &
        + 0.115695957452954022d-1)*d + 0.218318116761304816d-1)*d       &
        + 0.568051945675591566d-1)*d + 0.443147180560889526d0)*d        &
        + 1.0d0

     vk = e*((((((((((                                                  &
          0.297002809665556121d-4*d  + 0.921554634963249846d-3)*d       &
        + 0.597390429915542916d-2)*d + 0.155309416319772039d-1)*d       &
        + 0.239319133231107901d-1)*d + 0.301248490128989303d-1)*d       &
        + 0.373777397586236041d-1)*d + 0.488280419068623980d-1)*d       &
        + 0.703124997390383521d-1)*d + 0.124999999999908081d0)*d        &
        + 0.5d0)+(((((((((                                              &
          0.139308785700664673d-3*d  + 0.229663489839695869d-2)*d       &
        + 0.800300398064998537d-2)*d + 0.984892932217689377d-2)*d       &
        + 0.684790928262450512d-2)*d + 0.617962744605331761d-2)*d       &
        + 0.878980187455506468d-2)*d + 0.149380135326871652d-1)*d       &
        + 0.308851462713051899d-1)*d + 0.965735902808562554d-1)*d       &
        + 0.138629436111989062d1

#endif
   end subroutine cei_double
