! f90 include file

!_______________________________________________________________________
!
   subroutine xtrrow( ncol, a, ia, ja, irow, c )

      integer, intent(in)  :: ncol, irow, ia(*), ja(*)
      real(kind=MF_DOUBLE), intent(in)  :: a(*)
      real(kind=MF_DOUBLE), intent(out) :: c(*)
      !------ API end ------

      !-----------------------------------------------------------------
      ! extracts one row from a matrix in CSC format, and
      ! store it in a dense vector.
      !-----------------------------------------------------------------
      ! on entry:
      !----------
      ! ncol = integer : the number of cols of the input matrix
      !
      ! a, ia, ja = input matrix in CSC format
      !
      ! irow = integer indicating the row to be extracted.
      !        no test is made to verify that its value is correct
      !
      !------------
      ! on return:
      !------------
      ! c = dense vector : c(1:ncol) contains the extracted row.
      !     the length of c must be sufficient to store its elements
      !-----------------------------------------------------------------

      integer :: i, j, k

   !------ end of declarations -- execution starts hereafter  ------

      do j = 1, ncol
         c(j) = 0.0d0
         do k = ja(j), ja(j+1)-1
            i = ia(k)
            if( i == irow ) then
               c(j) = a(k)
            end if
         end do
      end do

   end subroutine xtrrow
!_______________________________________________________________________
!
   subroutine xtrrow_cmplx( ncol, a, ia, ja, irow, c )

      integer, intent(in)  :: ncol, irow, ia(*), ja(*)
      complex(kind=MF_DOUBLE), intent(in)  :: a(*)
      complex(kind=MF_DOUBLE), intent(out) :: c(*)
      !------ API end ------

      !-----------------------------------------------------------------
      ! complex version of 'xtrrow'
      !-----------------------------------------------------------------

      integer :: j, k

   !------ end of declarations -- execution starts hereafter  ------

      do j = 1, ncol
         c(j) = (0.0d0,0.0d0)
         do k = ja(j), ja(j+1)-1
            if( ia(k) == irow ) then
               c(j) = a(k)
            end if
         end do
      end do

   end subroutine xtrrow_cmplx
