! f90 include file

!_______________________________________________________________________
!
   subroutine xtrcols( i1, i2, a, ia, ja, ao, iao, jao, iperm )

      integer, intent(in)  :: i1, i2, ia(*), ja(*), iperm(*)
      integer, intent(out) :: iao(*), jao(*)
      real(kind=MF_DOUBLE), intent(in)  :: a(*)
      real(kind=MF_DOUBLE), intent(out) :: ao(*)
      !------ API end ------

      !-----------------------------------------------------------------
      ! extracts given cols from a matrix in CSC format.
      ! (adapted to CSC format from the 'xtrows' SPARSKIT2 routine,
      !  by É. Canot)
      !-----------------------------------------------------------------
      ! on entry:
      !----------
      ! i1, i2  = two integers indicating the cols to be extracted.
      !           xtrcols extract cols :
      !                  iperm(i1), iperm(i1+1), ..., iperm(i2)
      !           from original matrix and stack them in output matrix
      !           ao, jao, iao.
      !
      ! a, ia, ja = input matrix in CSC format
      !
      ! iperm = integer array of length at least (i2-i1+1)
      !
      !------------
      ! on return:
      !------------
      ! ao, iao, jao = output matrix in CSC format
      !-----------------------------------------------------------------

      integer :: ko, j, jj, k

   !------ end of declarations -- execution starts hereafter  ------

      ko = 1
      jao(1) = ko
      do j = i1, i2
         ! iperm(j) is the index of old col to be copied.
         jj = iperm(j)
         do k = ja(jj), ja(jj+1)-1
            iao(ko) = ia(k)
            ao(ko) = a(k)
            ko = ko + 1
         end do
         jao(j-i1+2) = ko
      end do

   end subroutine xtrcols
!_______________________________________________________________________
!
   subroutine xtrcols_cmplx( i1, i2, a, ia, ja, ao, iao, jao, iperm )

      integer, intent(in)  :: i1, i2, ia(*), ja(*), iperm(*)
      integer, intent(out) :: iao(*), jao(*)
      complex(kind=MF_DOUBLE), intent(in)  :: a(*)
      complex(kind=MF_DOUBLE), intent(out) :: ao(*)
      !------ API end ------

      !-----------------------------------------------------------------
      ! complex version of 'xtrcols'
      !-----------------------------------------------------------------

      integer :: ko, j, jj, k

   !------ end of declarations -- execution starts hereafter  ------

      ko = 1
      jao(1) = ko
      do j = i1, i2
         ! iperm(j) is the index of old col to be copied.
         jj = iperm(j)
         do k = ja(jj), ja(jj+1)-1
            iao(ko) = ia(k)
            ao(ko) = a(k)
            ko = ko + 1
         end do
         jao(j-i1+2) = ko
      end do

   end subroutine xtrcols_cmplx
