! f90 include file

!_______________________________________________________________________
!
   subroutine xtrcol( nrow, a, ia, ja, jcol, c )

      integer, intent(in)  :: nrow, jcol, ia(*), ja(*)
      real(kind=MF_DOUBLE), intent(in)  :: a(*)
      real(kind=MF_DOUBLE), intent(out) :: c(*)
      !------ API end ------

      !-----------------------------------------------------------------
      ! extracts one col from a matrix in CSC format, and
      ! store it in a dense vector.
      !-----------------------------------------------------------------
      ! on entry:
      !----------
      ! nrow = integer : the number of rows of the input matrix
      !
      ! a, ia, ja = input matrix in CSC format
      !
      ! jcol = integer indicating the col to be extracted.
      !        no test is made to verify that its value is correct
      !
      !------------
      ! on return:
      !------------
      ! c = dense vector : c(1:nrow) contains the extracted column.
      !     the length of c must be sufficient to store its elements
      !-----------------------------------------------------------------

      integer :: i, k

   !------ end of declarations -- execution starts hereafter  ------

      c(1:nrow) = 0.0d0

      do k = ja(jcol), ja(jcol+1)-1
         i = ia(k)
         c(i) = a(k)
      end do

   end subroutine xtrcol
!_______________________________________________________________________
!
   subroutine xtrcol_cmplx( nrow, a, ia, ja, jcol, c )

      integer, intent(in)  :: nrow, jcol, ia(*), ja(*)
      complex(kind=MF_DOUBLE), intent(in)  :: a(*)
      complex(kind=MF_DOUBLE), intent(out) :: c(*)
      !------ API end ------

      !-----------------------------------------------------------------
      ! complex version of 'xtrcol'
      !-----------------------------------------------------------------

      integer :: i, k

   !------ end of declarations -- execution starts hereafter  ------

      c(1:nrow) = (0.0d0,0.0d0)

      do k = ja(jcol), ja(jcol+1)-1
         i = ia(k)
         c(i) = a(k)
      end do

   end subroutine xtrcol_cmplx
