! f90 include file

!_______________________________________________________________________
!
   subroutine xmua( nrow, ncol, x, y, a, ia, ja )

      integer,              intent(in) :: nrow, ncol
      real(kind=MF_DOUBLE), intent(in) :: x(:), a(:)
      integer,              intent(in) :: ia(:), ja(:)
      real(kind=MF_DOUBLE), intent(out) :: y(:)
      !------ API end ------

      !-----------------------------------------------------------------
      !         a vector times A
      ! (written by É. Canot)
      !-----------------------------------------------------------------
      ! multiplies a vector by a matrix, using the dot product form;
      ! Matrix A is stored in CSC storage, not necessarily row sorted.
      !
      ! on entry:
      !----------
      ! nrow  = row dimension of A
      ! ncol  = column dimension of A
      ! x     = real array of length equal to nrow
      ! a, ia, ja = input matrix in CSC format.
      !
      ! on return:
      !-----------
      ! y = dense vector (real array of length ncol) containing the
      !     product x*A
      !-----------------------------------------------------------------

      real(kind=MF_DOUBLE) :: temp
      integer :: i, j, k

   !------ end of declarations -- execution starts hereafter  ------

      do j = 1, ncol
         temp = 0.0d0
         do k = ja(j), ja(j+1)-1
            i = ia(k)
            temp = temp + x(i)*a(k)
         end do
         y(j) = temp
      end do

   end subroutine xmua
!_______________________________________________________________________
!
   subroutine xmua_real_cmplx( nrow, ncol, x, y, a, ia, ja )

      integer,                 intent(in) :: nrow, ncol
      real(kind=MF_DOUBLE),    intent(in) :: x(:)
      complex(kind=MF_DOUBLE), intent(in) :: a(:)
      integer,                 intent(in) :: ia(:), ja(:)
      complex(kind=MF_DOUBLE), intent(out) :: y(:)
      !------ API end ------

      !-----------------------------------------------------------------
      !         a vector times A
      ! (written by É. Canot)
      ! (real/complex case of 'xmua')
      !-----------------------------------------------------------------

      complex(kind=MF_DOUBLE) :: temp
      integer :: i, j, k

   !------ end of declarations -- execution starts hereafter  ------

      do j = 1, ncol
         temp = (0.0d0,0.0d0)
         do k = ja(j), ja(j+1)-1
            i = ia(k)
            temp = temp + x(i)*a(k)
         end do
         y(j) = temp
      end do

   end subroutine xmua_real_cmplx
!_______________________________________________________________________
!
   subroutine xmua_cmplx_real( nrow, ncol, x, y, a, ia, ja )

      integer,                 intent(in) :: nrow, ncol
      complex(kind=MF_DOUBLE), intent(in) :: x(:)
      real(kind=MF_DOUBLE),    intent(in) :: a(:)
      integer,                 intent(in) :: ia(:), ja(:)
      complex(kind=MF_DOUBLE), intent(out) :: y(:)
      !------ API end ------

      !-----------------------------------------------------------------
      !         a vector times A
      ! (written by É. Canot)
      ! (real/complex case of 'xmua')
      !-----------------------------------------------------------------

      complex(kind=MF_DOUBLE) :: temp
      integer :: i, j, k

   !------ end of declarations -- execution starts hereafter  ------

      do j = 1, ncol
         temp = (0.0d0,0.0d0)
         do k = ja(j), ja(j+1)-1
            i = ia(k)
            temp = temp + x(i)*a(k)
         end do
         y(j) = temp
      end do

   end subroutine xmua_cmplx_real
!_______________________________________________________________________
!
   subroutine xmua_cmplx_cmplx( nrow, ncol, x, y, a, ia, ja )

      integer,                 intent(in) :: nrow, ncol
      complex(kind=MF_DOUBLE), intent(in) :: x(:)
      complex(kind=MF_DOUBLE), intent(in) :: a(:)
      integer,                 intent(in) :: ia(:), ja(:)
      complex(kind=MF_DOUBLE), intent(out) :: y(:)
      !------ API end ------

      !-----------------------------------------------------------------
      !         a vector times A
      ! (written by É. Canot)
      ! (complex/complex case of 'xmua')
      !-----------------------------------------------------------------

      complex(kind=MF_DOUBLE) :: temp
      integer :: i, j, k

   !------ end of declarations -- execution starts hereafter  ------

      do j = 1, ncol
         temp = (0.0d0,0.0d0)
         do k = ja(j), ja(j+1)-1
            i = ia(k)
            temp = temp + x(i)*a(k)
         end do
         y(j) = temp
      end do

   end subroutine xmua_cmplx_cmplx
