! f90 include file

! Warning: 08 dec 2014 -- only the 'trilsol' routine has been fixed
!          for the case of a singular matrix A (having some diagonal
!          values being zero). We think that this special case is rare
!          so the fix for other routines can be delayed...
!

!_______________________________________________________________________
!
   subroutine triusol( n, x, y, a, ja, ia )

      integer,              intent(in)  :: n, ia(:), ja(:)
      real(kind=MF_DOUBLE), intent(in)  :: a(:), y(:)
      real(kind=MF_DOUBLE), intent(out) :: x(:)
      !------ API end ------

      !-----------------------------------------------------------------
      ! solves    U x = y ;      U = upper triang
      ! É. Canot, Mars 2010
      ! (adpated from SPARSKIT2 (Mar 8 2005) 'usolc' by É. Canot)
      !-----------------------------------------------------------------
      ! on entry:
      !----------
      ! n = nb of col of the matrix U.
      ! a, ia, ja = matrix U in CSC format.
      ! y = array containing the right hand side.
      !
      ! on return:
      !-----------
      ! x = solution.
      !
      ! In the case of a singular matrix, this algorithm returns a
      ! plausible solution. By comparison, 'Octave' returns a finite
      ! vector (whose some values are wrong) and 'Matlab' returns a
      ! vector containing many NaNs, as if it wanted to give a cautious
      ! answer.
      !-----------------------------------------------------------------
      ! U must be square and row sorted.

      ! accepts that x(:) and y(:) are the same object, i.e. have
      ! the same address

      integer :: j, k, irow, shift
      real(kind=MF_DOUBLE) :: t, diag

   !------ end of declarations -- execution starts hereafter  ------

      if( _MF_LOC_ANY_OBJ_(x) /= _MF_LOC_ANY_OBJ_(y) ) then
         do k = 1, n
            x(k) = y(k)
         end do
      end if

      do j = n, 2, -1
         ! inspect the last entry in the column
         k = ja(j+1)-1
         if( k > ja(j)-1 ) then
            ! column non empty
            irow = ia(k)
            if( irow == j ) then
               diag = a(k)
               shift = 1
            else if( irow > j ) then
               ! matrix is not upper triangular
               write(STDERR,*) "(MUESLI:) triusol: internal error :"
               write(STDERR,*) "          not a upper triangular matrix!"
               mf_message_displayed = .true.
               call muesli_trace( pause="yes" )
               stop
            else
               ! not a diagonal element -> diagonal value is zero
               diag = 0.0d0
               shift = 0
            end if
         else
            ! empty column
            diag = 0.0d0
         end if
         x(j) = x(j) / diag
         t = x(j)
         do k = ja(j), ja(j+1)-1-shift
            irow = ia(k)
            x(irow) = x(irow) - t*a(k)
         end do
      end do

      if( ja(2) == 1 ) then
         ! empty column
         diag = 0.0d0
      else
         ! first column non empty: it is necessarily the diagonal term
         diag = a(1)
      end if
      x(1) = x(1) / diag

   end subroutine triusol
!_______________________________________________________________________
!
   subroutine triusol_c_c( n, x, y, a, ja, ia )

      integer,                 intent(in)  :: n, ia(:), ja(:)
      complex(kind=MF_DOUBLE), intent(in)  :: a(:), y(:)
      complex(kind=MF_DOUBLE), intent(out) :: x(:)
      !------ API end ------

      !-----------------------------------------------------------------
      ! (complex/complex version of 'triusol')
      !-----------------------------------------------------------------

      integer :: j, k, irow
      complex(kind=MF_DOUBLE) :: t, diag

   !------ end of declarations -- execution starts hereafter  ------

      if( _MF_LOC_ANY_OBJ_(x) /= _MF_LOC_ANY_OBJ_(y) ) then
         do k = 1, n
            x(k) = y(k)
         end do
      end if

      do j = n, 2, -1
         k = ja(j+1)-1
         if( k > ja(j)-1 ) then
            ! column non empty
            irow = ia(k)
            if( irow == j ) then
               diag = a(k)
            else if( irow > j ) then
               ! matrix is not upper triangular
               write(STDERR,*) "(MUESLI:) triusol_c_c: internal error :"
               write(STDERR,*) "          not a upper triangular matrix!"
               mf_message_displayed = .true.
               call muesli_trace( pause="yes" )
               stop
            else
               ! not a diagonal element -> diagonal value is zero
               diag = (0.0d0,0.0d0)
            end if
         else
            ! empty column
            diag = (0.0d0,0.0d0)
         end if
         x(j) = x(j) / diag
         t = x(j)
         do k = ja(j), ja(j+1)-2
            irow = ia(k)
            x(irow) = x(irow) - t*a(k)
         end do
      end do

      if( ja(2) == 1 ) then
         ! empty column
         diag = (0.0d0,0.0d0)
      else
         ! first column non empty: it is necessarily the diagonal term
         diag = a(1)
      end if
      x(1) = x(1) / diag

   end subroutine triusol_c_c
!_______________________________________________________________________
!
   subroutine triusol_r_c( n, x, y, a, ja, ia )

      integer,                 intent(in)  :: n, ia(:), ja(:)
      real(kind=MF_DOUBLE),    intent(in)  :: a(:)
      complex(kind=MF_DOUBLE), intent(in)  :: y(:)
      complex(kind=MF_DOUBLE), intent(out) :: x(:)
      !------ API end ------

      !-----------------------------------------------------------------
      ! (real/complex version of 'triusol')
      !-----------------------------------------------------------------

      integer :: j, k, irow
      complex(kind=MF_DOUBLE) :: t, diag

   !------ end of declarations -- execution starts hereafter  ------

      if( _MF_LOC_ANY_OBJ_(x) /= _MF_LOC_ANY_OBJ_(y) ) then
         do k = 1, n
            x(k) = y(k)
         end do
      end if

      do j = n, 2, -1
         k = ja(j+1)-1
         if( k > ja(j)-1 ) then
            ! column non empty
            irow = ia(k)
            if( irow == j ) then
               diag = a(k)
            else if( irow > j ) then
               ! matrix is not upper triangular
               write(STDERR,*) "(MUESLI:) triusol_r_c: internal error :"
               write(STDERR,*) "          not a upper triangular matrix!"
               mf_message_displayed = .true.
               call muesli_trace( pause="yes" )
               stop
            else
               ! not a diagonal element -> diagonal value is zero
               diag = (0.0d0,0.0d0)
            end if
         else
            ! empty column
            diag = (0.0d0,0.0d0)
         end if
         x(j) = x(j) / diag
         t = x(j)
         do k = ja(j), ja(j+1)-2
            irow = ia(k)
            x(irow) = x(irow) - t*a(k)
         end do
      end do

      if( ja(2) == 1 ) then
         ! empty column
         diag = (0.0d0,0.0d0)
      else
         ! first column non empty: it is necessarily the diagonal term
         diag = a(1)
      end if
      x(1) = x(1) / diag

   end subroutine triusol_r_c
!_______________________________________________________________________
!
   subroutine triusol_nrhs( n, x, y, a, ja, ia )

      integer,              intent(in)  :: n, ia(:), ja(:)
      real(kind=MF_DOUBLE), intent(in)  :: a(:), y(:,:)
      real(kind=MF_DOUBLE), intent(out) :: x(:,:)
      !------ API end ------

      !-----------------------------------------------------------------
      ! solves    U x = y ;      U = upper triang
      !                          with multiple right hand sides
      ! É. Canot, Mars 2010
      ! (adpated from SPARSKIT2 (Mar 8 2005) 'usolc' by É. Canot)
      !-----------------------------------------------------------------
      ! on entry:
      !----------
      ! n = nb of col of the matrix U.
      ! a, ia, ja = matrix U in CSC format.
      ! y = array containing the right hand side.
      !
      ! on return:
      !-----------
      ! x = solution.
      !-----------------------------------------------------------------
      ! U must be square and row sorted.

      ! accepts that x(:,:) and y(:,:) are the same object, i.e. have
      ! the same address

      integer :: j, k, irow
      real(kind=MF_DOUBLE) :: diag

   !------ end of declarations -- execution starts hereafter  ------

      if( _MF_LOC_ANY_OBJ_(x) /= _MF_LOC_ANY_OBJ_(y) ) then
         x(:,:) = y(:,:)
      end if

      do j = n, 2, -1
         k = ja(j+1)-1
         if( k > ja(j)-1 ) then
            ! column non empty
            irow = ia(k)
            if( irow == j ) then
               diag = a(k)
            else if( irow > j ) then
               ! matrix is not upper triangular
               write(STDERR,*) "(MUESLI:) triusol_nrhs: internal error :"
               write(STDERR,*) "          not a upper triangular matrix!"
               mf_message_displayed = .true.
               call muesli_trace( pause="yes" )
               stop
            else
               ! not a diagonal element -> diagonal value is zero
               diag = 0.0d0
            end if
         else
            ! empty column
            diag = 0.0d0
         end if
         x(j,:) = x(j,:) / diag
         do k = ja(j), ja(j+1)-2
            irow = ia(k)
            x(irow,:) = x(irow,:) - x(j,:)*a(k)
         end do
      end do

      if( ja(2) == 1 ) then
         ! empty column
         diag = 0.0d0
      else
         ! first column non empty: it is necessarily the diagonal term
         diag = a(1)
      end if
      x(1,:) = x(1,:) / diag

   end subroutine triusol_nrhs
!_______________________________________________________________________
!
   subroutine triusol_nrhs_c_c( n, x, y, a, ja, ia )

      integer,                 intent(in)  :: n, ia(:), ja(:)
      complex(kind=MF_DOUBLE), intent(in)  :: a(:), y(:,:)
      complex(kind=MF_DOUBLE), intent(out) :: x(:,:)
      !------ API end ------

      !-----------------------------------------------------------------
      ! (complex/complex version of 'triusol_nrhs')
      !-----------------------------------------------------------------

      integer :: j, k, irow
      complex(kind=MF_DOUBLE) :: diag

   !------ end of declarations -- execution starts hereafter  ------

      if( _MF_LOC_ANY_OBJ_(x) /= _MF_LOC_ANY_OBJ_(y) ) then
         x(:,:) = y(:,:)
      end if

      do j = n, 2, -1
         k = ja(j+1)-1
         if( k > ja(j)-1 ) then
            ! column non empty
            irow = ia(k)
            if( irow == j ) then
               diag = a(k)
            else if( irow > j ) then
               ! matrix is not upper triangular
               write(STDERR,*) "(MUESLI:) triusol_nrhs_c_c: internal error :"
               write(STDERR,*) "          not a upper triangular matrix!"
               mf_message_displayed = .true.
               call muesli_trace( pause="yes" )
               stop
            else
               ! not a diagonal element -> diagonal value is zero
               diag = (0.0d0,0.0d0)
            end if
         else
            ! empty column
            diag = (0.0d0,0.0d0)
         end if
         x(j,:) = x(j,:) / diag
         do k = ja(j), ja(j+1)-2
            irow = ia(k)
            x(irow,:) = x(irow,:) - x(j,:)*a(k)
         end do
      end do

      if( ja(2) == 1 ) then
         ! empty column
         diag = (0.0d0,0.0d0)
      else
         ! first column non empty: it is necessarily the diagonal term
         diag = a(1)
      end if
      x(1,:) = x(1,:) / diag

   end subroutine triusol_nrhs_c_c
!_______________________________________________________________________
!
   subroutine triusol_nrhs_r_c( n, x, y, a, ja, ia )

      integer,                 intent(in)  :: n, ia(:), ja(:)
      real(kind=MF_DOUBLE),    intent(in)  :: a(:)
      complex(kind=MF_DOUBLE), intent(in)  :: y(:,:)
      complex(kind=MF_DOUBLE), intent(out) :: x(:,:)
      !------ API end ------

      !-----------------------------------------------------------------
      ! (real/complex version of 'triusol_nrhs')
      !-----------------------------------------------------------------

      integer :: j, k, irow
      complex(kind=MF_DOUBLE) :: diag

   !------ end of declarations -- execution starts hereafter  ------

      if( _MF_LOC_ANY_OBJ_(x) /= _MF_LOC_ANY_OBJ_(y) ) then
         x(:,:) = y(:,:)
      end if

      do j = n, 2, -1
         k = ja(j+1)-1
         if( k > ja(j)-1 ) then
            ! column non empty
            irow = ia(k)
            if( irow == j ) then
               diag = a(k)
            else if( irow > j ) then
               ! matrix is not upper triangular
               write(STDERR,*) "(MUESLI:) triusol_nrhs_r_c: internal error :"
               write(STDERR,*) "          not a upper triangular matrix!"
               mf_message_displayed = .true.
               call muesli_trace( pause="yes" )
               stop
            else
               ! not a diagonal element -> diagonal value is zero
               diag = (0.0d0,0.0d0)
            end if
         else
            ! empty column
            diag = (0.0d0,0.0d0)
         end if
         x(j,:) = x(j,:) / diag
         do k = ja(j), ja(j+1)-2
            irow = ia(k)
            x(irow,:) = x(irow,:) - x(j,:)*a(k)
         end do
      end do

      if( ja(2) == 1 ) then
         ! empty column
         diag = (0.0d0,0.0d0)
      else
         ! first column non empty: it is necessarily the diagonal term
         diag = a(1)
      end if
      x(1,:) = x(1,:) / diag

   end subroutine triusol_nrhs_r_c
!_______________________________________________________________________
!
   subroutine triusol_transp( n, x, y, a, ja, ia )

      integer,              intent(in)  :: n, ia(:), ja(:)
      real(kind=MF_DOUBLE), intent(in)  :: a(:), y(:)
      real(kind=MF_DOUBLE), intent(out) :: x(:)
      !------ API end ------

      !-----------------------------------------------------------------
      ! solves    x U = y ;      U = upper triang
      ! É. Canot, Mars 2010
      ! (adpated from SPARSKIT2 (Mar 8 2005) 'usolc' by É. Canot)
      !-----------------------------------------------------------------
      ! on entry:
      !----------
      ! n = nb of col of the matrix U.
      ! a, ia, ja = matrix U in CSC format.
      ! y = array containing the right hand side.
      !
      ! on return:
      !-----------
      ! x = solution.
      !-----------------------------------------------------------------
      ! U must be square and row sorted.

      ! accepts that x(:) and y(:) are the same object, i.e. have
      ! the same address

      integer :: j, k, irow
      real(kind=MF_DOUBLE) :: diag

   !------ end of declarations -- execution starts hereafter  ------

      if( _MF_LOC_ANY_OBJ_(x) /= _MF_LOC_ANY_OBJ_(y) ) then
         do k = 1, n
            x(k) = y(k)
         end do
      end if

      if( ja(2) == 1 ) then
         ! empty column
         diag = 0.0d0
      else
         ! first column non empty: it is necessarily the diagonal term
         diag = a(1)
      end if
      x(1) = x(1) / diag

      do j = 2, n
         do k = ja(j), ja(j+1)-2
            x(j) = x(j) - a(k)*x(ia(k))
         end do
         k = ja(j+1)-1
         if( k > ja(j)-1 ) then
            ! column non empty
            irow = ia(k)
            if( irow == j ) then
               diag = a(k)
            else if( irow > j ) then
               ! matrix is not upper triangular
               write(STDERR,*) "(MUESLI:) triusol_transp: internal error :"
               write(STDERR,*) "          not a upper triangular matrix!"
               mf_message_displayed = .true.
               call muesli_trace( pause="yes" )
               stop
            else
               ! not a diagonal element -> diagonal value is zero
               diag = 0.0d0
            end if
         else
            ! empty column
            diag = 0.0d0
         end if
         x(j) = x(j) / diag
      end do

   end subroutine triusol_transp
!_______________________________________________________________________
!
   subroutine triusol_transp_c_c( n, x, y, a, ja, ia )

      integer,                 intent(in)  :: n, ia(:), ja(:)
      complex(kind=MF_DOUBLE), intent(in)  :: a(:), y(:)
      complex(kind=MF_DOUBLE), intent(out) :: x(:)
      !------ API end ------

      !-----------------------------------------------------------------
      ! (complex/complex version of 'triusol_transp')
      !-----------------------------------------------------------------

      integer :: j, k, irow
      complex(kind=MF_DOUBLE) :: diag

   !------ end of declarations -- execution starts hereafter  ------

      if( _MF_LOC_ANY_OBJ_(x) /= _MF_LOC_ANY_OBJ_(y) ) then
         do k = 1, n
            x(k) = y(k)
         end do
      end if

      if( ja(2) == 1 ) then
         ! empty column
         diag = (0.0d0,0.0d0)
      else
         ! first column non empty: it is necessarily the diagonal term
         diag = a(1)
      end if
      x(1) = x(1) / diag

      do j = 2, n
         do k = ja(j), ja(j+1)-2
            x(j) = x(j) - a(k)*x(ia(k))
         end do
         k = ja(j+1)-1
         if( k > ja(j)-1 ) then
            ! column non empty
            irow = ia(k)
            if( irow == j ) then
               diag = a(k)
            else if( irow > j ) then
               ! matrix is not upper triangular
               write(STDERR,*) "(MUESLI:) triusol_transp_c_c: internal error :"
               write(STDERR,*) "          not a upper triangular matrix!"
               mf_message_displayed = .true.
               call muesli_trace( pause="yes" )
               stop
            else
               ! not a diagonal element -> diagonal value is zero
               diag = (0.0d0,0.0d0)
            end if
         else
            ! empty column
            diag = (0.0d0,0.0d0)
         end if
         x(j) = x(j) / diag
      end do

   end subroutine triusol_transp_c_c
!_______________________________________________________________________
!
   subroutine triusol_transp_r_c( n, x, y, a, ja, ia )

      integer,                 intent(in)  :: n, ia(:), ja(:)
      real(kind=MF_DOUBLE),    intent(in)  :: a(:)
      complex(kind=MF_DOUBLE), intent(in)  :: y(:)
      complex(kind=MF_DOUBLE), intent(out) :: x(:)
      !------ API end ------

      !-----------------------------------------------------------------
      ! (real/complex version of 'triusol_transp')
      !-----------------------------------------------------------------

      integer :: j, k, irow
      complex(kind=MF_DOUBLE) :: diag

   !------ end of declarations -- execution starts hereafter  ------

      if( _MF_LOC_ANY_OBJ_(x) /= _MF_LOC_ANY_OBJ_(y) ) then
         do k = 1, n
            x(k) = y(k)
         end do
      end if

      if( ja(2) == 1 ) then
         ! empty column
         diag = (0.0d0,0.0d0)
      else
         ! first column non empty: it is necessarily the diagonal term
         diag = a(1)
      end if
      x(1) = x(1) / diag

      do j = 2, n
         do k = ja(j), ja(j+1)-2
            x(j) = x(j) - a(k)*x(ia(k))
         end do
         k = ja(j+1)-1
         if( k > ja(j)-1 ) then
            ! column non empty
            irow = ia(k)
            if( irow == j ) then
               diag = a(k)
            else if( irow > j ) then
               ! matrix is not upper triangular
               write(STDERR,*) "(MUESLI:) triusol_transp_r_c: internal error :"
               write(STDERR,*) "          not a upper triangular matrix!"
               mf_message_displayed = .true.
               call muesli_trace( pause="yes" )
               stop
            else
               ! not a diagonal element -> diagonal value is zero
               diag = (0.0d0,0.0d0)
            end if
         else
            ! empty column
            diag = (0.0d0,0.0d0)
         end if
         x(j) = x(j) / diag
      end do

   end subroutine triusol_transp_r_c
!_______________________________________________________________________
!
   subroutine triusol_transp_nrhs( n, x, y, a, ja, ia )

      integer,              intent(in)  :: n, ia(:), ja(:)
      real(kind=MF_DOUBLE), intent(in)  :: a(:), y(:,:)
      real(kind=MF_DOUBLE), intent(out) :: x(:,:)
      !------ API end ------

      !-----------------------------------------------------------------
      ! solves    x U = y ;      U = upper triang
      !                          with multiple right hand sides
      ! É. Canot, Mars 2010
      ! (adpated from SPARSKIT2 (Mar 8 2005) 'usolc' by É. Canot)
      !-----------------------------------------------------------------
      ! on entry:
      !----------
      ! n = nb of col of the matrix U.
      ! a, ia, ja = matrix U in CSC format.
      ! y = array containing the right hand side.
      !
      ! on return:
      !-----------
      ! x = solution.
      !-----------------------------------------------------------------
      ! U must be square and row sorted.

      ! accepts that x(:) and y(:) are the same object, i.e. have
      ! the same address

      integer :: j, k, irow
      real(kind=MF_DOUBLE) :: diag

   !------ end of declarations -- execution starts hereafter  ------

      if( _MF_LOC_ANY_OBJ_(x) /= _MF_LOC_ANY_OBJ_(y) ) then
         x(:,:) = y(:,:)
      end if

      if( ja(2) == 1 ) then
         ! empty column
         diag = 0.0d0
      else
         ! first column non empty: it is necessarily the diagonal term
         diag = a(1)
      end if
      x(:,1) = x(:,1) / diag

      do j = 2, n
         do k = ja(j), ja(j+1)-2
            x(:,j) = x(:,j) - a(k)*x(:,ia(k))
         end do
         k = ja(j+1)-1
         if( k > ja(j)-1 ) then
            ! column non empty
            irow = ia(k)
            if( irow == j ) then
               diag = a(k)
            else if( irow > j ) then
               ! matrix is not upper triangular
               write(STDERR,*) "(MUESLI:) triusol_transp_nrhs: internal error :"
               write(STDERR,*) "          not a upper triangular matrix!"
               mf_message_displayed = .true.
               call muesli_trace( pause="yes" )
               stop
            else
               ! not a diagonal element -> diagonal value is zero
               diag = 0.0d0
            end if
         else
            ! empty column
            diag = 0.0d0
         end if
         x(:,j) = x(:,j) / diag
      end do

   end subroutine triusol_transp_nrhs
!_______________________________________________________________________
!
   subroutine triusol_transp_nrhs_c_c( n, x, y, a, ja, ia )

      integer,                 intent(in)  :: n, ia(:), ja(:)
      complex(kind=MF_DOUBLE), intent(in)  :: a(:), y(:,:)
      complex(kind=MF_DOUBLE), intent(out) :: x(:,:)
      !------ API end ------

      !-----------------------------------------------------------------
      ! (complex/complex version of 'triusol_transp_nrhs')
      !-----------------------------------------------------------------

      integer :: j, k, irow
      complex(kind=MF_DOUBLE) :: diag

   !------ end of declarations -- execution starts hereafter  ------

      if( _MF_LOC_ANY_OBJ_(x) /= _MF_LOC_ANY_OBJ_(y) ) then
         x(:,:) = y(:,:)
      end if

      if( ja(2) == 1 ) then
         ! empty column
         diag = (0.0d0,0.0d0)
      else
         ! first column non empty: it is necessarily the diagonal term
         diag = a(1)
      end if
      x(:,1) = x(:,1) / diag

      do j = 2, n
         do k = ja(j), ja(j+1)-2
            x(:,j) = x(:,j) - a(k)*x(:,ia(k))
         end do
         k = ja(j+1)-1
         if( k > ja(j)-1 ) then
            ! column non empty
            irow = ia(k)
            if( irow == j ) then
               diag = a(k)
            else if( irow > j ) then
               ! matrix is not upper triangular
               write(STDERR,*) "(MUESLI:) triusol_transp_nrhs_c_c: internal error :"
               write(STDERR,*) "          not a upper triangular matrix!"
               mf_message_displayed = .true.
               call muesli_trace( pause="yes" )
               stop
            else
               ! not a diagonal element -> diagonal value is zero
               diag = (0.0d0,0.0d0)
            end if
         else
            ! empty column
            diag = (0.0d0,0.0d0)
         end if
         x(:,j) = x(:,j) / diag
      end do

   end subroutine triusol_transp_nrhs_c_c
!_______________________________________________________________________
!
   subroutine triusol_transp_nrhs_r_c( n, x, y, a, ja, ia )

      integer,                 intent(in)  :: n, ia(:), ja(:)
      real(kind=MF_DOUBLE),    intent(in)  :: a(:)
      complex(kind=MF_DOUBLE), intent(in)  :: y(:,:)
      complex(kind=MF_DOUBLE), intent(out) :: x(:,:)
      !------ API end ------

      !-----------------------------------------------------------------
      ! (real/complex version of 'triusol_transp_nrhs')
      !-----------------------------------------------------------------

      integer :: j, k, irow
      complex(kind=MF_DOUBLE) :: diag

   !------ end of declarations -- execution starts hereafter  ------

      if( _MF_LOC_ANY_OBJ_(x) /= _MF_LOC_ANY_OBJ_(y) ) then
         x(:,:) = y(:,:)
      end if

      if( ja(2) == 1 ) then
         ! empty column
         diag = (0.0d0,0.0d0)
      else
         ! first column non empty: it is necessarily the diagonal term
         diag = a(1)
      end if
      x(:,1) = x(:,1) / diag

      do j = 2, n
         do k = ja(j), ja(j+1)-2
            x(:,j) = x(:,j) - a(k)*x(:,ia(k))
         end do
         k = ja(j+1)-1
         if( k > ja(j)-1 ) then
            ! column non empty
            irow = ia(k)
            if( irow == j ) then
               diag = a(k)
            else if( irow > j ) then
               ! matrix is not upper triangular
               write(STDERR,*) "(MUESLI:) triusol_transp_nrhs_r_c: internal error :"
               write(STDERR,*) "          not a upper triangular matrix!"
               mf_message_displayed = .true.
               call muesli_trace( pause="yes" )
               stop
            else
               ! not a diagonal element -> diagonal value is zero
               diag = (0.0d0,0.0d0)
            end if
         else
            ! empty column
            diag = (0.0d0,0.0d0)
         end if
         x(:,j) = x(:,j) / diag
      end do

   end subroutine triusol_transp_nrhs_r_c

