! f90 include file

! Warning: 08 dec 2014 -- only the 'trilsol' routine has been fixed
!          for the case of a singular matrix A (having some diagonal
!          values being zero). We think that this special case is rare
!          so the fix for other routines can be delayed...
!

!_______________________________________________________________________
!
   subroutine trilsol( n, x, y, a, ja, ia )

      integer,              intent(in)  :: n, ia(:), ja(:)
      real(kind=MF_DOUBLE), intent(in)  :: a(:), y(:)
      real(kind=MF_DOUBLE), intent(out) :: x(:)
      !------ API end ------

      !-----------------------------------------------------------------
      ! solves    L x = y ;      L = lower triangular
      ! É. Canot, Mars 2010
      ! (adpated from SPARSKIT2 (Mar 8 2005) 'lsolc' by É. Canot)
      !-----------------------------------------------------------------
      ! on entry:
      !----------
      ! n = nb of col of the matrix L.
      ! a, ia, ja = matrix L in CSC format.
      ! y = array containing the right hand side.
      !
      ! on return:
      !-----------
      ! x = solution.
      !
      ! In the case of a singular matrix, this algorithm returns a
      ! plausible solution. By comparison, 'Octave' returns a finite
      ! vector (whose some values are wrong) and 'Matlab' returns a
      ! vector containing many NaNs, as if it wanted to give a cautious
      ! answer.
      !-----------------------------------------------------------------
      ! L must be square and row sorted.

      ! accepts that x(:) and y(:) are the same object, i.e. have
      ! the same address

      integer :: j, k, irow, shift
      real(kind=MF_DOUBLE) :: t, diag

   !------ end of declarations -- execution starts hereafter  ------

      if( _MF_LOC_ANY_OBJ_(x) /= _MF_LOC_ANY_OBJ_(y) ) then
         do k = 1, n
            x(k) = y(k)
         end do
      end if

      do j = 1, n-1
         ! inspect the first entry in the column
         k = ja(j)
         if( ja(j+1) > k ) then
            ! column non empty
            irow = ia(k)
            if( irow == j ) then
               diag = a(k)
               shift = 1
            else if( irow < j ) then
               ! matrix is not lower triangular
               write(STDERR,*) "(MUESLI:) trilsol: internal error :"
               write(STDERR,*) "          not a lower triangular matrix!"
               mf_message_displayed = .true.
               call muesli_trace( pause="yes" )
               stop
            else
               ! not a diagonal element -> diagonal value is zero
               diag = 0.0d0
               shift = 0
            end if
         else
            ! empty column
            diag = 0.0d0
         end if
         x(j) = x(j) / diag
         t = x(j)
         do k = ja(j)+shift, ja(j+1)-1
            irow = ia(k)
            x(irow) = x(irow) - t*a(k)
         end do
      end do

      k = ja(n)
      if( ja(n+1) > k ) then
         ! last column non empty: it is necessarily the diagonal term
         diag = a(k)
      else
         ! empty column
         diag = 0.0d0
      end if
      x(n) = x(n) / diag

   end subroutine trilsol
!_______________________________________________________________________
!
   subroutine trilsol_c_c( n, x, y, a, ja, ia )

      integer,                 intent(in)  :: n, ia(:), ja(:)
      complex(kind=MF_DOUBLE), intent(in)  :: a(:), y(:)
      complex(kind=MF_DOUBLE), intent(out) :: x(:)
      !------ API end ------

      !-----------------------------------------------------------------
      ! (complex/complex version of 'trilsol')
      !-----------------------------------------------------------------

      integer :: j, k, irow
      complex(kind=MF_DOUBLE) :: t, diag

   !------ end of declarations -- execution starts hereafter  ------

      if( _MF_LOC_ANY_OBJ_(x) /= _MF_LOC_ANY_OBJ_(y) ) then
         do k = 1, n
            x(k) = y(k)
         end do
      end if

      do j = 1, n-1
         k = ja(j)
         if( ja(j+1) > k ) then
            ! column non empty
            irow = ia(k)
            if( irow == j ) then
               diag = a(k)
            else if( irow < j ) then
               ! matrix is not lower triangular
               write(STDERR,*) "(MUESLI:) trilsol_c_c: internal error :"
               write(STDERR,*) "          not a lower triangular matrix!"
               mf_message_displayed = .true.
               call muesli_trace( pause="yes" )
               stop
            else
               ! not a diagonal element -> diagonal value is zero
               diag = (0.0d0,0.0d0)
            end if
         else
            ! empty column
            diag = (0.0d0,0.0d0)
         end if
         x(j) = x(j) / diag
         t = x(j)
         do k = ja(j)+1, ja(j+1)-1
            irow = ia(k)
            x(irow) = x(irow) - t*a(k)
         end do
      end do

      k = ja(n)
      if( ja(n+1) > k ) then
         ! last column non empty: it is necessarily the diagonal term
         diag = a(k)
      else
         ! empty column
         diag = (0.0d0,0.0d0)
      end if
      x(n) = x(n) / diag

   end subroutine trilsol_c_c
!_______________________________________________________________________
!
   subroutine trilsol_r_c( n, x, y, a, ja, ia )

      integer,                 intent(in)  :: n, ia(:), ja(:)
      real(kind=MF_DOUBLE),    intent(in)  :: a(:)
      complex(kind=MF_DOUBLE), intent(in)  :: y(:)
      complex(kind=MF_DOUBLE), intent(out) :: x(:)
      !------ API end ------

      !-----------------------------------------------------------------
      ! (real/complex version of 'trilsol')
      !-----------------------------------------------------------------

      integer :: j, k, irow
      complex(kind=MF_DOUBLE) :: t, diag

   !------ end of declarations -- execution starts hereafter  ------

      if( _MF_LOC_ANY_OBJ_(x) /= _MF_LOC_ANY_OBJ_(y) ) then
         do k = 1, n
            x(k) = y(k)
         end do
      end if

      do j = 1, n-1
         k = ja(j)
         if( ja(j+1) > k ) then
            ! column non empty
            irow = ia(k)
            if( irow == j ) then
               diag = a(k)
            else if( irow < j ) then
               ! matrix is not lower triangular
               write(STDERR,*) "(MUESLI:) trilsol_r_c: internal error :"
               write(STDERR,*) "          not a lower triangular matrix!"
               mf_message_displayed = .true.
               call muesli_trace( pause="yes" )
               stop
            else
               ! not a diagonal element -> diagonal value is zero
               diag = (0.0d0,0.0d0)
            end if
         else
            ! empty column
            diag = (0.0d0,0.0d0)
         end if
         x(j) = x(j) / diag
         t = x(j)
         do k = ja(j)+1, ja(j+1)-1
            irow = ia(k)
            x(irow) = x(irow) - t*a(k)
         end do
      end do

      k = ja(n)
      if( ja(n+1) > k ) then
         ! last column non empty: it is necessarily the diagonal term
         diag = a(k)
      else
         ! empty column
         diag = (0.0d0,0.0d0)
      end if
      x(n) = x(n) / diag

   end subroutine trilsol_r_c
!_______________________________________________________________________
!
   subroutine trilsol_nrhs( n, x, y, a, ja, ia )

      integer,              intent(in)  :: n, ia(:), ja(:)
      real(kind=MF_DOUBLE), intent(in)  :: a(:), y(:,:)
      real(kind=MF_DOUBLE), intent(out) :: x(:,:)
      !------ API end ------

      !-----------------------------------------------------------------
      ! solves    L x = y ;      L = lower triangular
      !                          with multiple right hand sides
      ! É. Canot, Mars 2010
      ! (adpated from SPARSKIT2 (Mar 8 2005) 'lsolc' by É. Canot)
      !-----------------------------------------------------------------
      ! on entry:
      !----------
      ! n = nb of col of the matrix L.
      ! a, ia, ja = matrix L in CSC format.
      ! y = array containing the right hand side.
      !
      ! on return:
      !-----------
      ! x = solution.
      !-----------------------------------------------------------------
      ! L must be square and row sorted.

      ! accepts that x(:,:) and y(:,:) are the same object, i.e. have
      ! the same address

      integer :: j, k, irow
      real(kind=MF_DOUBLE) :: diag

   !------ end of declarations -- execution starts hereafter  ------

      if( _MF_LOC_ANY_OBJ_(x) /= _MF_LOC_ANY_OBJ_(y) ) then
         x(:,:) = y(:,:)
      end if

      do j = 1, n-1
         k = ja(j)
         if( ja(j+1) > k ) then
            ! column non empty
            irow = ia(k)
            if( irow == j ) then
               diag = a(k)
            else if( irow < j ) then
               ! matrix is not lower triangular
               write(STDERR,*) "(MUESLI:) trilsol_nrhs: internal error :"
               write(STDERR,*) "          not a lower triangular matrix!"
               mf_message_displayed = .true.
               call muesli_trace( pause="yes" )
               stop
            else
               ! not a diagonal element -> diagonal value is zero
               diag = 0.0d0
            end if
         else
            ! empty column
            diag = 0.0d0
         end if
         x(j,:) = x(j,:) / diag
         do k = ja(j)+1, ja(j+1)-1
            irow = ia(k)
            x(irow,:) = x(irow,:) - x(j,:)*a(k)
         end do
      end do

      k = ja(n)
      if( ja(n+1) > k ) then
         ! last column non empty: it is necessarily the diagonal term
         diag = a(k)
      else
         ! empty column
         diag = 0.0d0
      end if
      x(n,:) = x(n,:) / diag

   end subroutine trilsol_nrhs
!_______________________________________________________________________
!
   subroutine trilsol_nrhs_c_c( n, x, y, a, ja, ia )

      integer,                 intent(in)  :: n, ia(:), ja(:)
      complex(kind=MF_DOUBLE), intent(in)  :: a(:), y(:,:)
      complex(kind=MF_DOUBLE), intent(out) :: x(:,:)
      !------ API end ------

      !-----------------------------------------------------------------
      ! (complex/complex version of 'trilsol_nrhs')
      !-----------------------------------------------------------------

      integer :: j, k, irow
      complex(kind=MF_DOUBLE) :: diag

   !------ end of declarations -- execution starts hereafter  ------

      if( _MF_LOC_ANY_OBJ_(x) /= _MF_LOC_ANY_OBJ_(y) ) then
         x(:,:) = y(:,:)
      end if

      do j = 1, n-1
         k = ja(j)
         if( ja(j+1) > k ) then
            ! column non empty
            irow = ia(k)
            if( irow == j ) then
               diag = a(k)
            else if( irow < j ) then
               ! matrix is not lower triangular
               write(STDERR,*) "(MUESLI:) trilsol_nrhs_c_c: internal error :"
               write(STDERR,*) "          not a lower triangular matrix!"
               mf_message_displayed = .true.
               call muesli_trace( pause="yes" )
               stop
            else
               ! not a diagonal element -> diagonal value is zero
               diag = (0.0d0,0.0d0)
            end if
         else
            ! empty column
            diag = (0.0d0,0.0d0)
         end if
         x(j,:) = x(j,:) / diag
         do k = ja(j)+1, ja(j+1)-1
            irow = ia(k)
            x(irow,:) = x(irow,:) - x(j,:)*a(k)
         end do
      end do

      k = ja(n)
      if( ja(n+1) > k ) then
         ! last column non empty: it is necessarily the diagonal term
         diag = a(k)
      else
         ! empty column
         diag = (0.0d0,0.0d0)
      end if
      x(n,:) = x(n,:) / diag

   end subroutine trilsol_nrhs_c_c
!_______________________________________________________________________
!
   subroutine trilsol_nrhs_r_c( n, x, y, a, ja, ia )

      integer,                 intent(in)  :: n, ia(:), ja(:)
      real(kind=MF_DOUBLE),    intent(in)  :: a(:)
      complex(kind=MF_DOUBLE), intent(in)  :: y(:,:)
      complex(kind=MF_DOUBLE), intent(out) :: x(:,:)
      !------ API end ------

      !-----------------------------------------------------------------
      ! (real/complex version of 'trilsol_nrhs')
      !-----------------------------------------------------------------

      integer :: j, k, irow
      complex(kind=MF_DOUBLE) :: diag

   !------ end of declarations -- execution starts hereafter  ------

      if( _MF_LOC_ANY_OBJ_(x) /= _MF_LOC_ANY_OBJ_(y) ) then
         x(:,:) = y(:,:)
      end if

      do j = 1, n-1
         k = ja(j)
         if( ja(j+1) > k ) then
            ! column non empty
            irow = ia(k)
            if( irow == j ) then
               diag = a(k)
            else if( irow < j ) then
               ! matrix is not lower triangular
               write(STDERR,*) "(MUESLI:) trilsol_nrhs_r_c: internal error :"
               write(STDERR,*) "          not a lower triangular matrix!"
               mf_message_displayed = .true.
               call muesli_trace( pause="yes" )
               stop
            else
               ! not a diagonal element -> diagonal value is zero
               diag = (0.0d0,0.0d0)
            end if
         else
            ! empty column
            diag = (0.0d0,0.0d0)
         end if
         x(j,:) = x(j,:) / diag
         do k = ja(j)+1, ja(j+1)-1
            irow = ia(k)
            x(irow,:) = x(irow,:) - x(j,:)*a(k)
         end do
      end do

      k = ja(n)
      if( ja(n+1) > k ) then
         ! last column non empty: it is necessarily the diagonal term
         diag = a(k)
      else
         ! empty column
         diag = (0.0d0,0.0d0)
      end if
      x(n,:) = x(n,:) / diag

   end subroutine trilsol_nrhs_r_c
!_______________________________________________________________________
!
   subroutine trilsol_transp( n, x, y, a, ja, ia )

      integer,              intent(in)  :: n, ia(:), ja(:)
      real(kind=MF_DOUBLE), intent(in)  :: a(:), y(:)
      real(kind=MF_DOUBLE), intent(out) :: x(:)
      !------ API end ------

      !-----------------------------------------------------------------
      ! solves    x L = y ;      L = lower triang
      ! É. Canot, Mars 2010
      ! (adpated from SPARSKIT2 (Mar 8 2005) 'usol' by É. Canot)
      !-----------------------------------------------------------------
      ! on entry:
      !----------
      ! n = nb of col of the matrix L.
      ! a, ia, ja = matrix L in CSC format.
      ! y = array containing the right hand side.
      !
      ! on return:
      !-----------
      ! x = solution.
      !-----------------------------------------------------------------
      ! L must be square and row sorted.

      ! accepts that x(:) and y(:) are the same object, i.e. have
      ! the same address

      integer :: j, k, irow
      real(kind=MF_DOUBLE) :: diag

   !------ end of declarations -- execution starts hereafter  ------

      if( _MF_LOC_ANY_OBJ_(x) /= _MF_LOC_ANY_OBJ_(y) ) then
         do k = 1, n
            x(k) = y(k)
         end do
      end if

      k = ja(n)
      if( ja(n+1) > k ) then
         ! last column non empty: it is necessarily the diagonal term
         diag = a(k)
      else
         ! empty column
         diag = 0.0d0
      end if
      x(n) = x(n) / diag

      do j = n-1, 1, -1
         do k = ja(j)+1, ja(j+1)-1
            x(j) = x(j) - a(k)*x(ia(k))
         end do
         k = ja(j)
         if( ja(j+1) > k ) then
            ! column non empty
            irow = ia(k)
            if( irow == j ) then
               diag = a(k)
            else if( irow < j ) then
               ! matrix is not lower triangular
               write(STDERR,*) "(MUESLI:) trilsol_transp: internal error :"
               write(STDERR,*) "          not a lower triangular matrix!"
               mf_message_displayed = .true.
               call muesli_trace( pause="yes" )
               stop
            else
               ! not a diagonal element -> diagonal value is zero
               diag = 0.0d0
            end if
         else
            ! empty column
            diag = 0.0d0
         end if
         x(j) = x(j) / diag
      end do

   end subroutine trilsol_transp
!_______________________________________________________________________
!
   subroutine trilsol_transp_c_c( n, x, y, a, ja, ia )

      integer,                 intent(in)  :: n, ia(:), ja(:)
      complex(kind=MF_DOUBLE), intent(in)  :: a(:), y(:)
      complex(kind=MF_DOUBLE), intent(out) :: x(:)
      !------ API end ------

      !-----------------------------------------------------------------
      ! (complex/complex version of 'trilsol_transp')
      !-----------------------------------------------------------------

      integer :: j, k, irow
      complex(kind=MF_DOUBLE) :: diag

   !------ end of declarations -- execution starts hereafter  ------

      if( _MF_LOC_ANY_OBJ_(x) /= _MF_LOC_ANY_OBJ_(y) ) then
         do k = 1, n
            x(k) = y(k)
         end do
      end if

      k = ja(n)
      if( ja(n+1) > k ) then
         ! last column non empty: it is necessarily the diagonal term
         diag = a(k)
      else
         ! empty column
         diag = (0.0d0,0.0d0)
      end if
      x(n) = x(n) / diag

      do j = n-1, 1, -1
         do k = ja(j)+1, ja(j+1)-1
            x(j) = x(j) - a(k)*x(ia(k))
         end do
         k = ja(j)
         if( ja(j+1) > k ) then
            ! column non empty
            irow = ia(k)
            if( irow == j ) then
               diag = a(k)
            else if( irow < j ) then
               ! matrix is not lower triangular
               write(STDERR,*) "(MUESLI:) trilsol_transp_c_c: internal error :"
               write(STDERR,*) "          not a lower triangular matrix!"
               mf_message_displayed = .true.
               call muesli_trace( pause="yes" )
               stop
            else
               ! not a diagonal element -> diagonal value is zero
               diag = (0.0d0,0.0d0)
            end if
         else
            ! empty column
            diag = (0.0d0,0.0d0)
         end if
         x(j) = x(j) / diag
      end do

   end subroutine trilsol_transp_c_c
!_______________________________________________________________________
!
   subroutine trilsol_transp_r_c( n, x, y, a, ja, ia )

      integer,                 intent(in)  :: n, ia(:), ja(:)
      real(kind=MF_DOUBLE),    intent(in)  :: a(:)
      complex(kind=MF_DOUBLE), intent(in)  :: y(:)
      complex(kind=MF_DOUBLE), intent(out) :: x(:)
      !------ API end ------

      !-----------------------------------------------------------------
      ! (real/complex version of 'trilsol_transp')
      !-----------------------------------------------------------------

      integer :: j, k, irow
      complex(kind=MF_DOUBLE) :: diag

   !------ end of declarations -- execution starts hereafter  ------

      if( _MF_LOC_ANY_OBJ_(x) /= _MF_LOC_ANY_OBJ_(y) ) then
         do k = 1, n
            x(k) = y(k)
         end do
      end if

      k = ja(n)
      if( ja(n+1) > k ) then
         ! last column non empty: it is necessarily the diagonal term
         diag = a(k)
      else
         ! empty column
         diag = (0.0d0,0.0d0)
      end if
      x(n) = x(n) / diag

      do j = n-1, 1, -1
         do k = ja(j)+1, ja(j+1)-1
            x(j) = x(j) - a(k)*x(ia(k))
         end do
         k = ja(j)
         if( ja(j+1) > k ) then
            ! column non empty
            irow = ia(k)
            if( irow == j ) then
               diag = a(k)
            else if( irow < j ) then
               ! matrix is not lower triangular
               write(STDERR,*) "(MUESLI:) trilsol_transp_r_c: internal error :"
               write(STDERR,*) "          not a lower triangular matrix!"
               mf_message_displayed = .true.
               call muesli_trace( pause="yes" )
               stop
            else
               ! not a diagonal element -> diagonal value is zero
               diag = (0.0d0,0.0d0)
            end if
         else
            ! empty column
            diag = (0.0d0,0.0d0)
         end if
         x(j) = x(j) / diag
      end do

   end subroutine trilsol_transp_r_c
!_______________________________________________________________________
!
   subroutine trilsol_transp_nrhs( n, x, y, a, ja, ia )

      integer,              intent(in)  :: n, ia(:), ja(:)
      real(kind=MF_DOUBLE), intent(in)  :: a(:), y(:,:)
      real(kind=MF_DOUBLE), intent(out) :: x(:,:)
      !------ API end ------

      !-----------------------------------------------------------------
      ! solves    x L = y ;      L = lower triang
      !                          with multiple right hand sides
      ! É. Canot, Mars 2010
      ! (adpated from SPARSKIT2 (Mar 8 2005) 'usol' by É. Canot)
      !-----------------------------------------------------------------
      ! on entry:
      !----------
      ! n = nb of col of the matrix L.
      ! a, ia, ja = matrix L in CSC format.
      ! y = array containing the right hand side.
      !
      ! on return:
      !-----------
      ! x = solution.
      !-----------------------------------------------------------------
      ! L must be square and row sorted.

      ! accepts that x(:,:) and y(:,:) are the same object, i.e. have
      ! the same address

      integer :: j, k, irow
      real(kind=MF_DOUBLE) :: diag

   !------ end of declarations -- execution starts hereafter  ------

      if( _MF_LOC_ANY_OBJ_(x) /= _MF_LOC_ANY_OBJ_(y) ) then
         x(:,:) = y(:,:)
      end if

      k = ja(n)
      if( ja(n+1) > k ) then
         ! last column non empty: it is necessarily the diagonal term
         diag = a(k)
      else
         ! empty column
         diag = 0.0d0
      end if
      x(:,n) = x(:,n) / diag

      do j = n-1, 1, -1
         do k = ja(j)+1, ja(j+1)-1
            x(:,j) = x(:,j) - a(k)*x(:,ia(k))
         end do
         k = ja(j)
         if( ja(j+1) > k ) then
            ! column non empty
            irow = ia(k)
            if( irow == j ) then
               diag = a(k)
            else if( irow < j ) then
               ! matrix is not lower triangular
               write(STDERR,*) "(MUESLI:) trilsol_transp_nrhs: internal error :"
               write(STDERR,*) "          not a lower triangular matrix!"
               mf_message_displayed = .true.
               call muesli_trace( pause="yes" )
               stop
            else
               ! not a diagonal element -> diagonal value is zero
               diag = 0.0d0
            end if
         else
            ! empty column
            diag = 0.0d0
         end if
         x(:,j) = x(:,j) / diag
      end do

   end subroutine trilsol_transp_nrhs
!_______________________________________________________________________
!
   subroutine trilsol_transp_nrhs_c_c( n, x, y, a, ja, ia )

      integer,                 intent(in)  :: n, ia(:), ja(:)
      complex(kind=MF_DOUBLE), intent(in)  :: a(:), y(:,:)
      complex(kind=MF_DOUBLE), intent(out) :: x(:,:)
      !------ API end ------

      !-----------------------------------------------------------------
      ! (complex/complex version of 'trilsol_transp_nrhs')
      !-----------------------------------------------------------------

      integer :: j, k, irow
      complex(kind=MF_DOUBLE) :: diag

   !------ end of declarations -- execution starts hereafter  ------

      if( _MF_LOC_ANY_OBJ_(x) /= _MF_LOC_ANY_OBJ_(y) ) then
         x(:,:) = y(:,:)
      end if

      k = ja(n)
      if( ja(n+1) > k ) then
         ! last column non empty: it is necessarily the diagonal term
         diag = a(k)
      else
         ! empty column
         diag = (0.0d0,0.0d0)
      end if
      x(:,n) = x(:,n) / diag

      do j = n-1, 1, -1
         do k = ja(j)+1, ja(j+1)-1
            x(:,j) = x(:,j) - a(k)*x(:,ia(k))
         end do
         k = ja(j)
         if( ja(j+1) > k ) then
            ! column non empty
            irow = ia(k)
            if( irow == j ) then
               diag = a(k)
            else if( irow < j ) then
               ! matrix is not lower triangular
               write(STDERR,*) "(MUESLI:) trilsol_transp_nrhs_c_c: internal error :"
               write(STDERR,*) "          not a lower triangular matrix!"
               mf_message_displayed = .true.
               call muesli_trace( pause="yes" )
               stop
            else
               ! not a diagonal element -> diagonal value is zero
               diag = (0.0d0,0.0d0)
            end if
         else
            ! empty column
            diag = (0.0d0,0.0d0)
         end if
         x(:,j) = x(:,j) / diag
      end do

   end subroutine trilsol_transp_nrhs_c_c
!_______________________________________________________________________
!
   subroutine trilsol_transp_nrhs_r_c( n, x, y, a, ja, ia )

      integer,                 intent(in)  :: n, ia(:), ja(:)
      real(kind=MF_DOUBLE),    intent(in)  :: a(:)
      complex(kind=MF_DOUBLE), intent(in)  :: y(:,:)
      complex(kind=MF_DOUBLE), intent(out) :: x(:,:)
      !------ API end ------

      !-----------------------------------------------------------------
      ! (real/complex version of 'trilsol_transp_nrhs')
      !-----------------------------------------------------------------

      integer :: j, k, irow
      complex(kind=MF_DOUBLE) :: diag

   !------ end of declarations -- execution starts hereafter  ------

      if( _MF_LOC_ANY_OBJ_(x) /= _MF_LOC_ANY_OBJ_(y) ) then
         x(:,:) = y(:,:)
      end if

      k = ja(n)
      if( ja(n+1) > k ) then
         ! last column non empty: it is necessarily the diagonal term
         diag = a(k)
      else
         ! empty column
         diag = (0.0d0,0.0d0)
      end if
      x(:,n) = x(:,n) / diag

      do j = n-1, 1, -1
         do k = ja(j)+1, ja(j+1)-1
            x(:,j) = x(:,j) - a(k)*x(:,ia(k))
         end do
         k = ja(j)
         if( ja(j+1) > k ) then
            ! column non empty
            irow = ia(k)
            if( irow == j ) then
               diag = a(k)
            else if( irow < j ) then
               ! matrix is not lower triangular
               write(STDERR,*) "(MUESLI:) trilsol_transp_nrhs_r_c: internal error :"
               write(STDERR,*) "          not a lower triangular matrix!"
               mf_message_displayed = .true.
               call muesli_trace( pause="yes" )
               stop
            else
               ! not a diagonal element -> diagonal value is zero
               diag = (0.0d0,0.0d0)
            end if
         else
            ! empty column
            diag = (0.0d0,0.0d0)
         end if
         x(:,j) = x(:,j) / diag
      end do

   end subroutine trilsol_transp_nrhs_r_c
