! f90 include file

!_______________________________________________________________________
!
   subroutine csc_transp( nrow, ncol, a, ia, ja, ao, iao, jao )

      integer,              intent(in)  :: nrow, ncol
      real(kind=MF_DOUBLE), intent(in)  :: a(:)
      integer,              intent(in)  :: ia(:), ja(:)
      real(kind=MF_DOUBLE), intent(out) :: ao(:)
      integer,              intent(out) :: iao(:), jao(:)
      !------ API end ------

      !-----------------------------------------------------------------
      ! Transpose a Compressed Sparse Column
      !
      ! (transposition operation)   Not in place.
      ! (adapted from SPARSKIT2 (Mar 8 2005) 'csrcsc2' by É. Canot)
      !-----------------------------------------------------------------
      ! -- not in place --
      ! this subroutine transposes a matrix stored in a, ia, ja format.
      ! ---------------
      ! on entry:
      !----------
      ! nrow = number of rows of the input matrix.
      ! ncol = number of columns of the input matrix.
      !
      ! a  = real array of length nnz (nnz=number of nonzero elements
      !      in input matrix) containing the nonzero elements.
      ! ia = integer array of length nnz containing the row positions
      !      of the corresponding elements in a.
      ! ja = integer of size ncol+1. ja(k) contains the position
      !      in a, ia of the beginning of the k-th col.
      !
      ! on return:
      ! ----------
      ! output arguments:
      ! ao  = real array of size nnz containing the "a" part of the
      !       transpose
      ! iao = integer array of size nnz containing the row indexes.
      ! jao = integer array of size nrow+1 (*) containing the "ja" index
      !       array of the transpose.
      ! (*) the ouput matrix has 'ncol' rows and 'nrow' columns !
      !
      ! note: by construction, indexes for ao are sorted, whatever the
      !       corresponding property of a.
      !-----------------------------------------------------------------

      integer :: i, j, k, next

   !------ end of declarations -- execution starts hereafter  ------

      ! compute lengths of cols of transp(A)
      do i = 2, nrow+1
         jao(i) = 0
      end do
      do j = 1, ncol
         do k = ja(j), ja(j+1)-1
            i = ia(k)+1 ! shift
            jao(i) = jao(i) + 1
         end do
      end do
      ! compute pointers from lengths
      jao(1) = 1
      do i = 1, nrow
         jao(i+1) = jao(i) + jao(i+1)
      end do

      ! now do the actual copying
      do j = 1, ncol
         do k = ja(j), ja(j+1)-1
            i = ia(k)
            next = jao(i)
            ao(next) = a(k)
            iao(next) = j
            jao(i) = next + 1
         end do
      end do

      do i = nrow, 1, -1
         jao(i+1) = jao(i)
      end do
      jao(1) = 1

   end subroutine csc_transp
!_______________________________________________________________________
!
   subroutine csc_transp_struct_only( nrow, ncol, ia, ja, iao, jao )

      integer,              intent(in)  :: nrow, ncol
      integer,              intent(in)  :: ia(:), ja(:)
      integer,              intent(out) :: iao(:), jao(:)
      !------ API end ------

      !-----------------------------------------------------------------
      ! Transpose a Compressed Sparse Column (without value)
      ! (actually used for importing a CSR matrix into the CSC format)
      !
      ! (transposition operation)   Not in place.
      ! (adapted from SPARSKIT2 (Mar 8 2005) 'csrcsc2' by É. Canot)
      !-----------------------------------------------------------------
      ! -- not in place --
      ! this subroutine transposes a matrix stored in ia, ja format.
      ! ---------------
      ! on entry:
      !----------
      ! nrow = number of rows of the input matrix.
      ! ncol = number of columns of the input matrix.
      !
      ! ia = integer array of length nnz containing the row positions
      !      of the corresponding elements in a.
      ! ja = integer of size ncol+1. ja(k) contains the position
      !      in a, ia of the beginning of the k-th col.
      !
      ! on return:
      ! ----------
      ! output arguments:
      ! iao = integer array of size nnz containing the row indexes.
      ! jao = integer array of size nrow+1 (*) containing the "ja" index
      !       array of the transpose.
      ! (*) the ouput matrix has 'ncol' rows and 'nrow' columns !
      !
      !-----------------------------------------------------------------

      integer :: i, j, k, next

   !------ end of declarations -- execution starts hereafter  ------

      ! compute lengths of cols of transp(A)
      do i = 2, nrow+1
         jao(i) = 0
      end do
      do j = 1, ncol
         do k = ja(j), ja(j+1)-1
            i = ia(k)+1 ! shift
            jao(i) = jao(i) + 1
         end do
      end do
      ! compute pointers from lengths
      jao(1) = 1
      do i = 1, nrow
         jao(i+1) = jao(i) + jao(i+1)
      end do

      ! now do the actual copying
      do j = 1, ncol
         do k = ja(j), ja(j+1)-1
            i = ia(k)
            next = jao(i)
            iao(next) = j
            jao(i) = next + 1
         end do
      end do

      do i = nrow, 1, -1
         jao(i+1) = jao(i)
      end do
      jao(1) = 1

   end subroutine csc_transp_struct_only
!_______________________________________________________________________
!
   subroutine csc_transp_cmplx( nrow, ncol, a, ia, ja, ao, iao, jao )

      integer,                 intent(in)  :: nrow, ncol
      complex(kind=MF_DOUBLE), intent(in)  :: a(:)
      integer,                 intent(in)  :: ia(:), ja(:)
      complex(kind=MF_DOUBLE), intent(out) :: ao(:)
      integer,                 intent(out) :: iao(:), jao(:)
      !------ API end ------

      !-----------------------------------------------------------------
      ! Transpose a Compressed Sparse Column
      !
      ! (transposition operation)   Not in place.
      ! (adapted from SPARSKIT2 (Mar 8 2005) 'csrcsc2' by É. Canot)
      ! (complex case)
      !-----------------------------------------------------------------
      ! -- not in place --
      ! this subroutine transposes a matrix stored in a, ia, ja format.
      ! ---------------
      ! on entry:
      !----------
      ! nrow = number of rows of the input matrix.
      ! ncol = number of columns of the input matrix.
      !
      ! a  = real array of length nnz (nnz=number of nonzero elements
      !      in input matrix) containing the nonzero elements.
      ! ia = integer array of length nnz containing the row positions
      !      of the corresponding elements in a.
      ! ja = integer of size ncol+1. ja(k) contains the position
      !      in a, ia of the beginning of the k-th col.
      !
      ! on return:
      ! ----------
      ! output arguments:
      ! ao  = real array of size nnz containing the "a" part of the
      !       transpose
      ! iao = integer array of size nnz containing the row indexes.
      ! jao = integer array of size nrow+1 (*) containing the "ja" index
      !       array of the transpose.
      ! (*) the ouput matrix has 'ncol' rows and 'nrow' columns !
      !
      !-----------------------------------------------------------------

      integer :: i, j, k, next

   !------ end of declarations -- execution starts hereafter  ------

      ! compute lengths of cols of transp(A)
      do i = 2, nrow+1
         jao(i) = 0
      end do
      do j = 1, ncol
         do k = ja(j), ja(j+1)-1
            i = ia(k)+1 ! shift
            jao(i) = jao(i) + 1
         end do
      end do
      ! compute pointers from lengths
      jao(1) = 1
      do i = 1, nrow
         jao(i+1) = jao(i) + jao(i+1)
      end do

      ! now do the actual copying
      do j = 1, ncol
         do k = ja(j), ja(j+1)-1
            i = ia(k)
            next = jao(i)
            ao(next) = a(k)
            iao(next) = j
            jao(i) = next + 1
         end do
      end do

      do i = nrow, 1, -1
         jao(i+1) = jao(i)
      end do
      jao(1) = 1

   end subroutine csc_transp_cmplx
!_______________________________________________________________________
!
   subroutine csc_ctransp_cmplx( nrow, ncol, a, ia, ja, ao, iao, jao )

      integer,                 intent(in)  :: nrow, ncol
      complex(kind=MF_DOUBLE), intent(in)  :: a(:)
      integer,                 intent(in)  :: ia(:), ja(:)
      complex(kind=MF_DOUBLE), intent(out) :: ao(:)
      integer,                 intent(out) :: iao(:), jao(:)
      !------ API end ------

      !-----------------------------------------------------------------
      ! Conj. Transpose a Compressed Sparse Column
      !
      ! (conj. transposition operation)   Not in place.
      ! (adapted from SPARSKIT2 (Mar 8 2005) 'csrcsc2' by É. Canot)
      ! (complex case)
      !-----------------------------------------------------------------
      ! -- not in place --
      ! this subroutine transposes a matrix stored in a, ia, ja format.
      ! ---------------
      ! on entry:
      !----------
      ! nrow = number of rows of the input matrix.
      ! ncol = number of columns of the input matrix.
      !
      ! a  = real array of length nnz (nnz=number of nonzero elements
      !      in input matrix) containing the nonzero elements.
      ! ia = integer array of length nnz containing the row positions
      !      of the corresponding elements in a.
      ! ja = integer of size ncol+1. ja(k) contains the position
      !      in a, ia of the beginning of the k-th col.
      !
      ! on return:
      ! ----------
      ! output arguments:
      ! ao  = real array of size nnz containing the "a" part of the
      !       transpose
      ! iao = integer array of size nnz containing the row indexes.
      ! jao = integer array of size nrow+1 (*) containing the "ja" index
      !       array of the transpose.
      ! (*) the ouput matrix has 'ncol' rows and 'nrow' columns !
      !
      !-----------------------------------------------------------------

      integer :: i, j, k, next

   !------ end of declarations -- execution starts hereafter  ------

      ! compute lengths of cols of transp(A)
      do i = 2, nrow+1
         jao(i) = 0
      end do
      do j = 1, ncol
         do k = ja(j), ja(j+1)-1
            i = ia(k)+1 ! shift
            jao(i) = jao(i) + 1
         end do
      end do
      ! compute pointers from lengths
      jao(1) = 1
      do i = 1, nrow
         jao(i+1) = jao(i) + jao(i+1)
      end do

      ! now do the actual copying
      do j = 1, ncol
         do k = ja(j), ja(j+1)-1
            i = ia(k)
            next = jao(i)
            ao(next) = conjg(a(k))
            iao(next) = j
            jao(i) = next + 1
         end do
      end do

      do i = nrow, 1, -1
         jao(i+1) = jao(i)
      end do
      jao(1) = 1

   end subroutine csc_ctransp_cmplx
