! f90 include file

!_______________________________________________________________________
!
   function symmpattern( nrow, ncol, ia, ja ) result( bool )

      integer, intent(in) :: nrow, ncol, ia(:), ja(:)
      logical :: bool
      !------ API end ------

      !-----------------------------------------------------------------
      ! Checks the symmetry of the pattern of a matrix
      ! (É. Canot -- IPR/CNRS)
      ! the input matrix must be row sorted.
      ! (code from 'csc_transp_struct_only') -- fix 19/12/07
      !-----------------------------------------------------------------
      ! On entry:
      !--------------
      ! nrow    = number of rows in matrix
      ! ncol    = number of cols in matrix
      ! ia, ja  = sparsity structure of matrix in CSC format
      !
      ! On return:
      !---------------
      ! bool = TRUE : indicates that matrix has a symmetric pattern
      !-----------------------------------------------------------------

      integer, allocatable :: iao(:), jao(:)
      integer :: i, j, k, next, nnz

   !------ end of declarations -- execution starts hereafter  ------

      bool = .false.

      if( nrow /= ncol ) return

      ! warning: (ia,ja) may be oversized:
      ! so don't use size(ia) or size(ja)
      allocate( jao(nrow+1) )

      ! compute lengths of cols of transp(A)
      do i = 2, nrow+1
         jao(i) = 0
      end do
      do j = 1, ncol
         do k = ja(j), ja(j+1)-1
            i = ia(k)+1 ! shift
            jao(i) = jao(i) + 1
         end do
      end do

      ! compute pointers from lengths
      jao(1) = 1
      do i = 2, nrow+1
         jao(i) = jao(i-1) + jao(i)
         if( jao(i) /= ja(i) ) return
      end do

      nnz = ja(nrow+1) - 1
      allocate( iao(nnz) )

      ! now do the actual copying
      do j = 1, ncol
         do k = ja(j), ja(j+1)-1
            i = ia(k)
            next = jao(i)
            iao(next) = j
            jao(i) = next + 1
         end do
      end do

      do i = 1, nnz
         if( iao(i) /= ia(i) ) return
      end do

      bool = .true.

   end function symmpattern
