! f90 include file

!_______________________________________________________________________
!
   subroutine sumrows( nrow, ncol, a, ia, ja, s )

      integer, intent(in)  :: nrow, ncol, ia(:), ja(:)
      real(kind=MF_DOUBLE), intent(in)  :: a(:)
      real(kind=MF_DOUBLE), intent(out) :: s(:)
      !------ API end ------

      !-----------------------------------------------------------------
      ! sums each row of a matrix in CSC format, and
      ! store it in a dense vector.
      !-----------------------------------------------------------------
      ! on entry:
      !----------
      ! ncol = integer : the number of cols of the input matrix
      !
      ! a, ia, ja = input matrix in CSC format
      !
      !------------
      ! on return:
      !------------
      ! s = dense vector : s(1:nrow) contains the sums.
      !     the length of s must be sufficient to store its elements
      !-----------------------------------------------------------------

      integer :: i, j, k

   !------ end of declarations -- execution starts hereafter  ------

      s(1:nrow) = 0.0d0

      do j = 1, ncol
         do k = ja(j), ja(j+1)-1
            i = ia(k)
            s(i) = s(i) + a(k)
         end do
      end do

   end subroutine sumrows
!_______________________________________________________________________
!
   subroutine sumrows_cmplx( nrow, ncol, a, ia, ja, s )

      integer, intent(in)  :: nrow, ncol, ia(:), ja(:)
      complex(kind=MF_DOUBLE), intent(in)  :: a(:)
      complex(kind=MF_DOUBLE), intent(out) :: s(:)
      !------ API end ------

      !-----------------------------------------------------------------
      ! complex version of 'sumrows'
      !-----------------------------------------------------------------

      integer :: i, j, k

   !------ end of declarations -- execution starts hereafter  ------

      s(1:nrow) = (0.0d0,0.0d0)

      do j = 1, ncol
         do k = ja(j), ja(j+1)-1
            i = ia(k)
            s(i) = s(i) + a(k)
         end do
      end do

   end subroutine sumrows_cmplx
