! f90 include file

!_______________________________________________________________________
!
   subroutine submat_nnz( ia, ja, i1, i2, j1, j2, nnz )

      integer, intent(in) :: i1, i2, j1, j2, ia(*), ja(*)
      integer             :: nnz
      !------ API end ------

      !-----------------------------------------------------------------
      ! finds the nnz of the submatrix A(i1:i2,j1:j2)
      !-----------------------------------------------------------------
      ! on entry:
      !----------
      ! i1,i2 = two integers with i2 >= i1 indicating the range
      !         of rows to be extracted.
      ! j1,j2 = two integers with j2 >= j1 indicating the range
      !         of columns to be extracted.
      !
      ! a, ia, ja = Matrix A in CSC format.
      !
      ! on return:
      !-----------
      ! nnz = number of non-zero elements
      !-----------------------------------------------------------------

      integer :: i, j, k

   !------ end of declarations -- execution starts hereafter  ------

      nnz = 0
      do j = j1, j2
         do k = ja(j), ja(j+1)-1
            i = ia(k)
            if( i1 <= i .and. i <= i2 ) then
               nnz = nnz + 1
            end if
         end do
      end do

   end subroutine submat_nnz
!_______________________________________________________________________
!
   subroutine submat( a, ia, ja, i1, i2, j1, j2,                        &
                      ao, iao, jao )

      integer,              intent(in) :: i1, i2, j1, j2, ia(*), ja(*)
      real(kind=MF_DOUBLE), intent(in) :: a(*)
      integer                          :: iao(*), jao(*)
      real(kind=MF_DOUBLE)             :: ao(*)
      !------ API end ------

      !-----------------------------------------------------------------
      ! extracts the submatrix A(i1:i2,j1:j2) and puts the result in
      ! matrix ao,iao,jao
      !---- In place: ao,iao,jao may be the same as a,ia,ja.
      ! (adapted from SPARSKIT2 (Mar 8 2005) 'submat' by É. Canot)
      !-----------------------------------------------------------------
      ! on entry:
      !----------
      ! i1,i2 = two integers with i2 >= i1 indicating the range
      !         of rows to be extracted.
      ! j1,j2 = two integers with j2 >= j1 indicating the range
      !         of columns to be extracted.
      !
      ! a, ia, ja = Matrix A in CSC format.
      !
      ! on return:
      !-----------
      ! ao, iao, jao = extracted matrix in CSC format.
      !
      ! Note: the algorithm keeps the 'row sorted' property of A
      !-----------------------------------------------------------------

      integer :: klen, i, j, jj, k, k1, k2, nc

   !------ end of declarations -- execution starts hereafter  ------

      nc = j2 - j1 + 1
      klen = 0

      ! simple procedure. proceeds column-wise...
      do j = 1, nc
         jj = j1 + j - 1
         k1 = ja(jj)
         k2 = ja(jj+1) - 1
         jao(j) = klen + 1

         do k = k1, k2
            i = ia(k)
            if( i1 <= i .and. i <= i2 ) then
               klen = klen + 1
               ao(klen) = a(k)
               iao(klen) = i - i1 + 1
            end if
         end do
      end do
      jao(nc+1) = klen + 1

   end subroutine submat
!_______________________________________________________________________
!
   subroutine submat_cmplx( a, ia, ja, i1, i2, j1, j2,                  &
                            ao, iao, jao )

      integer,                 intent(in) :: i1, i2, j1, j2, ia(*), ja(*)
      complex(kind=MF_DOUBLE), intent(in) :: a(*)
      integer                             :: iao(*), jao(*)
      complex(kind=MF_DOUBLE)             :: ao(*)
      !------ API end ------

      !-----------------------------------------------------------------
      ! (complex case of 'submat')
      !-----------------------------------------------------------------

      integer :: klen, i, j, jj, k, k1, k2, nc

   !------ end of declarations -- execution starts hereafter  ------

      nc = j2 - j1 + 1
      klen = 0

      ! simple procedure. proceeds column-wise...
      do j = 1, nc
         jj = j1 + j - 1
         k1 = ja(jj)
         k2 = ja(jj+1) - 1
         jao(j) = klen + 1

         do k = k1, k2
            i = ia(k)
            if( i1 <= i .and. i <= i2 ) then
               klen = klen + 1
               ao(klen) = a(k)
               iao(klen) = i - i1 + 1
            end if
         end do
      end do
      jao(nc+1) = klen + 1

   end subroutine submat_cmplx
