! f90 include file

!_______________________________________________________________________
!
   subroutine spcut_nnz( n, a, ia, ja, threshold, nnz )

      integer, intent(in) :: n, ia(*), ja(*)
      real(kind=MF_DOUBLE), intent(in) :: a(*), threshold
      integer :: nnz
      !------ API end ------

      !-----------------------------------------------------------------
      ! finds the number of elements whose magnitude are strictly
      ! greater than a given threshold
      ! É. Canot, Nov. 2008
      !-----------------------------------------------------------------
      ! on entry:
      !----------
      ! n = nb of col of the matrix a.
      ! a, ia, ja = matrix in CSC format.
      ! threshold = value used in the condition
      !
      ! on return:
      !-----------
      ! nnz = number of elements which satisfied the condition
      !-----------------------------------------------------------------

      integer :: j, k

   !------ end of declarations -- execution starts hereafter  ------

      nnz = 0
      do j = 1, n
         do k = ja(j), ja(j+1) -1
            if( abs(a(k)) > threshold ) then
               nnz = nnz + 1
            end if
         end do
      end do

   end subroutine spcut_nnz
!_______________________________________________________________________
!
   subroutine spcut_nnz_cmplx( n, a, ia, ja, threshold, nnz )

      integer, intent(in) :: n, ia(*), ja(*)
      complex(kind=MF_DOUBLE), intent(in) :: a(*)
      real(kind=MF_DOUBLE), intent(in) :: threshold
      integer :: nnz
      !------ API end ------

      !-----------------------------------------------------------------
      ! (complex version of 'spcut_nnz')
      !-----------------------------------------------------------------

      integer :: j, k

   !------ end of declarations -- execution starts hereafter  ------

      nnz = 0
      do j = 1, n
         do k = ja(j), ja(j+1) -1
            if( abs(a(k)) > threshold ) then
               nnz = nnz + 1
            end if
         end do
      end do

   end subroutine spcut_nnz_cmplx
!_______________________________________________________________________
!
   subroutine spcut( n, a, ia, ja, threshold, ao, iao, jao )

      integer, intent(in) :: n, ia(*), ja(*)
      real(kind=MF_DOUBLE), intent(in) :: a(*), threshold
      integer :: iao(*), jao(*)
      real(kind=MF_DOUBLE) :: ao(*)
      !------ API end ------

      !-----------------------------------------------------------------
      ! extracts the elements of a matrix whose magnitude is strictly
      ! greater than a given threshold
      ! É. Canot, Nov. 2008
      !-----------------------------------------------------------------
      ! on entry:
      !----------
      ! n = nb of col of the matrix a.
      ! a, ia, ja = matrix in CSC format.
      ! threshold = value used in the condition
      !
      ! on return:
      !-----------
      ! ao, iao, jao = output matrix stored in CSC format
      !-----------------------------------------------------------------

      integer :: ko, k, j

   !------ end of declarations -- execution starts hereafter  ------

   !------ end of declarations -- execution starts hereafter  ------

      ko = 0
      jao(1) = 1
      do j = 1, n
         do k = ja(j), ja(j+1) -1
            if( abs(a(k)) > threshold ) then
               ko = ko + 1
               ao(ko) = a(k)
               iao(ko) = ia(k)
            end if
         end do
         jao(j+1) = ko + 1
      end do

   end subroutine spcut
!_______________________________________________________________________
!
   subroutine spcut_cmplx( n, a, ia, ja, threshold, ao, iao, jao )

      integer, intent(in) :: n, ia(*), ja(*)
      complex(kind=MF_DOUBLE), intent(in) :: a(*)
      real(kind=MF_DOUBLE), intent(in) :: threshold
      integer :: iao(*), jao(*)
      complex(kind=MF_DOUBLE) :: ao(*)
      !------ API end ------

      !-----------------------------------------------------------------
      ! (complex version of 'spcut')
      !-----------------------------------------------------------------

      integer :: ko, k, j

   !------ end of declarations -- execution starts hereafter  ------

      ko = 0
      jao(1) = 1
      do j = 1, n
         do k = ja(j), ja(j+1) -1
            if( abs(a(k)) > threshold ) then
               ko = ko + 1
               ao(ko) = a(k)
               iao(ko) = ia(k)
            end if
         end do
         jao(j+1) = ko + 1
      end do

   end subroutine spcut_cmplx
