! f90 include file

!_______________________________________________________________________
!
   subroutine sp_del_0_and_compact_r8( ncol, a, ia, ja, nb_zeros )

      real(kind=MF_DOUBLE), pointer :: a(:)
      integer,              pointer :: ia(:), ja(:)
      integer,              intent(in) :: ncol, nb_zeros
      !------ API end ------

      !-----------------------------------------------------------------
      ! Remove zeros in matrix in CSC format and compact the arrays
      ! a(:), ia(:) and ja(:) to their minimum size.
      ! É. Canot -- 2023-12-06
      !-----------------------------------------------------------------
      ! On entry:
      !--------------
      ! ncol      = number of cols in matrix (logical dimension!)
      ! a, ia, ja = matrix in CSC format
      ! nb_zeros  = number of unwanted zeros (counted by the calling unit)
      !
      ! On return:
      !---------------
      ! This routine doesn't change the row-sorted property of the columns.
      !-----------------------------------------------------------------

      real(kind=MF_DOUBLE), pointer :: a_new(:)
      integer,              pointer :: ia_new(:), ja_new(:)

      integer :: i, j, k, nnz, nnz_new, nz

   !------ end of declarations -- execution starts hereafter  ------

      if( nb_zeros <= 0 ) return

      nnz = ja(ncol+1) - 1
      nnz_new = nnz - nb_zeros
      allocate( a_new(nnz_new), ia_new(nnz_new) )
      allocate( ja_new(ncol+1) )

      nz = 0
      ja_new(1) = 1
      do j = 1, ncol
         do k = ja(j), ja(j+1)-1
            if( a(k) /= 0.0d0 ) then
               nz = nz + 1
               ia_new(nz) = ia(k)
               a_new(nz) = a(k)
            end if
         end do
         ja_new(j+1) = nz + 1
      end do

      if( nz /= nnz_new ) then
         print *, "sp_del_0_and_compact_r8: internal error"
         print *, "  -> it seems that the nb of zeros provided was wrong!"
         pause "for debugging purpose only..."
         stop
      end if

      deallocate( a, ia, ja )
      a => a_new
      ia => ia_new
      ja => ja_new

   end subroutine sp_del_0_and_compact_r8
!_______________________________________________________________________
!
   subroutine sp_del_0_and_compact_z8( ncol, a, ia, ja, nb_zeros )

      complex(kind=MF_DOUBLE), pointer :: a(:)
      integer,                 pointer :: ia(:), ja(:)
      integer,                 intent(in) :: ncol, nb_zeros
      !------ API end ------

      !-----------------------------------------------------------------
      ! Same as sp_del_0_and_compact_r8 but for complex data.
      !-----------------------------------------------------------------

      complex(kind=MF_DOUBLE), pointer :: a_new(:)
      integer,                 pointer :: ia_new(:), ja_new(:)

      integer :: i, j, k, nnz, nnz_new, nz

   !------ end of declarations -- execution starts hereafter  ------

      if( nb_zeros <= 0 ) return

      nnz = ja(ncol+1) - 1
      nnz_new = nnz - nb_zeros
      allocate( a_new(nnz_new), ia_new(nnz_new) )
      allocate( ja_new(ncol+1) )

      nz = 0
      ja_new(1) = 1
      do j = 1, ncol
         do k = ja(j), ja(j+1)-1
            if( a(k) /= (0.0d0,0.0d0) ) then
               nz = nz + 1
               ia_new(nz) = ia(k)
               a_new(nz) = a(k)
            end if
         end do
         ja_new(j+1) = nz + 1
      end do

      if( nz /= nnz_new ) then
         print *, "sp_del_0_and_compact_z8: internal error"
         print *, "  -> it seems that the nb of zeros provided was wrong!"
         pause "for debugging purpose only..."
         stop
      end if

      deallocate( a, ia, ja )
      a => a_new
      ia => ia_new
      ja => ja_new

   end subroutine sp_del_0_and_compact_z8
