! f90 include file

!_______________________________________________________________________
!
   subroutine setelm( a_new, i, j, ncol, a, ia, ja, row_sorted, status )

      real(kind=MF_DOUBLE), intent(in) :: a_new
      integer, intent(in) :: i, j, ncol
      integer, intent(in out) :: ia(:), ja(:)
      real(kind=MF_DOUBLE), intent(in out) :: a(:)
      integer, intent(in) :: row_sorted
      integer :: status
      !------ API end ------

      !-----------------------------------------------------------------
      ! purpose:
      ! --------
      ! this function modifies the (i,j) element of a matrix A:
      !   if the entry (i,j) doesn't exist, it is created;
      !   if the entry (i,j) exist and a_new is null, it is removed;
      !   if the entry (i,j) doesn't exist and a_new is null,
      !     nothing is done;
      ! the matrix is assumed to be stored in CSC format.
      ! setelm performs a binary search in the case where it is known
      ! that the elements are sorted so that the row indexes are in
      ! increasing order.
      !-----
      ! (written by É. Canot) modified June 29, 2006
      !-----------------------------------------------------------------
      ! parameters:
      ! -----------
      ! on entry:
      !----------
      ! a_new = the value of A to be copied at A(i,j)
      ! i, j = the row and column index of the element sought (input)
      ! ncol = the number of columns of A
      ! a, ia, ja = the matrix A in CSC format (input)
      ! row_sorted = TRUE : the matrix is known to have its row indexes
      !                     sorted in increasing order (input)
      !
      ! on exit:
      !---------
      ! status = 0 if A(i,j) exists
      !        = 1 if A(i,j) doesn't exist (in this case, the calling
      !               program MUST be set the row_sorted flag to UNKNOWN
      !        = -1 : fail (not enough place to add an element)
      !-----------------------------------------------------------------

      ! local variables.
      integer :: kbeg, kend, kmid, k, kk
      integer :: nnz, nzmax

   !------ end of declarations -- execution starts hereafter  ------

      ! initialization
      status = 0
      kk = 0
      kbeg = ja(j)
      kend = ja(j+1)-1
      if( kend < kbeg ) then
         go to 20
      end if

      ! case where matrix is sorted
      if( row_sorted == TRUE ) then

         ! begin binary search.   compute the middle index.
 10      kmid = ( kbeg + kend ) / 2

         ! test if found
         if( ia(kmid) == i ) then
            kk = kmid
            go to 20
         end if
         if( kbeg >= kend ) go to 20

         ! else update the interval bounds.
         if( ia(kmid) > i ) then
            kend = kmid -1
         else
            kbeg = kmid +1
         end if
         go to 10

      else ! not sorted or unknown

         ! scan the col - exit as soon as a(i,j) is found
         do k = kbeg, kend
            if( ia(k) == i ) then
               kk = k
               go to 20
            end if
         end do

      end if

 20   continue

      if( kk /= 0 ) then

         if( a_new /= 0.0d0 ) then

            a(kk) = a_new

         else

            ! we must remove an entry -- the 'row_sorted' property
            ! is not changed !
            nnz = ja(ncol+1) - 1
            do k = kk, nnz - 1
               ia(k) = ia(k+1)
               a(k) = a(k+1)
            end do
            do k = j+1, ncol+1
               ja(k) = ja(k) - 1
            end do

         end if

      else ! (i,j) entry not found

         if( a_new /= 0.0d0 ) then

            ! verifying that enough memory exists
            nnz = ja(ncol+1) - 1
            nzmax = size(a)
            if( nnz+1 > nzmax ) then
               status = -1
               return
            end if

            status = 1

            ! we must create a new entry -- the 'row_sorted' property
            ! will become 'unknown' ! (fastest way)
            kbeg = ja(j+1)
            kend = nnz
            do k = kend, kbeg, -1
               ia(k+1) = ia(k)
               a(k+1) = a(k)
            end do
            ia(kbeg) = i
            a(kbeg) = a_new
            do k = j+1, ncol+1
               ja(k) = ja(k) + 1
            end do

         end if

      end if

   end subroutine setelm
!_______________________________________________________________________
!
   subroutine setelm_cmplx( a_new, i, j, ncol, a, ia, ja, row_sorted, status )

      complex(kind=MF_DOUBLE), intent(in) :: a_new
      integer, intent(in) :: i, j, ncol
      integer, intent(in out) :: ia(:), ja(:)
      complex(kind=MF_DOUBLE), intent(in out) :: a(:)
      integer, intent(in) :: row_sorted
      integer :: status
      !------ API end ------

      !-----------------------------------------------------------------
      ! complex version of 'setelm'
      !-----------------------------------------------------------------

      ! local variables.
      integer :: kbeg, kend, kmid, k, kk
      integer :: nnz, nzmax

   !------ end of declarations -- execution starts hereafter  ------

      ! initialization
      status = 0
      kk = 0
      kbeg = ja(j)
      kend = ja(j+1)-1
      if( kend < kbeg ) then
         go to 20
      end if

      ! case where matrix is sorted
      if( row_sorted == TRUE ) then

         ! begin binary search.   compute the middle index.
 10      kmid = ( kbeg + kend ) / 2

         ! test if found
         if( ia(kmid) == i ) then
            kk = kmid
            go to 20
         end if
         if( kbeg >= kend ) go to 20

         ! else update the interval bounds.
         if( ia(kmid) > i ) then
            kend = kmid -1
         else
            kbeg = kmid +1
         end if
         go to 10

      else ! not sorted or unknown

         ! scan the col - exit as soon as a(i,j) is found
         do k = kbeg, kend
            if( ia(k) == i ) then
               kk = k
               go to 20
            end if
         end do

      end if

 20   continue

      if( kk /= 0 ) then

         if( a_new /= (0.0d0,0.0d0) ) then

            a(kk) = a_new

         else

            ! we must remove an entry -- the 'row_sorted' property
            ! is not changed !
            nnz = ja(ncol+1) - 1
            do k = kk, nnz - 1
               ia(k) = ia(k+1)
               a(k) = a(k+1)
            end do
            do k = j+1, ncol+1
               ja(k) = ja(k) - 1
            end do

         end if

      else

         if( a_new /= (0.0d0,0.0d0) ) then

            ! verifying that enough memory exists
            nnz = ja(ncol+1) - 1
            nzmax = size(a)
            if( nnz+1 > nzmax ) then
               status = -1
               return
            end if

            status = 1

            ! we must create a new entry -- the 'row_sorted' property
            ! will become 'unknown' ! (fastest way)
            kbeg = ja(j+1)
            kend = nnz
            do k = kend, kbeg, -1
               ia(k+1) = ia(k)
               a(k+1) = a(k)
            end do
            ia(kbeg) = i
            a(kbeg) = a_new
            do k = j+1, ncol+1
               ja(k) = ja(k) + 1
            end do

         end if

      end if

   end subroutine setelm_cmplx
