! f90 include file

!_______________________________________________________________________
!
   subroutine rowscale( ncol, a, ia, ja, ao, iao, jao, scal )

      integer,              intent(in) :: ncol, ia(:), ja(:)
      real(kind=MF_DOUBLE), intent(in) :: a(:), scal(:)
      integer,              intent(out) :: iao(:), jao(:)
      real(kind=MF_DOUBLE), intent(out) :: ao(:)
      !-----------------------------------------------------------------
      ! this subroutine applies a scaling to the rows of a matrix
      ! in CSC format.
      ! rowscale  computes S*A  where S is a diagonal matrix.
      ! the scaling S is actually defined through the array 'scale':
      ! elements in row i of A are multiplied by scale(i).
      ! -- Édouard Canot -- Feb. 2012
      !-----------------------------------------------------------------
      ! on entry:
      !----------
      ! ncol  = nb of columns of the matrix
      ! a, ia, ja = input matrix in CSC format
      ! scale = real array of length ncol containing the scaling for
      !         each column.
      !
      !------------
      ! on return:
      !------------
      ! ao, iao, jao = output matrix in CSC format
      !-----------------------------------------------------------------

      integer :: j, k, nnz

   !------ end of declarations -- execution starts hereafter  ------

      nnz = ja(ncol+1) - 1
      iao(1:nnz)    = ia(1:nnz)
      jao(1:ncol+1) = ja(1:ncol+1)

      do j = 1, ncol
         do k = ja(j), ja(j+1) - 1
            ao(k) = a(k)*scal(ia(k))
         end do
      end do

   end subroutine rowscale
!_______________________________________________________________________
!
   subroutine rowscale2( ncol, a, ia, ja, scal )

      integer,              intent(in) :: ncol
      real(kind=MF_DOUBLE), intent(in) :: scal(:)
      integer,              intent(in out) :: ia(:), ja(:)
      real(kind=MF_DOUBLE), intent(in out) :: a(:)
      !-----------------------------------------------------------------
      ! this subroutine applies an 'in-place' scaling to the rows of
      ! a matrix in CSC format.
      ! rowscale  computes S*A  where S is a diagonal matrix.
      ! the scaling S is actually defined through the array 'scale':
      ! elements in row i of A are multiplied by scale(i).
      ! -- Édouard Canot -- Feb. 2012
      !-----------------------------------------------------------------
      ! on entry:
      !----------
      ! ncol  = nb of columns of the matrix
      ! a, ia, ja = input matrix in CSC format
      ! scale = real array of length ncol containing the scaling for
      !         each column.
      !
      !------------
      ! on return:
      !------------
      ! a, ia, ja = output matrix in CSC format
      !-----------------------------------------------------------------

      integer :: j, k, nnz

   !------ end of declarations -- execution starts hereafter  ------

      nnz = ja(ncol+1) - 1

      do j = 1, ncol
         do k = ja(j), ja(j+1) - 1
            a(k) = a(k)*scal(ia(k))
         end do
      end do

   end subroutine rowscale2
!_______________________________________________________________________
!
   subroutine rowscale_cmplx( ncol, a, ia, ja, ao, iao, jao, scal )

      integer,                 intent(in) :: ncol, ia(:), ja(:)
      complex(kind=MF_DOUBLE), intent(in) :: a(:)
      real(kind=MF_DOUBLE),    intent(in) :: scal(:)
      integer,                 intent(out) :: iao(:), jao(:)
      complex(kind=MF_DOUBLE), intent(out) :: ao(:)
      !-----------------------------------------------------------------
      ! complex version of 'rowscale'
      !-----------------------------------------------------------------

      integer :: j, k, nnz

   !------ end of declarations -- execution starts hereafter  ------

      nnz = ja(ncol+1) - 1
      iao(1:nnz)    = ia(1:nnz)
      jao(1:ncol+1) = ja(1:ncol+1)

      do j = 1, ncol
         do k = ja(j), ja(j+1) - 1
            ao(k) = a(k)*scal(ia(k))
         end do
      end do

   end subroutine rowscale_cmplx
!_______________________________________________________________________
!
   subroutine rowscale2_cmplx( ncol, a, ia, ja, scal )

      integer,                 intent(in) :: ncol
      real(kind=MF_DOUBLE),    intent(in) :: scal(:)
      integer,                 intent(in out) :: ia(:), ja(:)
      complex(kind=MF_DOUBLE), intent(in out) :: a(:)
      !-----------------------------------------------------------------
      ! complex version of 'rowscale2'
      !-----------------------------------------------------------------

      integer :: j, k, nnz

   !------ end of declarations -- execution starts hereafter  ------

      nnz = ja(ncol+1) - 1

      do j = 1, ncol
         do k = ja(j), ja(j+1) - 1
            a(k) = a(k)*scal(ia(k))
         end do
      end do

   end subroutine rowscale2_cmplx

