! f90 include file

!_______________________________________________________________________
!
   subroutine rowperm( ncol, a, ia, ja, ao, iao, jao, perm )

      integer,              intent(in) :: ncol, ia(:), ja(:), perm(:)
      real(kind=MF_DOUBLE), intent(in) :: a(:)
      integer,              intent(out) :: iao(:), jao(:)
      real(kind=MF_DOUBLE), intent(out) :: ao(:)
      !-----------------------------------------------------------------
      ! This subroutine permutes the rows of a matrix in CSC format.
      ! It computes B = P A, where  P is a permutation matrix.
      ! The permutation P is defined through the array perm: the jth row
      ! of B is the perm(j)^th row of A.
      ! In Matlab-like syntax, it computes: B(:,:) = A(p,:)
      ! -- Édouard Canot -- Feb. 2012
      !-----------------------------------------------------------------
      ! on entry:
      !----------
      ! ncol  = col dimension of the matrix
      ! a, ia, ja = input matrix in CSC format.
      ! perm  = integer array of length nrow containing the permutation
      !         arrays for the columns.
      !
      !------------
      ! on return:
      !------------
      ! ao, iao, jao = output matrix in CSC format
      !-----------------------------------------------------------------

      integer :: i, j, k, nnz, nrow
      integer, allocatable :: pinv(:)

   !------ end of declarations -- execution starts hereafter  ------

      nrow = maxval(perm)
      allocate( pinv(nrow) )
      pinv(perm) = [ (i, i = 1, nrow ) ]

      nnz = ja(ncol+1) - 1
      do k = 1, nnz
         iao(k) = pinv(ia(k))
      end do

      do j = 1, ncol + 1
         jao(j) = ja(j)
      end do

      do k = 1, nnz
         ao(k) = a(k)
      end do

   end subroutine rowperm
!_______________________________________________________________________
!
   subroutine rowpinv( ncol, a, ia, ja, ao, iao, jao, perm )

      integer,              intent(in) :: ncol, ia(:), ja(:), perm(:)
      real(kind=MF_DOUBLE), intent(in) :: a(:)
      integer,              intent(out) :: iao(:), jao(:)
      real(kind=MF_DOUBLE), intent(out) :: ao(:)
      !-----------------------------------------------------------------
      ! This subroutine permutes the rows of a matrix in CSC format.
      ! It computes B = P A, where  P is a permutation matrix
      ! that maps row i into row perm(i), i.e., on return
      !      A(i,j) becomes A(perm(i),j) in new matrix.
      ! In Matlab-like syntax, it computes B, such that B(p,:) = A(:,:)
      ! -- Édouard Canot -- Jan. 2012
      ! (from cperm of SPARSKIT)
      !-----------------------------------------------------------------
      ! on entry:
      !----------
      ! ncol  = col dimension of the matrix
      ! a, ia, ja = input matrix in CSC format.
      ! perm  = integer array of length nrow containing the permutation
      !         arrays for the columns.
      !
      !------------
      ! on return:
      !------------
      ! ao, iao, jao = output matrix in CSC format
      !-----------------------------------------------------------------

      integer :: j, k, nnz

   !------ end of declarations -- execution starts hereafter  ------

      nnz = ja(ncol+1) - 1
      do k = 1, nnz
         iao(k) = perm(ia(k))
      end do

      do j = 1, ncol + 1
         jao(j) = ja(j)
      end do

      do k = 1, nnz
         ao(k) = a(k)
      end do

   end subroutine rowpinv
!_______________________________________________________________________
!
   subroutine rowperm2( ncol, ia, ja, perm )

      integer, intent(in) :: ncol, perm(:)
      integer, intent(in out) :: ia(:), ja(:)
      !-----------------------------------------------------------------
      ! This subroutine applies an 'in-place' permutation to the rows
      ! of a matrix in CSC format.
      ! It computes B = P A, where  P is a permutation matrix.
      ! The permutation P is defined through the array perm: the jth row
      ! of B is the perm(j)^th row of A.
      ! In Matlab-like syntax, it computes: B(:,:) = A(p,:)
      ! -- Édouard Canot -- Feb. 2012
      !-----------------------------------------------------------------
      ! on entry:
      !----------
      ! ncol  = col dimension of the matrix
      ! a, ia, ja = input matrix in CSC format.
      ! perm  = integer array of length nrow containing the permutation
      !         arrays for the columns.
      !
      !------------
      ! on return:
      !------------
      ! a, ia, ja = output matrix in CSC format
      !-----------------------------------------------------------------

      integer :: i, k, nnz, nrow
      integer, allocatable :: pinv(:)

   !------ end of declarations -- execution starts hereafter  ------

      nrow = maxval(perm)
      allocate( pinv(nrow) )
      pinv(perm) = [ (i, i = 1, nrow ) ]

      nnz = ja(ncol+1) - 1
      do k = 1, nnz
         ia(k) = pinv(ia(k))
      end do

   end subroutine rowperm2
!_______________________________________________________________________
!
   subroutine rowpinv2( ncol, ia, ja, perm )

      integer, intent(in) :: ncol, perm(:)
      integer, intent(in out) :: ia(:), ja(:)
      !-----------------------------------------------------------------
      ! this subroutine applies an 'in-place' permutation to the rows of
      ! a matrix in CSC format (real/complex).
      ! It computes B = P A, where  P is a permutation matrix
      ! that maps row i into row perm(i), i.e., on return
      !      A(i,j) becomes A(perm(i),j) in new matrix
      ! In Matlab-like syntax, it computes B, such that B(p,:) = A(:,:)
      ! -- Édouard Canot -- Feb. 2012
      ! (from cperm of SPARSKIT)
      !-----------------------------------------------------------------
      ! on entry:
      !----------
      ! ncol  = col dimension of the matrix
      ! ia, ja = input matrix pattern in CSC format.
      ! perm  = integer array of length nrow containing the permutation
      !         arrays for the columns.
      !
      !------------
      ! on return:
      !------------
      ! ia, ja = output matrix pattern in CSC format
      !-----------------------------------------------------------------

      integer :: k, nnz

   !------ end of declarations -- execution starts hereafter  ------

      nnz = ja(ncol+1) - 1

      do k = 1, nnz
         ia(k) = perm(ia(k))
      end do

   end subroutine rowpinv2
!_______________________________________________________________________
!
   subroutine rowperm_cmplx( ncol, a, ia, ja, ao, iao, jao, perm )

      integer,                 intent(in) :: ncol, ia(:), ja(:), perm(:)
      complex(kind=MF_DOUBLE), intent(in) :: a(:)
      integer,                 intent(out) :: iao(:), jao(:)
      complex(kind=MF_DOUBLE), intent(out) :: ao(:)
      !-----------------------------------------------------------------
      ! complex version of 'rowperm'
      !-----------------------------------------------------------------

      integer :: i, j, k, nnz, nrow
      integer, allocatable :: pinv(:)

   !------ end of declarations -- execution starts hereafter  ------

      nrow = maxval(perm)
      allocate( pinv(nrow) )
      pinv(perm) = [ (i, i = 1, nrow ) ]

      nnz = ja(ncol+1) - 1
      do k = 1, nnz
         iao(k) = pinv(ia(k))
      end do

      do j = 1, ncol + 1
         jao(j) = ja(j)
      end do

      do k = 1, nnz
         ao(k) = a(k)
      end do

   end subroutine rowperm_cmplx
!_______________________________________________________________________
!
   subroutine rowpinv_cmplx( ncol, a, ia, ja, ao, iao, jao, perm )

      integer,                 intent(in) :: ncol, ia(:), ja(:), perm(:)
      complex(kind=MF_DOUBLE), intent(in) :: a(:)
      integer,                 intent(out) :: iao(:), jao(:)
      complex(kind=MF_DOUBLE), intent(out) :: ao(:)
      !-----------------------------------------------------------------
      ! complex version of 'rowpinv'
      !-----------------------------------------------------------------

      integer :: j, k, nnz

   !------ end of declarations -- execution starts hereafter  ------

      nnz = ja(ncol+1) - 1
      do k = 1, nnz
         iao(k) = perm(ia(k))
      end do

      do j = 1, ncol + 1
         jao(j) = ja(j)
      end do

      do k = 1, nnz
         ao(k) = a(k)
      end do

   end subroutine rowpinv_cmplx

