! f90 include file

!_______________________________________________________________________
!
   subroutine rowconcat( nrow, ncol, a, ia, ja, b, ib, jb,              &
                         c, ic, jc )

      integer, intent(in) :: nrow, ncol, ia(:), ja(:), ib(:), jb(:)
      real(kind=MF_DOUBLE), intent(in) :: a(:), b(:)
      integer :: ic(:), jc(:)
      real(kind=MF_DOUBLE) :: c(:)
      !------ API end ------

      !-----------------------------------------------------------------
      ! vertical concat of A and B
      ! É. Canot, June 2006
      !-----------------------------------------------------------------
      ! A and B must have the same number of columns: ncol.
      ! arrays describing C must have sufficient room to include A and B
      !-----------------------------------------------------------------

      integer :: j, k, kk

   !------ end of declarations -- execution starts hereafter  ------

      jc(1) = 1
      do j = 2, ncol+1
         jc(j) = jc(j-1) + ja(j)-ja(j-1) + jb(j)-jb(j-1)
      end do

      do j = 1, ncol

         ! copy j-th column of A
         kk = jc(j)
         do k = ja(j), ja(j+1)-1
            ic(kk) = ia(k)
            c(kk) = a(k)
            kk = kk + 1
         end do

         ! copy j-th column of B
         do k = jb(j), jb(j+1)-1
            ic(kk) = ib(k) + nrow
            c(kk) = b(k)
            kk = kk + 1
         end do

      end do

   end subroutine rowconcat
!_______________________________________________________________________
!
   subroutine rowconcat_real_cmplx( nrow, ncol, a, ia, ja, b, ib, jb,   &
                                    c, ic, jc )

      integer, intent(in) :: nrow, ncol, ia(:), ja(:), ib(:), jb(:)
      real(kind=MF_DOUBLE), intent(in) :: a(:)
      complex(kind=MF_DOUBLE), intent(in) :: b(:)
      integer :: ic(:), jc(:)
      complex(kind=MF_DOUBLE) :: c(:)
      !------ API end ------

      !-----------------------------------------------------------------
      ! complex version of 'rowconcat'
      !-----------------------------------------------------------------

      integer :: j, k, kk

   !------ end of declarations -- execution starts hereafter  ------

      jc(1) = 1
      do j = 2, ncol+1
         jc(j) = jc(j-1) + ja(j)-ja(j-1) + jb(j)-jb(j-1)
      end do

      do j = 1, ncol

         ! copy j-th column of A
         kk = jc(j)
         do k = ja(j), ja(j+1)-1
            ic(kk) = ia(k)
            c(kk) = a(k)
            kk = kk + 1
         end do

         ! copy j-th column of B
         do k = jb(j), jb(j+1)-1
            ic(kk) = ib(k) + nrow
            c(kk) = b(k)
            kk = kk + 1
         end do

      end do

   end subroutine rowconcat_real_cmplx
!_______________________________________________________________________
!
   subroutine rowconcat_cmplx_real( nrow, ncol, a, ia, ja, b, ib, jb,   &
                                    c, ic, jc )

      integer, intent(in) :: nrow, ncol, ia(:), ja(:), ib(:), jb(:)
      complex(kind=MF_DOUBLE), intent(in) :: a(:)
      real(kind=MF_DOUBLE), intent(in) :: b(:)
      integer :: ic(:), jc(:)
      complex(kind=MF_DOUBLE) :: c(:)
      !------ API end ------

      !-----------------------------------------------------------------
      ! complex version of 'rowconcat'
      !-----------------------------------------------------------------

      integer :: j, k, kk

   !------ end of declarations -- execution starts hereafter  ------

      jc(1) = 1
      do j = 2, ncol+1
         jc(j) = jc(j-1) + ja(j)-ja(j-1) + jb(j)-jb(j-1)
      end do

      do j = 1, ncol

         ! copy j-th column of A
         kk = jc(j)
         do k = ja(j), ja(j+1)-1
            ic(kk) = ia(k)
            c(kk) = a(k)
            kk = kk + 1
         end do

         ! copy j-th column of B
         do k = jb(j), jb(j+1)-1
            ic(kk) = ib(k) + nrow
            c(kk) = b(k)
            kk = kk + 1
         end do

      end do

   end subroutine rowconcat_cmplx_real
!_______________________________________________________________________
!
   subroutine rowconcat_cmplx_cmplx( nrow, ncol, a, ia, ja, b, ib, jb,  &
                                     c, ic, jc )

      integer, intent(in) :: nrow, ncol, ia(:), ja(:), ib(:), jb(:)
      complex(kind=MF_DOUBLE), intent(in) :: a(:), b(:)
      integer :: ic(:), jc(:)
      complex(kind=MF_DOUBLE) :: c(:)
      !------ API end ------

      !-----------------------------------------------------------------
      ! complex version of 'rowconcat'
      !-----------------------------------------------------------------

      integer :: j, k, kk

   !------ end of declarations -- execution starts hereafter  ------

      jc(1) = 1
      do j = 2, ncol+1
         jc(j) = jc(j-1) + ja(j)-ja(j-1) + jb(j)-jb(j-1)
      end do

      do j = 1, ncol

         ! copy j-th column of A
         kk = jc(j)
         do k = ja(j), ja(j+1)-1
            ic(kk) = ia(k)
            c(kk) = a(k)
            kk = kk + 1
         end do

         ! copy j-th column of B
         do k = jb(j), jb(j+1)-1
            ic(kk) = ib(k) + nrow
            c(kk) = b(k)
            kk = kk + 1
         end do

      end do

   end subroutine rowconcat_cmplx_cmplx
