! f90 include file

!_______________________________________________________________________
!
   subroutine row_auto_scale( nrow, ncol, a, ia, ja, ao, iao, jao, scal )

      integer,              intent(in)  :: nrow, ncol, ia(:), ja(:)
      real(kind=MF_DOUBLE), intent(in)  :: a(:)
      integer,              intent(out) :: iao(:), jao(:)
      real(kind=MF_DOUBLE), intent(out) :: ao(:), scal(:)
      !-----------------------------------------------------------------
      ! This subroutine applies a scaling to the rows of a matrix
      ! in CSC format, such that the max. element in absolute value
      ! in each row is equal to 1.
      ! The scaling factors are output in the vector 'scal'.
      ! -- Édouard Canot -- Mar. 2025
      !-----------------------------------------------------------------
      ! on entry:
      !----------
      ! nrow, ncol  = nb of rows and columns of the matrix
      ! a, ia, ja = input matrix in CSC format
      !
      !------------
      ! on return:
      !------------
      ! ao, iao, jao = output matrix in CSC format
      ! scale = real array of length ncol containing the scaling for
      !         each column which have been applied.
      !-----------------------------------------------------------------

      integer :: i, j, k, nnz

   !------ end of declarations -- execution starts hereafter  ------

      nnz = ja(ncol+1) - 1
      iao(1:nnz)    = ia(1:nnz)
      jao(1:ncol+1) = ja(1:ncol+1)

      scal(1:nrow) = 0.0d0

      do j = 1, ncol
         do k = ja(j), ja(j+1) - 1
            i = ia(k)
            if( abs(a(k)) > scal(i) ) then
               scal(i) = abs(a(k))
            end if
         end do
      end do
      scal(1:nrow) = 1.0d0/scal(1:nrow)
      do j = 1, ncol
         do k = ja(j), ja(j+1) - 1
            ao(k) = a(k)*scal(ia(k))
         end do
      end do

   end subroutine row_auto_scale
!_______________________________________________________________________
!
   subroutine row_auto_scale2( nrow, ncol, a, ia, ja, scal )

      integer,              intent(in)     :: nrow, ncol
      integer,              intent(in out) :: ia(:), ja(:)
      real(kind=MF_DOUBLE), intent(in out) :: a(:)
      real(kind=MF_DOUBLE), intent(out)    :: scal(:)
      !-----------------------------------------------------------------
      ! this subroutine applies an 'in-place' scaling to the rows of
      ! a matrix in CSC format, such that the max. element in absolute
      ! value in each row is equal to 1.
      ! The scaling factors are output in the vector 'scal'.
      ! -- Édouard Canot -- Mar. 2025
      !-----------------------------------------------------------------
      ! on entry:
      !----------
      ! ncol  = nb of columns of the matrix
      ! a, ia, ja = input matrix in CSC format
      ! scale = real array of length ncol containing the scaling for
      !         each column.
      !
      !------------
      ! on return:
      !------------
      ! a, ia, ja = output matrix in CSC format
      !-----------------------------------------------------------------

      integer :: i, j, k, nnz

   !------ end of declarations -- execution starts hereafter  ------

      nnz = ja(ncol+1) - 1

      do j = 1, ncol
         do k = ja(j), ja(j+1) - 1
            i = ia(k)
            if( abs(a(k)) > scal(i) ) then
               scal(i) = abs(a(k))
            end if
         end do
      end do
      scal(1:nrow) = 1.0d0/scal(1:nrow)
      do j = 1, ncol
         do k = ja(j), ja(j+1) - 1
            a(k) = a(k)*scal(ia(k))
         end do
      end do

   end subroutine row_auto_scale2
