! f90 include file

!_______________________________________________________________________
!
   subroutine reshape_sparse( nrowa, ncola, a, ia, ja,                  &
                              nrowo, ncolo, o, io, jo )

      integer,              intent(in)  :: nrowa, ncola, ia(:), ja(:)
      real(kind=MF_DOUBLE), intent(in)  :: a(:)
      integer,              intent(in)  :: nrowo, ncolo
      integer,              intent(out) :: io(:), jo(:)
      real(kind=MF_DOUBLE), intent(out) :: o(:)
      !------ API end ------

      !-----------------------------------------------------------------
      ! This subroutine reshapes a matrix stored in CSC format.
      ! A must be 'row sorted'
      !-----------------------------------------------------------------
      ! on entry:
      !----------
      !
      ! nrowa = integer. The row dimension of the matrix A.
      ! ncola = integer. The column dimension of the matrix A.
      ! a, ia, ja = matrix stored in CSC format
      !
      ! nrowo = integer. The row dimension of the output matrix O.
      ! ncolo = integer. The column dimension of the output matrix O.
      !
      ! on return:
      !-----------
      !
      ! o, io, jo = matrix stored in CSC format (row sorted).
      !-----------------------------------------------------------------

      ! local variables
      integer :: j, k, long_k, jj, ii, nnz, kount

   !------ end of declarations -- execution starts hereafter  ------

      nnz = ja(ncola+1) - 1
      kount = 0
      jo(2:ncolo+1) = 0

      do j = 1, ncola
         do k = ja(j), ja(j+1)-1
            long_k = (j-1)*nrowa + ia(k)
            jj = (long_k-1)/nrowo + 1
            ii = long_k - (jj-1)*nrowo
            kount = kount + 1
            io(kount) = ii
            jo(jj+1) = jo(jj+1) + 1
         end do
      end do

      ! from column length to offset
      jo(1) = 1
      do k = 2, ncolo+1
         jo(k) = jo(k-1) + jo(k)
      end do

      o(1:nnz) = a(1:nnz)

   end subroutine reshape_sparse
!_______________________________________________________________________
!
   subroutine reshape_sparse_cmplx( nrowa, ncola, a, ia, ja,            &
                                    nrowo, ncolo, o, io, jo )

      integer,                 intent(in)  :: nrowa, ncola, ia(:), ja(:)
      complex(kind=MF_DOUBLE), intent(in)  :: a(:)
      integer,                 intent(in)  :: nrowo, ncolo
      integer,                 intent(out) :: io(:), jo(:)
      complex(kind=MF_DOUBLE), intent(out) :: o(:)
      !------ API end ------

      !-----------------------------------------------------------------
      ! complex version of 'reshape_sparse'
      !-----------------------------------------------------------------

      ! local variables
      integer :: j, k, long_k, jj, ii, nnz, kount

   !------ end of declarations -- execution starts hereafter  ------

      nnz = ja(ncola+1) - 1
      kount = 0
      jo(2:ncolo+1) = 0

      do j = 1, ncola
         do k = ja(j), ja(j+1)-1
            long_k = (j-1)*nrowa + ia(k)
            jj = (long_k-1)/nrowo + 1
            ii = long_k - (jj-1)*nrowo
            kount = kount + 1
            io(kount) = ii
            jo(jj+1) = jo(jj+1) + 1
         end do
      end do

      ! from column length to offset
      jo(1) = 1
      do k = 2, ncolo+1
         jo(k) = jo(k-1) + jo(k)
      end do

      o(1:nnz) = a(1:nnz)

   end subroutine reshape_sparse_cmplx
!_______________________________________________________________________
!
   subroutine reshape_sp_inplace( nrow, ncol, ia, ja,                 &
                                  nrow2, ncol2, jo )

      integer, intent(in)     :: nrow, ncol, ja(:)
      integer, intent(in out) :: ia(:)
      integer, intent(in)     :: nrow2, ncol2
      integer, intent(out)    :: jo(:)
      !------ API end ------

      !-----------------------------------------------------------------
      ! This subroutine reshapes a matrix stored in CSC format (in-place
      ! version). A doesn't need to be 'row sorted'.
      ! jo(1:ncol2+1) must be allocated in the calling routine.
      !-----------------------------------------------------------------
      ! on entry:
      !----------
      !
      ! nrow = integer. The row dimension of the matrix A.
      ! ncol = integer. The column dimension of the matrix A.
      ! ia, ja = matrix structure stored in CSC format
      !
      ! nrow2 = integer. The new row dimension of A.
      ! ncol2 = integer. The new column dimension of A.
      !
      ! on return:
      !-----------
      !
      ! ia, jo = matrix structure stored in CSC format (row sorted).
      !-----------------------------------------------------------------

      ! local variables
      integer :: j, k, long_k, jj

   !------ end of declarations -- execution starts hereafter  ------

      jo(2:ncol2+1) = 0

      do j = 1, ncol
         do k = ja(j), ja(j+1)-1
            long_k = (j-1)*nrow + ia(k)
            jj = (long_k-1)/nrow2 + 1
            ia(k) = long_k - (jj-1)*nrow2
            jo(jj+1) = jo(jj+1) + 1
         end do
      end do

      ! from column length to offset
      jo(1) = 1
      do k = 2, ncol2+1
         jo(k) = jo(k-1) + jo(k)
      end do

   end subroutine reshape_sp_inplace
