! f90 include file

!_______________________________________________________________________
!
   subroutine normcols( ncol, a, ia, ja, s )

      integer, intent(in)  :: ncol, ia(:), ja(:)
      real(kind=MF_DOUBLE), intent(in)  :: a(:)
      real(kind=MF_DOUBLE), intent(out) :: s(:)
      !------ API end ------

      !-----------------------------------------------------------------
      ! compute the norm-2 of each col of a matrix in CSC format, and
      ! store it in a dense vector.
      !-----------------------------------------------------------------
      ! on entry:
      !----------
      ! ncol = integer : number of cols of the input matrix
      !
      ! a, ia, ja = input matrix in CSC format
      !
      !------------
      ! on return:
      !------------
      ! s = dense vector : s(1:ncol) contains the norm-2 of all columns.
      !     the length of s must be sufficient to store its elements
      !-----------------------------------------------------------------

      integer :: j, k

   !------ end of declarations -- execution starts hereafter  ------

      s(1:ncol) = 0.0d0

      do j = 1, ncol
         do k = ja(j), ja(j+1)-1
            s(j) = s(j) + a(k)**2
         end do
         s(j) = sqrt( s(j) )
      end do

   end subroutine normcols
