! f90 include file

!_______________________________________________________________________
!
   function norm1_real( ncol, a, ia, ja ) result( norm1 )

      integer :: ncol
      real(kind=MF_DOUBLE) :: a(:)
      integer :: ia(:), ja(:)
      real(kind=MF_DOUBLE) :: norm1
      !------ API end ------

      !-----------------------------------------------------------------
      ! computes the norm-1 of a CSC sparse matrix A.
      ! (adapted from SPARSKIT2 (Mar 8 2005) 'rnrms' by É. Canot)
      !-----------------------------------------------------------------
      ! on entry:
      ! ---------
      ! ncol = col dimension of A
      !
      ! a, ia, ja = Matrix A in CSC format.
      !
      ! on return:
      !----------
      !
      ! norm1 = norm-1 of matrix A, i.e., largest column sum
      !-----------------------------------------------------------------

      real(kind=MF_DOUBLE) :: scal, diag(ncol)
      integer :: j, k

   !------ end of declarations -- execution starts hereafter  ------

      do j = 1, ncol
         ! compute the sum of each row.
         scal = 0.0d0
         do k = ja(j), ja(j+1)-1
            scal = scal + abs(a(k))
         end do
         diag(j) = scal
      end do
      norm1 = maxval( diag )

   end function norm1_real
!_______________________________________________________________________
!
   function norm1_cmplx( ncol, a, ia, ja ) result( norm1 )

      integer :: ncol
      complex(kind=MF_DOUBLE) :: a(:)
      integer :: ia(:), ja(:)
      real(kind=MF_DOUBLE) :: norm1
      !------ API end ------

      !-----------------------------------------------------------------
      ! complex version of 'norm1'
      !-----------------------------------------------------------------

      real(kind=MF_DOUBLE) :: scal, diag(ncol)
      integer :: j, k

   !------ end of declarations -- execution starts hereafter  ------

      do j = 1, ncol
         ! compute the sum of each row.
         scal = 0.0d0
         do k = ja(j), ja(j+1)-1
            scal = scal + abs(a(k))
         end do
         diag(j) = scal
      end do
      norm1 = maxval( diag )

   end function norm1_cmplx
!_______________________________________________________________________
!
   function norminf_real( nrow, ncol, a, ia, ja ) result( norminf )

      integer :: nrow, ncol
      real(kind=MF_DOUBLE) :: a(:)
      integer :: ia(:), ja(:)
      real(kind=MF_DOUBLE) :: norminf
      !------ API end ------

      !-----------------------------------------------------------------
      ! gets the norm-1 of each row of A.
      !-----------------------------------------------------------------
      ! on entry:
      ! ---------
      ! nrow, ncol = row and col dimension of A
      !
      ! a, ia, ja = Matrix A in CSC format.
      !
      ! on return:
      !----------
      !
      ! norminf = norm-inf of matrix A, i.e., largest row sum
      !
      !-----------------------------------------------------------------

      real(kind=MF_DOUBLE) :: diag(nrow)
      integer :: i, j, k

   !------ end of declarations -- execution starts hereafter  ------

      do k = 1, nrow
         diag(k) = 0.0d0
      end do
      do j = 1, ncol
         do k = ja(j), ja(j+1)-1
            i = ia(k)
            ! update the norm of each column
            diag(i) = diag(i) + abs(a(k) )
         end do
      end do
      norminf = maxval( diag )

   end function norminf_real
!_______________________________________________________________________
!
   function norminf_cmplx( nrow, ncol, a, ia, ja ) result( norminf )

      integer :: nrow, ncol
      complex(kind=MF_DOUBLE) :: a(:)
      integer :: ia(:), ja(:)
      real(kind=MF_DOUBLE) :: norminf
      !------ API end ------

      !-----------------------------------------------------------------
      ! complex version of 'norminf'
      !-----------------------------------------------------------------

      real(kind=MF_DOUBLE) :: diag(nrow)
      integer :: i, j, k

   !------ end of declarations -- execution starts hereafter  ------

      do k = 1, nrow
         diag(k) = 0.0d0
      end do
      do j = 1, ncol
         do k = ja(j), ja(j+1)-1
            i = ia(k)
            ! update the norm of each column
            diag(i) = diag(i) + abs(a(k) )
         end do
      end do
      norminf = maxval( diag )

   end function norminf_cmplx
