! f90 include file

!_______________________________________________________________________
!
   subroutine nnzxtrcols( i1, i2, ia, ja, iperm, nnz )

      integer, intent(in)  :: i1, i2, ia(:), ja(:), iperm(:)
      integer :: nnz
      !------ API end ------

      !-----------------------------------------------------------------
      ! before extracting given cols from a matrix in CSC format,
      ! gets the number of nonzero elements.
      !-----------------------------------------------------------------
      ! on entry:
      !----------
      ! i1, i2  = two integers indicating the cols to be extracted.
      !           xtrcols will extract cols :
      !                  iperm(i1), iperm(i1+1), ..., iperm(i2)
      !           from original matrix.
      !
      ! ia, ja = input matrix in CSC format (structure only)
      !
      ! iperm = integer array of length at least (i2-i1+1)
      !
      !------------
      ! on return:
      !------------
      ! nnz = total number of nonzero elements
      !-----------------------------------------------------------------

      integer :: j, jj, k

   !------ end of declarations -- execution starts hereafter  ------

      nnz = 0

      do j = i1, i2
         ! iperm(j) is the index of old col to be copied.
         jj = iperm(j)
         do k = ja(jj), ja(jj+1)-1
            nnz = nnz + 1
         end do
      end do

   end subroutine nnzxtrcols
