! f90 include file

!_______________________________________________________________________
!
   subroutine nnzatmub( ncol, ncolb, ia, ja, ib, jb, nnz )

      integer, intent(in) :: ncol, ncolb
      integer, intent(in) :: ia(:), ja(:), ib(:), jb(:)
      integer             :: nnz
      !------ API end ------

      !-----------------------------------------------------------------------
      ! gets the number of nonzero elements in A'*B.
      ! É. Canot -- 24 feb 2012
      !-----------------------------------------------------------------------
      ! on entry:
      ! --------
      ! ncol = column dimension of A.
      ! ncolb = column dimension of B.
      !
      ! a, ia, ja = Matrix A in CSC format (must be row sorted).
      !
      ! b, ib, jb = Matrix B in CSC format (must be row sorted).
      !
      ! on return:
      ! ---------
      ! nnz = upper bound for the number of nonzero elements found in A'*B
      !-----------------------------------------------------------------------

      integer :: j, jj, ka, kb, ka_end

   !------ end of declarations -- execution starts hereafter  ------

!###############################################################
!###############################################################
! Attention, cet algo est en N^2, alors que nnzamub est en N !
!###############################################################
!###############################################################

      nnz = 0

      ! builds column vectors of C
      do j = 1, ncolb
         do jj = 1, ncol
            ! dot product of the two (sparse) vectors: col(jj)-A by col(j)-B
            ka = ja(jj)
            ka_end = ja(jj+1) - 1
            if( ka_end < ka ) then
               ! empty column of A: no need to compute the dot product
               cycle
            end if
            do kb = jb(j), jb(j+1)-1
               ! looking for ia(ka) = ib(kb)
               if( ia(ka) < ib(kb) ) then
                  if( ka == ka_end ) then ! end of dot product
                     exit
                  end if
                  ! increase ka
                  do
                     if( ka == ka_end ) then
                        exit
                     end if
                     ka = ka + 1
                     if( ia(ka) >= ib(kb) ) exit
                  end do
               end if
               if( ia(ka) == ib(kb) ) then
                  nnz = nnz + 1
                  exit
               end if
            end do
         end do
      end do

   end subroutine nnzatmub
