! f90 include file

!_______________________________________________________________________
!
   subroutine nnzaplb( nrow, ncol, ia, ja, ib, jb, nnz )

      integer, intent(in) :: nrow, ncol
      integer, intent(in) :: ia(:), ja(:), ib(:), jb(:)
      integer             :: nnz
      !------ API end ------

      !-----------------------------------------------------------------
      ! gets the number of nonzero elements in A +/- B
      ! (adapted from SPARSKIT2 (Mar 8 2005) 'aplbdg' by É. Canot)
      !-----------------------------------------------------------------
      ! on entry:
      ! ---------
      ! nrow = row dimension of A and B
      ! ncol = column dimension of A and B.
      !
      ! a, ia, ja = Matrix A in CSC format.
      !
      ! b, ib, jb = Matrix B in CSC format.
      !
      ! on return:
      !----------
      ! nnz = total number of nonzero elements found in A +/- B
      !-----------------------------------------------------------------

      logical :: zw(nrow)
      integer :: i, j

   !------ end of declarations -- execution starts hereafter  ------

      nnz = 0

      zw(:) = .true.

      do j = 1, ncol

         ! col of A
         do i = ja(j), ja(j+1)-1
            nnz = nnz + 1
            zw(ia(i)) = .false.
         end do

         ! col of B
         do i = jb(j), jb(j+1)-1
            if( zw(ib(i)) ) then
               nnz = nnz + 1
            end if
         end do

         do i = ja(j), ja(j+1)-1
            zw(ia(i)) = .true.
         end do

      end do

   end subroutine nnzaplb
