! f90 include file

!_______________________________________________________________________
!
   subroutine nnzamub( nrow, ncolb, ia, ja, ib, jb, nnz )

      integer, intent(in) :: nrow, ncolb
      integer, intent(in) :: ia(:), ja(:), ib(:), jb(:)
      integer             :: nnz
      !------ API end ------

      !-----------------------------------------------------------------------
      ! gets the number of nonzero elements in A*B.
      ! (adapted from 'amubdg', SPARSKIT)
      !-----------------------------------------------------------------------
      ! on entry:
      ! --------
      ! nrow = row dimension of A
      ! ncolb = column dimension of B.
      !
      ! a, ia, ja = Matrix A in CSC format.
      !
      ! b, ib, jb = Matrix B in CSC format.
      !
      ! on return:
      ! ---------
      ! nnz = total number of nonzero elements found in A*B
      !-----------------------------------------------------------------------

      integer :: iw(nrow)
      integer :: j, ka, ir, kb, ic

   !------ end of declarations -- execution starts hereafter  ------

      nnz = 0

      do j = 1, ncolb

         iw(:) = 0

         do kb = jb(j), jb(j+1)-1

            ir = ib(kb)
            do ka = ja(ir), ja(ir+1)-1
               ic = ia(ka)
               if( iw(ic) == 0 ) then
                  nnz = nnz + 1
                  iw(ic) = 1
               end if
            end do

         end do

      end do

   end subroutine nnzamub
