! f90 include file

!_______________________________________________________________________
!
   subroutine minab1_omitNaN( nrow, ncol, a, ia, ja, b, ib, jb,         &
                              c, ic, jc, nzmax, jerr )
      real(kind=MF_DOUBLE), intent(in)  :: a(:), b(:)
      integer,              intent(in)  :: ia(:), ib(:), ja(:), jb(:)
      integer,              intent(in)  :: nrow, ncol, nzmax
      real(kind=MF_DOUBLE), intent(out) :: c(:)
      integer,              intent(out) :: ic(:), jc(:), jerr
      !------ API end ------

      !-----------------------------------------------------------------
      ! Performs the matrix min  C = min(A,B)  element-wise, for
      ! matrices in sorted CSC format. The difference with aplb is that
      ! the resulting matrix is such that the elements of each col are
      ! sorted with increasing row indexes, provided the original
      ! matrices are sorted in the same way.
      ! (adapted from routine 'aplb1' by É. Canot)
      !
      ! This version discards possible NaNs in the sparse matrix.
      !-----------------------------------------------------------------
      ! on entry:
      ! ---------
      ! nrow = integer. The row dimension of A and B
      ! ncol = integer. The column dimension of A and B.
      !
      ! a, ia, ja = Matrix A in CSC format with entries sorted
      !             ascendly in each col.
      !
      ! b, ib, jb = Matrix B in CSC format with entries sorted
      !             ascendly in each col.
      !
      ! nzmax = integer. The length of the arrays c and ic.
      !         minab1 will stop if the result matrix C has a number
      !         of elements that exceeds nzmax. See jerr.
      !
      ! on return:
      !----------
      ! c, ic, jc  = resulting matrix C in CSC format with entries
      !              sorted ascendly in each col.
      !
      ! jerr = integer. serving as error message.
      !        jerr = 0 means normal return,
      !        jerr > 0 means that minab1 stopped while computing the
      !                 j-th col of C with j=jerr, because the number
      !                 of elements in C exceeds nzmax.
      !-----------------------------------------------------------------

      integer :: i1, i2, j, ka, kb, kc, kamax, kbmax
      real(kind=MF_DOUBLE) :: tmp

   !------ end of declarations -- execution starts hereafter  ------

      jerr = 0
      kc = 1
      jc(1) = kc

      do j = 1, ncol
         ka = ja(j)
         kb = jb(j)
         kamax = ja(j+1)-1
         kbmax = jb(j+1)-1
         do while( ka <= kamax .or. kb <= kbmax )
            if( ka <= kamax ) then
               i1 = ia(ka)
            else
               i1 = nrow+1
            end if
            if( kb <= kbmax ) then
               i2 = ib(kb)
            else
               i2 = nrow+1
            end if

            ! three cases

            if( kc > nzmax ) goto 99
            if( i1 == i2 ) then
               c(kc) = mf_min_omitNaN_scal_scal( a(ka), b(kb) )
               ic(kc) = i1
               kc = kc+1
               ka = ka+1
               kb = kb+1
            else if( i1 < i2 ) then
               tmp = mf_min_omitNaN_scal_scal( a(ka), 0.0d0 )
               if( tmp /= 0.0d0 ) then ! storing only non-zero values
                  c(kc) = tmp
                  ic(kc) = i1
                  kc = kc+1
               end if
               ka = ka+1
            else if( i1 > i2 ) then
               tmp = mf_min_omitNaN_scal_scal( 0.0d0, b(kb) )
               if( tmp /= 0.0d0 ) then ! storing only non-zero values
                  c(kc) = tmp
                  ic(kc) = i2
                  kc = kc+1
               end if
               kb = kb+1
            end if
         end do
         jc(j+1) = kc
      end do
      return
 99   jerr = j

   end subroutine minab1_omitNaN
!_______________________________________________________________________
!
   subroutine minab1_includeNaN( nrow, ncol, a, ia, ja, b, ib, jb,      &
                              c, ic, jc, nzmax, jerr )
      real(kind=MF_DOUBLE), intent(in)  :: a(:), b(:)
      integer,              intent(in)  :: ia(:), ib(:), ja(:), jb(:)
      integer,              intent(in)  :: nrow, ncol, nzmax
      real(kind=MF_DOUBLE), intent(out) :: c(:)
      integer,              intent(out) :: ic(:), jc(:), jerr
      !------ API end ------

      !-----------------------------------------------------------------
      ! Performs the matrix min  C = min(A,B)  element-wise, for
      ! matrices in sorted CSC format. The difference with aplb is that
      ! the resulting matrix is such that the elements of each col are
      ! sorted with increasing row indexes, provided the original
      ! matrices are sorted in the same way.
      ! (adapted from routine 'aplb1' by É. Canot)
      !
      ! This version discards possible NaNs in the sparse matrix.
      !-----------------------------------------------------------------
      ! on entry:
      ! ---------
      ! nrow = integer. The row dimension of A and B
      ! ncol = integer. The column dimension of A and B.
      !
      ! a, ia, ja = Matrix A in CSC format with entries sorted
      !             ascendly in each col.
      !
      ! b, ib, jb = Matrix B in CSC format with entries sorted
      !             ascendly in each col.
      !
      ! nzmax = integer. The length of the arrays c and ic.
      !         minab1 will stop if the result matrix C has a number
      !         of elements that exceeds nzmax. See jerr.
      !
      ! on return:
      !----------
      ! c, ic, jc  = resulting matrix C in CSC format with entries
      !              sorted ascendly in each col.
      !
      ! jerr = integer. serving as error message.
      !        jerr = 0 means normal return,
      !        jerr > 0 means that minab1 stopped while computing the
      !                 j-th col of C with j=jerr, because the number
      !                 of elements in C exceeds nzmax.
      !-----------------------------------------------------------------

      integer :: i1, i2, j, ka, kb, kc, kamax, kbmax
      real(kind=MF_DOUBLE) :: tmp

   !------ end of declarations -- execution starts hereafter  ------

      jerr = 0
      kc = 1
      jc(1) = kc

      do j = 1, ncol
         ka = ja(j)
         kb = jb(j)
         kamax = ja(j+1)-1
         kbmax = jb(j+1)-1
         do while( ka <= kamax .or. kb <= kbmax )
            if( ka <= kamax ) then
               i1 = ia(ka)
            else
               i1 = nrow+1
            end if
            if( kb <= kbmax ) then
               i2 = ib(kb)
            else
               i2 = nrow+1
            end if

            ! three cases

            if( kc > nzmax ) goto 99
            if( i1 == i2 ) then
               c(kc) = mf_min_includeNaN_scal_scal( a(ka), b(kb) )
               ic(kc) = i1
               kc = kc+1
               ka = ka+1
               kb = kb+1
            else if( i1 < i2 ) then
               tmp = mf_min_includeNaN_scal_scal( a(ka), 0.0d0 )
               if( tmp /= 0.0d0 ) then ! storing only non-zero values
                  c(kc) = tmp
                  ic(kc) = i1
                  kc = kc+1
               end if
               ka = ka+1
            else if( i1 > i2 ) then
               tmp = mf_min_includeNaN_scal_scal( 0.0d0, b(kb) )
               if( tmp /= 0.0d0 ) then ! storing only non-zero values
                  c(kc) = tmp
                  ic(kc) = i2
                  kc = kc+1
               end if
               kb = kb+1
            end if
         end do
         jc(j+1) = kc
      end do
      return
 99   jerr = j

   end subroutine minab1_includeNaN
