! f90 include file

!_______________________________________________________________________
!
   subroutine maxab_omitNaN( nrow, ncol, a, ia, ja, b, ib, jb,          &
                             c, ic, jc, nzmax, jerr )
      real(kind=MF_DOUBLE), intent(in)  :: a(:), b(:)
      integer,              intent(in)  :: ia(:), ib(:), ja(:), jb(:)
      integer,              intent(in)  :: nrow, ncol, nzmax
      real(kind=MF_DOUBLE), intent(out) :: c(:)
      integer,              intent(out) :: ic(:), jc(:), jerr
      !------ API end ------

      !-----------------------------------------------------------------
      ! Performs the matrix max  C = max(A,B)  element-wise.
      ! (adapted from routine 'aplb.inc' by É. Canot)
      !
      ! This version discards possible NaNs in the sparse matrix.
      !-----------------------------------------------------------------
      ! on entry:
      ! ---------
      ! nrow = integer. The row dimension of A and B
      ! ncol = integer. The column dimension of A and B.
      !
      ! a, ia, ja = Matrix A in CSC format.
      !
      ! b, ib, jb = Matrix B in CSC format.
      !
      ! nzmax = integer. The length of the arrays c and ic.
      !         maxab will stop if the result matrix C has a number
      !         of elements that exceeds nzmax. See jerr.
      !
      ! on return:
      !----------
      ! c, ic, jc = resulting matrix C in CSC format.
      !
      ! jerr = integer. serving as error message.
      !        jerr = 0 means normal return,
      !        jerr > 0 means that maxab stopped while computing the
      !                 j-th col of C with j=jerr, because the number
      !                 of elements in C exceeds nzmax.
      !-----------------------------------------------------------------

      integer :: iw(nrow)
      integer :: j, k, len, irow, ipos
      integer :: len_a, len_b

   !------ end of declarations -- execution starts hereafter  ------

      jerr = 0
      len = 0
      jc(1) = 1
      iw(:) = 0

      do j = 1, ncol
         ! choosing the shortest loop first
         len_a = ja(j+1) - ja(j)
         len_b = jb(j+1) - jb(j)
         if( len_a < len_b ) then
            do k = ja(j), ja(j+1)-1
               len = len + 1
               irow = ia(k)
               if( len > nzmax ) goto 99
               ic(len) = irow
               c(len) = a(k) ! cannot yet put : max( a(k), 0.0d0 )
               iw(irow) = len
            end do
            do k = jb(j), jb(j+1)-1
               irow = ib(k)
               ipos = iw(irow)
               if( ipos == 0 ) then
                  len = len + 1
                  if( len > nzmax ) goto 99
                  ic(len) = irow
                  c(len) = mf_max_omitNaN_scal_scal( 0.0d0, b(k) )
               else
                  c(ipos) = mf_max_omitNaN_scal_scal( c(ipos), b(k) )
                  ! unmark an item of A already 'used'
                  iw(irow) = 0
               end if
            end do
            ! one more loop to take into account : max( a(k), 0.0d0 )
            do k = ja(j), ja(j+1)-1
               irow = ia(k)
               ipos = iw(irow)
               if( ipos /= 0 ) then
                  c(ipos) = mf_max_omitNaN_scal_scal( c(ipos), 0.0d0 )
               end if
            end do
         else
            do k = jb(j), jb(j+1)-1
               len = len + 1
               irow = ib(k)
               if( len > nzmax ) goto 99
               ic(len) = irow
               c(len) = b(k) ! cannot yet put : max( 0.0d0, b(k) )
               iw(irow) = len
            end do
            do k = ja(j), ja(j+1)-1
               irow = ia(k)
               ipos = iw(irow)
               if( ipos == 0 ) then
                  len = len + 1
                  if( len > nzmax ) goto 99
                  ic(len) = irow
                  c(len) = mf_max_omitNaN_scal_scal( a(k), 0.0d0 )
               else
                  c(ipos) = mf_max_omitNaN_scal_scal( a(k), c(ipos) )
                  ! unmark an item of B already 'used'
                  iw(irow) = 0
               end if
            end do
            ! one more loop to take into account : max( 0.0d0, b(k) )
            do k = jb(j), jb(j+1)-1
               irow = ib(k)
               ipos = iw(irow)
               if( ipos /= 0 ) then
                  c(ipos) = mf_max_omitNaN_scal_scal( 0.0d0, c(ipos) )
               end if
            end do
         end if
         do k = jc(j), len
            iw(ic(k)) = 0
         end do
         jc(j+1) = len + 1
      end do
      return
 99   jerr = j

   end subroutine maxab_omitNaN
!_______________________________________________________________________
!
   subroutine maxab_includeNaN( nrow, ncol, a, ia, ja, b, ib, jb,       &
                                c, ic, jc, nzmax, jerr )
      real(kind=MF_DOUBLE), intent(in)  :: a(:), b(:)
      integer,              intent(in)  :: ia(:), ib(:), ja(:), jb(:)
      integer,              intent(in)  :: nrow, ncol, nzmax
      real(kind=MF_DOUBLE), intent(out) :: c(:)
      integer,              intent(out) :: ic(:), jc(:), jerr
      !------ API end ------

      !-----------------------------------------------------------------
      ! Performs the matrix max  C = max(A,B)  element-wise.
      ! (adapted from routine 'aplb.inc' by É. Canot)
      !
      ! Possible NaNs are taken into account in this version.
      !-----------------------------------------------------------------
      ! on entry:
      ! ---------
      ! nrow = integer. The row dimension of A and B
      ! ncol = integer. The column dimension of A and B.
      !
      ! a, ia, ja = Matrix A in CSC format.
      !
      ! b, ib, jb = Matrix B in CSC format.
      !
      ! nzmax = integer. The length of the arrays c and ic.
      !         maxab will stop if the result matrix C has a number
      !         of elements that exceeds nzmax. See jerr.
      !
      ! on return:
      !----------
      ! c, ic, jc = resulting matrix C in CSC format.
      !
      ! jerr = integer. serving as error message.
      !        jerr = 0 means normal return,
      !        jerr > 0 means that maxab stopped while computing the
      !                 j-th col of C with j=jerr, because the number
      !                 of elements in C exceeds nzmax.
      !-----------------------------------------------------------------

      integer :: iw(nrow)
      integer :: j, k, len, irow, ipos
      integer :: len_a, len_b

   !------ end of declarations -- execution starts hereafter  ------

      jerr = 0
      len = 0
      jc(1) = 1
      iw(:) = 0

      do j = 1, ncol
         ! choosing the shortest loop first
         len_a = ja(j+1) - ja(j)
         len_b = jb(j+1) - jb(j)
         if( len_a < len_b ) then
            do k = ja(j), ja(j+1)-1
               len = len + 1
               irow = ia(k)
               if( len > nzmax ) goto 99
               ic(len) = irow
               c(len) = a(k) ! cannot yet put : max( a(k), 0.0d0 )
               iw(irow) = len
            end do
            do k = jb(j), jb(j+1)-1
               irow = ib(k)
               ipos = iw(irow)
               if( ipos == 0 ) then
                  len = len + 1
                  if( len > nzmax ) goto 99
                  ic(len) = irow
                  c(len) = mf_max_includeNaN_scal_scal( 0.0d0, b(k) )
               else
                  c(ipos) = mf_max_includeNaN_scal_scal( c(ipos), b(k) )
                  ! unmark an item of A already 'used'
                  iw(irow) = 0
               end if
            end do
            ! one more loop to take into account : max( a(k), 0.0d0 )
            do k = ja(j), ja(j+1)-1
               irow = ia(k)
               ipos = iw(irow)
               if( ipos /= 0 ) then
                  c(ipos) = mf_max_includeNaN_scal_scal( c(ipos), 0.0d0 )
               end if
            end do
         else
            do k = jb(j), jb(j+1)-1
               len = len + 1
               irow = ib(k)
               if( len > nzmax ) goto 99
               ic(len) = irow
               c(len) = b(k) ! cannot yet put : max( 0.0d0, b(k) )
               iw(irow) = len
            end do
            do k = ja(j), ja(j+1)-1
               irow = ia(k)
               ipos = iw(irow)
               if( ipos == 0 ) then
                  len = len + 1
                  if( len > nzmax ) goto 99
                  ic(len) = irow
                  c(len) = mf_max_includeNaN_scal_scal( a(k), 0.0d0 )
               else
                  c(ipos) = mf_max_includeNaN_scal_scal( a(k), c(ipos) )
                  ! unmark an item of B already 'used'
                  iw(irow) = 0
               end if
            end do
            ! one more loop to take into account : max( 0.0d0, b(k) )
            do k = jb(j), jb(j+1)-1
               irow = ib(k)
               ipos = iw(irow)
               if( ipos /= 0 ) then
                  c(ipos) = mf_max_includeNaN_scal_scal( 0.0d0, c(ipos) )
               end if
            end do
         end if
         do k = jc(j), len
            iw(ic(k)) = 0
         end do
         jc(j+1) = len + 1
      end do
      return
 99   jerr = j

   end subroutine maxab_includeNaN
