! f90 include file

!_______________________________________________________________________
!
   function max_diag_At_A( ncol, a, ia, ja ) result( res )

      integer, intent(in) :: ncol
      real(kind=MF_DOUBLE), intent(in) :: a(:)
      integer, intent(in) :: ia(:), ja(:)
      real(kind=MF_DOUBLE) :: res
      !------ API end ------

      !-----------------------------------------------------------------
      ! computes the expression: max( diag( A' * A ) ) without storing
      ! the whole matrix product A'*A.
      ! This expression is also the maximum of the norm-2 of the
      ! columns of A.
      !-----------------------------------------------------------------
      ! on entry:
      ! ---------
      ! ncol = column dimension of A
      !
      ! a, ia, ja = Matrix A in CSC format.
      !
      ! on return:
      !----------
      ! res  = max( diag( A' * A ) )
      !-----------------------------------------------------------------

      integer :: j, k
      real(kind=MF_DOUBLE) :: sum

   !------ end of declarations -- execution starts hereafter  ------

      res = 0.0d0

      ! processes each column of A
      do j = 1, ncol
         sum = 0.0d0
         do k = ja(j), ja(j+1)-1
            sum = sum + a(k)**2
         end do
         if( sum > res ) then
            res = sum
         end if
      end do

   end function max_diag_At_A
!_______________________________________________________________________
!
   function max_diag_At_A_cmplx( ncol, a, ia, ja ) result( res )

      integer, intent(in) :: ncol
      complex(kind=MF_DOUBLE), intent(in) :: a(:)
      integer, intent(in) :: ia(:), ja(:)
      real(kind=MF_DOUBLE) :: res
      !------ API end ------

      !-----------------------------------------------------------------
      ! complex version of 'max_diag_At_A'
      !-----------------------------------------------------------------

      integer :: j, k
      real(kind=MF_DOUBLE) :: sum

   !------ end of declarations -- execution starts hereafter  ------

      res = 0.0d0

      ! processes each column of A
      do j = 1, ncol
         sum = 0.0d0
         do k = ja(j), ja(j+1)-1
            sum = sum + dble( a(k)*conjg(a(k)) )
         end do
         if( sum > res ) then
            res = sum
         end if
      end do

   end function max_diag_At_A_cmplx
