! f90 include file

!_______________________________________________________________________
!
   function istriu( nrow, ncol, ia, ja, row_sorted ) result( bool )

      integer, intent(in) :: nrow, ncol, ia(:), ja(:)
      integer, intent(in) :: row_sorted
      logical :: bool
      !------ API end ------

      !-----------------------------------------------------------------
      ! Checks whether the pattern of a sparse matrix is upper triang.
      ! (É. Canot -- IPR/CNRS)
      ! the input matrix doesn't need to be square or row sorted.
      !-----------------------------------------------------------------
      ! On entry:
      !--------------
      ! nrow    = number of rows in matrix
      ! ncol    = number of cols in matrix
      ! ia, ja  = sparsity structure of matrix in CSC format
      ! row_sorted (TRUE, FALSE or UNKNOWN) = indicates whether the
      !           matrix have its row indexes sorted in increasing order
      !
      ! On return:
      !---------------
      ! bool = .true. : indicates that matrix has the requested property
      !-----------------------------------------------------------------

      integer :: n, j, k, k_end, j_end

   !------ end of declarations -- execution starts hereafter  ------

      bool = .false.

      if( nrow > ncol ) then
         n = ncol
         j_end = n
      else
         n = nrow
         j_end = n - 1
      end if

      ! in each n first col, all sub-diagonal elements must be null

      if( row_sorted == TRUE ) then
         ! case where matrix is sorted
         do j = 1, j_end
            k_end = ja(j+1) - 1
            if( k_end == ja(j) - 1 ) cycle ! empty column
            if( ia(k_end) <= j ) cycle
            do k = ja(j), k_end
               if( ia(k) > j ) return
            end do
         end do
      else ! not sorted or unknown
         do j = 1, j_end
            do k = ja(j), ja(j+1) - 1
               if( ia(k) > j ) return
            end do
         end do
      end if

      bool = .true.

   end function istriu
