! f90 include file

!_______________________________________________________________________
!
   function istril( nrow, ncol, ia, ja, row_sorted ) result( bool )

      integer, intent(in) :: nrow, ncol, ia(:), ja(:)
      integer, intent(in) :: row_sorted
      logical :: bool
      !------ API end ------

      !-----------------------------------------------------------------
      ! Checks whether the pattern of a sparse matrix is lower triang.
      ! (É. Canot -- IPR/CNRS)
      ! the input matrix doesn't need to be square or row sorted.
      !-----------------------------------------------------------------
      ! On entry:
      !--------------
      ! nrow    = number of rows in matrix
      ! ncol    = number of cols in matrix
      ! ia, ja  = sparsity structure of matrix in CSC format
      ! row_sorted (TRUE, FALSE or UNKNOWN) = indicates whether the
      !           matrix have its row indexes sorted in increasing order
      !
      ! On return:
      !---------------
      ! bool = .true. : indicates that matrix has the requested property
      !-----------------------------------------------------------------

      integer :: n, j, k, k_beg

   !------ end of declarations -- execution starts hereafter  ------

      bool = .false.

      n = min(nrow,ncol)

      ! in each col of this first part, all over-diagonal elements
      ! must be null

      if( row_sorted == TRUE ) then
         ! case where matrix is sorted
         do j = 2, n
            k_beg = ja(j)
            if( ja(j+1) == k_beg ) cycle ! empty column
            if( ia(k_beg) >= j ) cycle
            do k = k_beg, ja(j+1) - 1
               if( ia(k) < j ) return
            end do
         end do
         if( ja(n+1) < ja(ncol+1) ) return
      else ! not sorted or unknown
         do j = 2, n
            do k = ja(j), ja(j+1) - 1
               if( ia(k) < j ) return
            end do
         end do
         if( ja(n+1) < ja(ncol+1) ) return
      end if

      ! this second part, if any, must be empty
      if( ncol > nrow ) then
         if( ja(n) < ja(ncol+1) ) return
      end if

      bool = .true.

   end function istril
