! f90 include file

!_______________________________________________________________________
!
   function isdiag( nrow, ncol, ia, ja ) result( bool )

      integer, intent(in) :: nrow, ncol, ia(:), ja(:)
      logical :: bool
      !------ API end ------

      !-----------------------------------------------------------------
      ! Checks whether the pattern of a sparse matrix is diagonal
      ! (É. Canot -- IPR/CNRS)
      ! the input matrix doesn't need to be square or row sorted.
      !-----------------------------------------------------------------
      ! On entry:
      !--------------
      ! nrow    = number of rows in matrix
      ! ncol    = number of cols in matrix
      ! ia, ja  = sparsity structure of matrix in CSC format
      !
      ! On return:
      !---------------
      ! bool = .true. : indicates that matrix has the requested property
      !-----------------------------------------------------------------

      integer :: nnz, j, k, n

   !------ end of declarations -- execution starts hereafter  ------

      bool = .false.

      n = min(nrow,ncol)

      nnz = ja(ncol+1) - 1
      if( nnz > n ) return

      ! in each col of this first part, we must have at most
      ! one element, located on the diagonal
      do j = 1, n
         k = ja(j)
         if( ja(j+1) == k ) cycle ! empty column
         if( ja(j+1) - 1 > k ) return ! more than one element
         ! found exactly one element in the column
         if( ia(k) /= j ) return
      end do

      ! this second part, if any, must be empty
      if( ncol > nrow ) then
         if( ja(n) < ja(ncol+1) ) return
      end if

      bool = .true.

   end function isdiag
