! f90 include file

!_______________________________________________________________________
!
   subroutine getu_nnz( n, ia, ja, d, nnz )

      integer, intent(in) :: n, ia(:), ja(:), d
      integer :: nnz
      !------ API end ------

      !-----------------------------------------------------------------
      ! finds the nnz of the upper triangular part of a matrix
      ! É. Canot, June 2008
      !-----------------------------------------------------------------
      ! on entry:
      !----------
      ! n = nb of col of the matrix a.
      ! ia, ja = indexes of matrix in CSC format.
      ! d = index of diagonal under of which elements are discarded
      !
      ! on return:
      !-----------
      ! nnz = number of non-zero elements
      !-----------------------------------------------------------------

      integer :: k, j

   !------ end of declarations -- execution starts hereafter  ------

      nnz = 0
      do j = 1, n
         do k = ja(j), ja(j+1) -1
            if( ia(k) <= j-d ) then
               nnz = nnz + 1
            end if
         end do
      end do

   end subroutine getu_nnz
!_______________________________________________________________________
!
   subroutine getu( n, a, ia, ja, d, ao, iao, jao )

      integer, intent(in) :: n, ia(:), ja(:), d
      real(kind=MF_DOUBLE), intent(in) :: a(:)
      integer :: iao(:), jao(:)
      real(kind=MF_DOUBLE) :: ao(:)
      !------ API end ------

      !-----------------------------------------------------------------
      ! extracts the upper triangular part of a matrix
      ! É. Canot, Jan. 2006
      !-----------------------------------------------------------------
      ! on entry:
      !----------
      ! n = nb of col of the matrix a.
      ! a, ia, ja = matrix in CSC format.
      ! d = index of diagonal under of which elements are discarded
      !
      ! on return:
      !-----------
      ! ao, iao, jao = upper triangular matrix (upper part of a)
      !	              stored in CSC format
      !-----------------------------------------------------------------

      integer :: ko, k, j

   !------ end of declarations -- execution starts hereafter  ------

      ko = 0
      jao(1) = 1
      do j = 1, n
         do k = ja(j), ja(j+1) -1
            if( ia(k) <= j-d ) then
               ko = ko + 1
               ao(ko) = a(k)
               iao(ko) = ia(k)
            end if
         end do
         jao(j+1) = ko + 1
      end do

   end subroutine getu
!_______________________________________________________________________
!
   subroutine getu_cmplx( n, a, ia, ja, d, ao, iao, jao )

      integer, intent(in) :: n, ia(:), ja(:), d
      complex(kind=MF_DOUBLE), intent(in) :: a(:)
      integer :: iao(:), jao(:)
      complex(kind=MF_DOUBLE) :: ao(:)
      !------ API end ------

      !-----------------------------------------------------------------
      ! (complex version of 'getu')
      !-----------------------------------------------------------------

      integer :: ko, k, j

   !------ end of declarations -- execution starts hereafter  ------

      ko = 0
      jao(1) = 1
      do j = 1, n
         do k = ja(j), ja(j+1) -1
            if( ia(k) <= j-d ) then
               ko = ko + 1
               ao(ko) = a(k)
               iao(ko) = ia(k)
            end if
         end do
         jao(j+1) = ko + 1
      end do

   end subroutine getu_cmplx
