! f90 include file

!_______________________________________________________________________
!
   function getelm( i, j, a, ia, ja, row_sorted )

      integer, intent(in) :: i, j, ia(:), ja(:)
      real(kind=MF_DOUBLE), intent(in) :: a(:)
      integer, intent(in) :: row_sorted
      real(kind=MF_DOUBLE) :: getelm
      !------ API end ------

      !-----------------------------------------------------------------
      ! purpose:
      ! --------
      ! this function returns the element a(i,j) of a matrix a,
      ! for any pair (i,j).  the matrix is assumed to be stored
      ! in CSC format. getelm performs a binary search in the case
      ! where it is known that the elements are sorted so that the
      ! row indexes are in increasing order.
      !-----
      ! (adapted by É. Canot from SPARSKIT) modified June 29, 2006
      !-----------------------------------------------------------------
      ! parameters:
      ! -----------
      ! on entry:
      !----------
      ! i, j   = the row and column index of the element sought (input)
      ! a, ia, ja = the matrix a in CSC format (input)
      ! row_sorted = TRUE : the matrix is known to have its row indexes
      !                     sorted in increasing order (input)
      ! on return:
      !-----------
      ! getelm = value of a(i,j).
      !
      ! note: the inputs i and j are not checked for validity.
      !-----------------------------------------------------------------

      ! local variables.
      integer :: kbeg, kend, kmid, k, kk

   !------ end of declarations -- execution starts hereafter  ------

      ! initialization
      kk = 0
      getelm = 0.0d0
      kbeg = ja(j)
      kend = ja(j+1)-1
      if( kend < kbeg ) then
         return
      end if

      ! case where matrix is sorted
      if( row_sorted == TRUE ) then

         ! begin binary search.   compute the middle index.
 10      kmid = ( kbeg + kend ) / 2

         ! test if  found
         if( ia(kmid) == i ) then
            kk = kmid
            go to 20
         end if
         if( kbeg >= kend ) go to 20

         ! else update the interval bounds.
         if( ia(kmid) > i ) then
            kend = kmid -1
         else
            kbeg = kmid +1
         end if
         go to 10

      else ! not sorted or unknown

         ! scan the col - exit as soon as a(i,j) is found
         do k = kbeg, kend
            if( ia(k) == i ) then
               kk = k
               go to 20
            end if
         end do

      end if

 20   if( kk /= 0 ) getelm = a(kk)

   end function getelm
!_______________________________________________________________________
!
   function getelm_cmplx( i, j, a, ia, ja, row_sorted )

      integer, intent(in) :: i, j, ia(:), ja(:)
      complex(kind=MF_DOUBLE), intent(in) :: a(:)
      integer, intent(in) :: row_sorted
      complex(kind=MF_DOUBLE) :: getelm_cmplx
      !------ API end ------

      !-----------------------------------------------------------------
      ! complex version of 'getelm'
      !-----------------------------------------------------------------

      ! local variables.
      integer :: kbeg, kend, kmid, k, kk

   !------ end of declarations -- execution starts hereafter  ------

      ! initialization
      kk = 0
      getelm_cmplx = (0.0d0,0.0d0)
      kbeg = ja(j)
      kend = ja(j+1)-1

      ! case where matrix is sorted
      if( row_sorted == TRUE ) then

         ! begin binary search.   compute the middle index.
 10      kmid = ( kbeg + kend ) / 2

         ! test if  found
         if( ia(kmid) == i ) then
            kk = kmid
            go to 20
         end if
         if( kbeg >= kend ) go to 20

         ! else update the interval bounds.
         if( ia(kmid) > i ) then
            kend = kmid -1
         else
            kbeg = kmid +1
         end if
         go to 10

      else ! sorted case

         ! scan the col - exit as soon as a(i,j) is found
         do k = kbeg, kend
            if( ia(k) == i ) then
               kk = k
               go to 20
            end if
         end do

      end if

 20   if( kk /= 0 ) getelm_cmplx = a(kk)

   end function getelm_cmplx
