! f90 include file

!_______________________________________________________________________
!
   subroutine getdia( nrow, ncol, a, ia, ja, diag, joff )

      integer, intent(in) :: nrow, ncol, joff, ia(:), ja(:)
      real(kind=MF_DOUBLE), intent(in) :: a(:)
      real(kind=MF_DOUBLE), intent(out) :: diag(:)
      !------ API end ------

      !-----------------------------------------------------------------
      ! this subroutine extracts a given diagonal from a matrix stored
      ! in CSC format.
      ! (adapted from 'getdia' od SPARSKIT2)
      !-----------------------------------------------------------------
      ! on entry:
      !----------
      !
      ! nrow	= integer. the row dimension of the matrix a.
      ! ncol	= integer. the column dimension of the matrix a.
      !
      ! a, ia, ja = matrix stored in CSC format
      ! joff  = integer, containing the offset of the wanted diagonal
      !	  the diagonal extracted is the one corresponding to the
      !	  entries a(i,j) with j-i = joff.
      !	  thus joff = 0 means the main diagonal
      !
      ! on return:
      !-----------
      !
      ! diag  = real*8 array containing the wanted diagonal.
      !         length: min(nrow,ncol+joff) - max(0,joff)
      !-----------------------------------------------------------------

      ! local variables
      integer :: jstart, jend, j, k

   !------ end of declarations -- execution starts hereafter  ------

      jstart = max(0,joff)
      jend = min(nrow,ncol+joff)
      do j = 1, jend-jstart
         diag(j) = 0.0d0
      end do

      ! extract  diagonal elements
      do j = jstart+1, jend
         do k = ja(j), ja(j+1)-1
            if( j-ia(k) == joff ) then
               diag(j-jstart) = a(k)
               cycle
            end if
         end do
      end do

   end subroutine getdia
!_______________________________________________________________________
!
   subroutine getdia_cmplx( nrow, ncol, a, ia, ja, diag, joff )

      complex(kind=MF_DOUBLE) :: diag(:), a(:)
      integer :: nrow, ncol, joff, ia(:), ja(:)
      !------ API end ------

      !-----------------------------------------------------------------
      ! complex version of 'getdia'
      !-----------------------------------------------------------------

      ! local variables
      integer :: jstart, jend, j, k

   !------ end of declarations -- execution starts hereafter  ------

      jstart = max(0,joff)
      jend = min(nrow,ncol+joff)
      do j = 1, jend-jstart
         diag(j) = (0.0d0,0.0d0)
      end do

      ! extract  diagonal elements
      do j = jstart+1, jend
         do k = ja(j), ja(j+1)-1
            if( j-ia(k) == joff ) then
               diag(j-jstart) = a(k)
               cycle
            end if
         end do
      end do

   end subroutine getdia_cmplx
