! f90 include file

!_______________________________________________________________________
!
   subroutine dns2csc( nrow, ncol, dns, a, ia, ja )

      integer,              intent(in)  :: nrow, ncol
      real(kind=MF_DOUBLE), intent(in)  :: dns(:,:)
      real(kind=MF_DOUBLE), intent(out) :: A(:)
      integer,              intent(out) :: ia(:), ja(:)
      !------ API end ------

      !-----------------------------------------------------------------
      ! Dense     to    Compressed Sparse Column
      ! (adapted from SPARSKIT2 (Mar 8 2005) 'dnscsr' by É. Canot)
      !-----------------------------------------------------------------
      ! converts a densely stored matrix into a CSC matrix.
      ! Note: this routine does not check whether an element
      ! is small. It considers that a(i,j) is zero if it is exactly
      ! equal to zero.
      ! No check for size of a and ia !
      ! Of course, the returned matrix is 'row sorted'.
      !-----------------------------------------------------------------
      ! on entry:
      !---------
      ! nrow  = row-dimension of a
      ! ncol  = column dimension of a
      ! dns    = input nrow x ncol (dense) real matrix.
      !
      ! on return:
      !----------
      ! a, ia, ja = value, row, pointer arrays for output matrix
      !-----------------------------------------------------------------

      integer :: i, j, next

   !------ end of declarations -- execution starts hereafter  ------

      next = 1
      ja(1) = 1
      do j = 1, ncol
         do i = 1, nrow
            if( dns(i,j) == 0.0d0 ) cycle
            ia(next) = i
            a(next) = dns(i,j)
            next = next + 1
         end do
         ja(j+1) = next
      end do

   end subroutine dns2csc
!_______________________________________________________________________
!
   subroutine dns2csc_cmplx( nrow, ncol, dns, a, ia, ja )

      integer,                 intent(in)  :: nrow, ncol
      complex(kind=MF_DOUBLE), intent(in)  :: dns(:,:)
      complex(kind=MF_DOUBLE), intent(out) :: A(:)
      integer,                 intent(out) :: ia(:), ja(:)
      !------ API end ------

      !-----------------------------------------------------------------
      ! complex version of 'dns2csc'
      !-----------------------------------------------------------------

      integer :: i, j, next

   !------ end of declarations -- execution starts hereafter  ------

      next = 1
      ja(1) = 1
      do j = 1, ncol
         do i = 1, nrow
            if( dns(i,j) == (0.0d0,0.0d0) ) cycle
            ia(next) = i
            a(next) = dns(i,j)
            next = next + 1
         end do
         ja(j+1) = next
      end do

   end subroutine dns2csc_cmplx
