! f90 include file

!_______________________________________________________________________
!
   subroutine coo2csc_struct_only( ncol, nnz, ir, jc, iao, jao )

      integer, intent(in)  :: ncol, nnz
      integer, intent(in)  :: ir(:), jc(:)
      integer, intent(out) :: iao(:), jao(:)
      !------ API end ------

      !-----------------------------------------------------------------
      !  Coordinate to Compressed Sparse Column : structure only
      ! (written by É. Canot)
      !-----------------------------------------------------------------
      ! converts partial coordinate format into
      ! a CSC format. No check for size of iao!
      !-----------------------------------------------------------------
      ! on entry:
      !---------
      ! ncol = dimension of the matrix
      ! nnz  = number of nonzero elements in matrix
      ! ir,
      ! jc   = matrix structure in coordinate format.
      !        ir(k), jc(k) store the
      !        nnz nonzero elements of the matrix with :
      !          ir(k) = its row number,
      !          jc(k) = its column  number.
      !        The order of the elements is arbitrary.
      !
      ! on return:
      !-----------
      ! iao, jao = matrix in general sparse matrix format with iao
      ! containing the row indexes,
      ! and jao being the pointer to the beginning of the column,
      ! in array iao.
      ! The resulting matrix is not necessarily row sorted; it depends
      ! of the order of the entries!
      !-----------------------------------------------------------------

      integer :: j, jad, k0, k

   !------ end of declarations -- execution starts hereafter  ------

      do k = 1, ncol+1
         jao(k) = 0
      end do
      ! determine col-lengths.
      do k = 1, nnz
         jao(jc(k)) = jao(jc(k)) + 1
      end do
      ! starting position of each col.
      k = 1
      do j = 1, ncol+1
         k0 = jao(j)
         jao(j) = k
         k = k + k0
      end do
      ! go through the structure once more. Fill in output matrix.
      do k = 1, nnz
         j = jc(k)
         jad = jao(j)
         iao(jad) = ir(k)
         jao(j) = jad + 1
      end do
      ! shift back jao
      do j = ncol, 1, -1
         jao(j+1) = jao(j)
      end do
      jao(1) = 1

   end subroutine coo2csc_struct_only
