! f90 include file

!_______________________________________________________________________
!
   subroutine colscale( ncol, a, ia, ja, ao, iao, jao, scal )

      integer,              intent(in)  :: ncol, ia(:), ja(:)
      real(kind=MF_DOUBLE), intent(in)  :: a(:), scal(:)
      integer,              intent(out) :: iao(:), jao(:)
      real(kind=MF_DOUBLE), intent(out) :: ao(:)
      !-----------------------------------------------------------------
      ! this subroutine applies a scaling to the columns of a matrix
      ! in CSC format.
      ! colscale  computes A*S  where S is a diagonal matrix.
      ! the scaling S is actually defined through the array 'scale':
      ! elements in column j of A are multiplied by scale(j).
      ! -- Édouard Canot -- Feb. 2012
      !-----------------------------------------------------------------
      ! on entry:
      !----------
      ! ncol  = nb of columns of the matrix
      ! a, ia, ja = input matrix in CSC format
      ! scale = real array of length ncol containing the scaling for
      !         each column.
      !
      !------------
      ! on return:
      !------------
      ! ao, iao, jao = output matrix in CSC format
      !-----------------------------------------------------------------

      integer :: j, k, nnz

   !------ end of declarations -- execution starts hereafter  ------

      nnz = ja(ncol+1) - 1
      iao(1:nnz)    = ia(1:nnz)
      jao(1:ncol+1) = ja(1:ncol+1)

      do j = 1, ncol
         do k = ja(j), ja(j+1) - 1
            ao(k) = a(k)*scal(j)
         end do
      end do

   end subroutine colscale
!_______________________________________________________________________
!
   subroutine colscale2( ncol, a, ia, ja, scal )

      integer,              intent(in)     :: ncol
      real(kind=MF_DOUBLE), intent(in)     :: scal(:)
      integer,              intent(in out) :: ia(:), ja(:)
      real(kind=MF_DOUBLE), intent(in out) :: a(:)
      !-----------------------------------------------------------------
      ! this subroutine applies an 'in-place' scaling to the columns of
      ! a matrix in CSC format.
      ! colscale  computes A*S  where S is a diagonal matrix.
      ! the scaling S is actually defined through the array 'scale':
      ! elements in column j of A are multiplied by scale(j).
      ! -- Édouard Canot -- Feb. 2012
      !-----------------------------------------------------------------
      ! on entry:
      !----------
      ! ncol  = nb of columns of the matrix
      ! a, ia, ja = input matrix in CSC format
      ! scale = real array of length ncol containing the scaling for
      !         each column.
      !
      !------------
      ! on return:
      !------------
      ! a, ia, ja = output matrix in CSC format
      !-----------------------------------------------------------------

      integer :: j, k

   !------ end of declarations -- execution starts hereafter  ------

      do j = 1, ncol
         do k = ja(j), ja(j+1) - 1
            a(k) = a(k)*scal(j)
         end do
      end do

   end subroutine colscale2
!_______________________________________________________________________
!
   subroutine colscale_cmplx( ncol, a, ia, ja, ao, iao, jao, scal )

      integer,                 intent(in)  :: ncol, ia(:), ja(:)
      complex(kind=MF_DOUBLE), intent(in)  :: a(:)
      real(kind=MF_DOUBLE),    intent(in)  :: scal(:)
      integer,                 intent(out) :: iao(:), jao(:)
      complex(kind=MF_DOUBLE), intent(out) :: ao(:)
      !-----------------------------------------------------------------
      ! complex version of 'colscale'
      !-----------------------------------------------------------------

      integer :: j, k, nnz

   !------ end of declarations -- execution starts hereafter  ------

      nnz = ja(ncol+1) - 1
      iao(1:nnz)    = ia(1:nnz)
      jao(1:ncol+1) = ja(1:ncol+1)

      do j = 1, ncol
         do k = ja(j), ja(j+1) - 1
            ao(k) = a(k)*scal(j)
         end do
      end do

   end subroutine colscale_cmplx
!_______________________________________________________________________
!
   subroutine colscale2_cmplx( ncol, a, ia, ja, scal )

      integer,                 intent(in)     :: ncol
      real(kind=MF_DOUBLE),    intent(in)     :: scal(:)
      integer,                 intent(in out) :: ia(:), ja(:)
      complex(kind=MF_DOUBLE), intent(in out) :: a(:)
      !-----------------------------------------------------------------
      ! complex version of 'colscale2'
      !-----------------------------------------------------------------

      integer :: j, k

   !------ end of declarations -- execution starts hereafter  ------

      do j = 1, ncol
         do k = ja(j), ja(j+1) - 1
            a(k) = a(k)*scal(j)
         end do
      end do

   end subroutine colscale2_cmplx

