! f90 include file

!_______________________________________________________________________
!
   subroutine colconcat_ip( ncola, a, ia, ja, ncolb, b, ib, jb )

      integer, intent(in out) :: ncola, ia(:), ja(:)
      integer, intent(in) :: ncolb, ib(:), jb(:)
      real(kind=MF_DOUBLE), intent(in out) :: a(:)
      real(kind=MF_DOUBLE), intent(in) :: b(:)
      !------ API end ------

      !-----------------------------------------------------------------
      ! horizontal concat of A and B
      ! version 'in place' : result in store in A
      ! É. Canot, Sept. 2005
      !-----------------------------------------------------------------
      ! A and B must have the same number of rows.
      ! arrays describing A must have sufficient room to include A and B
      !-----------------------------------------------------------------

      integer :: k, j, nnza, nnzb

   !------ end of declarations -- execution starts hereafter  ------

      ! extending A with B values
      nnza = ja(ncola+1)-1
      do j = 2, ncolb+1
         ja(ncola+j) = jb(j) + nnza
      end do
      nnzb = jb(ncolb+1)-1
      do k = 1, nnzb
         ia(nnza+k) = ib(k)
         a(nnza+k) = b(k)
      end do

      ncola = ncola + ncolb

   end subroutine colconcat_ip
!_______________________________________________________________________
!
   subroutine colconcat_ip_cmplx( ncola, a, ia, ja, ncolb, b, ib, jb )

      integer, intent(in out) :: ncola, ia(:), ja(:)
      integer, intent(in) :: ncolb, ib(:), jb(:)
      complex(kind=MF_DOUBLE), intent(in out) :: a(:)
      complex(kind=MF_DOUBLE), intent(in) :: b(:)
      !------ API end ------

      !-----------------------------------------------------------------
      ! version complexe de 'colconcat_ip'
      !-----------------------------------------------------------------

      integer :: k, j, nnza, nnzb

   !------ end of declarations -- execution starts hereafter  ------

      ! extending A with B values
      nnza = ja(ncola+1)-1
      do j = 2, ncolb+1
         ja(ncola+j) = jb(j) + nnza
      end do
      nnzb = jb(ncolb+1)-1
      do k = 1, nnzb
         ia(nnza+k) = ib(k)
         a(nnza+k) = b(k)
      end do

      ncola = ncola + ncolb

   end subroutine colconcat_ip_cmplx
