! f90 include file

!_______________________________________________________________________
!
   subroutine colconcat( ncola, a, ia, ja, ncolb, b, ib, jb,            &
                         c, ic, jc )

      integer, intent(in) :: ncola, ncolb, ia(:), ja(:), ib(:), jb(:)
      real(kind=MF_DOUBLE), intent(in) :: a(:), b(:)
      integer :: ic(:), jc(:)
      real(kind=MF_DOUBLE) :: c(:)
      !------ API end ------

      !-----------------------------------------------------------------
      ! horizontal concat of A and B
      ! É. Canot, Sept. 2005
      !-----------------------------------------------------------------
      ! A and B must have the same number of rows.
      ! arrays describing C must have sufficient room to include A and B
      !-----------------------------------------------------------------

      integer :: k, j, nnza, nnzb

   !------ end of declarations -- execution starts hereafter  ------

      ! first copy A into C
      do j = 1, ncola+1
         jc(j) = ja(j)
      end do
      nnza = ja(ncola+1)-1
      do k = 1, nnza
         ic(k) = ia(k)
         c(k) = a(k)
      end do

      ! extending C with B values
      do j = 2, ncolb+1
         jc(ncola+j) = jb(j) + nnza
      end do
      nnzb = jb(ncolb+1)-1
      do k = 1, nnzb
         ic(nnza+k) = ib(k)
         c(nnza+k) = b(k)
      end do

   end subroutine colconcat
!_______________________________________________________________________
!
   subroutine colconcat_real_cmplx( ncola, a, ia, ja, ncolb, b, ib, jb, &
                                    c, ic, jc )

      integer, intent(in) :: ncola, ncolb, ia(:), ja(:), ib(:), jb(:)
      real(kind=MF_DOUBLE), intent(in) :: a(:)
      complex(kind=MF_DOUBLE), intent(in) :: b(:)
      integer :: ic(:), jc(:)
      complex(kind=MF_DOUBLE) :: c(:)
      !------ API end ------

      !-----------------------------------------------------------------
      ! complex version of 'colconcat'
      !-----------------------------------------------------------------

      integer :: k, j, nnza, nnzb

   !------ end of declarations -- execution starts hereafter  ------

      ! first copy A into C
      do j = 1, ncola+1
         jc(j) = ja(j)
      end do
      nnza = ja(ncola+1)-1
      do k = 1, nnza
         ic(k) = ia(k)
         c(k) = a(k)
      end do

      ! extending C with B values
      do j = 2, ncolb+1
         jc(ncola+j) = jb(j) + nnza
      end do
      nnzb = jb(ncolb+1)-1
      do k = 1, nnzb
         ic(nnza+k) = ib(k)
         c(nnza+k) = b(k)
      end do

   end subroutine colconcat_real_cmplx
!_______________________________________________________________________
!
   subroutine colconcat_cmplx_real( ncola, a, ia, ja, ncolb, b, ib, jb, &
                                    c, ic, jc )

      integer, intent(in) :: ncola, ncolb, ia(:), ja(:), ib(:), jb(:)
      complex(kind=MF_DOUBLE), intent(in) :: a(:)
      real(kind=MF_DOUBLE), intent(in) :: b(:)
      integer :: ic(:), jc(:)
      complex(kind=MF_DOUBLE) :: c(:)
      !------ API end ------

      !-----------------------------------------------------------------
      ! complex version of 'colconcat'
      !-----------------------------------------------------------------

      integer :: k, j, nnza, nnzb

   !------ end of declarations -- execution starts hereafter  ------

      ! first copy A into C
      do j = 1, ncola+1
         jc(j) = ja(j)
      end do
      nnza = ja(ncola+1)-1
      do k = 1, nnza
         ic(k) = ia(k)
         c(k) = a(k)
      end do

      ! extending C with B values
      do j = 2, ncolb+1
         jc(ncola+j) = jb(j) + nnza
      end do
      nnzb = jb(ncolb+1)-1
      do k = 1, nnzb
         ic(nnza+k) = ib(k)
         c(nnza+k) = b(k)
      end do

   end subroutine colconcat_cmplx_real
!_______________________________________________________________________
!
   subroutine colconcat_cmplx_cmplx( ncola, a, ia, ja, ncolb, b, ib, jb,&
                                     c, ic, jc )

      integer, intent(in) :: ncola, ncolb, ia(:), ja(:), ib(:), jb(:)
      complex(kind=MF_DOUBLE), intent(in) :: a(:), b(:)
      integer :: ic(:), jc(:)
      complex(kind=MF_DOUBLE) :: c(:)
      !------ API end ------

      !-----------------------------------------------------------------
      ! complex version of 'colconcat'
      !-----------------------------------------------------------------

      integer :: k, j, nnza, nnzb

   !------ end of declarations -- execution starts hereafter  ------

      ! first copy A into C
      do j = 1, ncola+1
         jc(j) = ja(j)
      end do
      nnza = ja(ncola+1)-1
      do k = 1, nnza
         ic(k) = ia(k)
         c(k) = a(k)
      end do

      ! extending C with B values
      do j = 2, ncolb+1
         jc(ncola+j) = jb(j) + nnza
      end do
      nnzb = jb(ncolb+1)-1
      do k = 1, nnzb
         ic(nnza+k) = ib(k)
         c(nnza+k) = b(k)
      end do

   end subroutine colconcat_cmplx_cmplx
