! f90 include file

!_______________________________________________________________________
!
   subroutine col_auto_scale( ncol, a, ia, ja, ao, iao, jao, scal )

      integer,              intent(in)  :: ncol, ia(:), ja(:)
      real(kind=MF_DOUBLE), intent(in)  :: a(:)
      integer,              intent(out) :: iao(:), jao(:)
      real(kind=MF_DOUBLE), intent(out) :: ao(:), scal(:)
      !-----------------------------------------------------------------
      ! This subroutine applies a scaling to the columns of a matrix
      ! in CSC format, such that the max. element in absolute value
      ! in each column is equal to 1.
      ! The scaling factors are output in the vector 'scal'.
      ! -- Édouard Canot -- Mar. 2025
      !-----------------------------------------------------------------
      ! on entry:
      !----------
      ! ncol  = nb of columns of the matrix
      ! a, ia, ja = input matrix in CSC format
      !
      !------------
      ! on return:
      !------------
      ! ao, iao, jao = output scaled matrix in CSC format
      ! scale = real array of length ncol containing the scaling for
      !         each column which have been applied.
      !-----------------------------------------------------------------

      integer :: j, k1, k2, nnz
      real(kind=MF_DOUBLE) :: max_val

   !------ end of declarations -- execution starts hereafter  ------

      nnz = ja(ncol+1) - 1
      iao(1:nnz)    = ia(1:nnz)
      jao(1:ncol+1) = ja(1:ncol+1)

      do j = 1, ncol
         k1 = ja(j)
         k2 = ja(j+1) - 1
         max_val = maxval( abs( a(k1:k2) ) )
         scal(j) = 1.0d0/max_val
         ao(k1:k2) = a(k1:k2)*scal(j)
      end do

   end subroutine col_auto_scale
!_______________________________________________________________________
!
   subroutine col_auto_scale2( ncol, a, ia, ja, scal )

      integer,              intent(in)     :: ncol
      integer,              intent(in out) :: ia(:), ja(:)
      real(kind=MF_DOUBLE), intent(in out) :: a(:)
      real(kind=MF_DOUBLE), intent(out)    :: scal(:)
      !-----------------------------------------------------------------
      ! This subroutine applies an 'in-place' scaling to the columns of
      ! a matrix in CSC format, such that the max. element in absolute
      ! value in each column is equal to 1.
      ! The scaling factors are output in the vector 'scal'.
      ! -- Édouard Canot -- Mar. 2025
      !-----------------------------------------------------------------
      ! on entry:
      !----------
      ! ncol  = nb of columns of the matrix
      ! a, ia, ja = input matrix in CSC format
      !
      !------------
      ! on return:
      !------------
      ! a, ia, ja = scaled matrix in CSC format
      ! scale = real array of length ncol containing the scaling for
      !         each column which have been applied.
      !-----------------------------------------------------------------

      integer :: j, k1, k2
      real(kind=MF_DOUBLE) :: max_val

   !------ end of declarations -- execution starts hereafter  ------

      do j = 1, ncol
         k1 = ja(j)
         k2 = ja(j+1) - 1
         max_val = maxval( abs( a(k1:k2) ) )
         scal(j) = 1.0d0/max_val
         a(k1:k2) = a(k1:k2)*scal(j)
      end do

   end subroutine col_auto_scale2
