! f90 include file

!_______________________________________________________________________
!
   subroutine chgcol( ncol, a, ia, ja, jpos, v, iv, nv )

      integer, intent(in) :: ncol, jpos, iv(:)
      real(kind=MF_DOUBLE), intent(in) :: v(:)
      integer, optional, intent(in) :: nv
      integer :: ia(:), ja(:)
      real(kind=MF_DOUBLE) :: a(:)
      !------ API end ------

      !-----------------------------------------------------------------
      ! updates the 'jpos' column of the matrix A
      ! (É. Canot, sept. 2005)
      !-----------------------------------------------------------------

      integer :: k, kk, shift, nzv, nzv_old

   !------ end of declarations -- execution starts hereafter  ------

      ! compute shift (neg. or pos. value)
      if( present(nv) ) then
         nzv = nv
      else
         nzv = size(v)
      end if
      nzv_old = ja(jpos+1) - ja(jpos)
      shift = nzv - nzv_old

      if( shift > 0 ) then
         ! effective length of ia(:) and a(:) is going to increase
         do k = ja(ncol+1)-1, ja(jpos+1), -1
            ia(k+shift) = ia(k)
            a(k+shift) = a(k)
         end do
         do k = jpos+1, ncol+1
            ja(k) = ja(k) + shift
         end do
      else if( shift < 0 ) then
         ! effective length of ia(:) and a(:) is going to decrease
         do k = ja(jpos+1), ja(ncol+1)-1
            ia(k+shift) = ia(k)
            a(k+shift) = a(k)
         end do
         do k = jpos+1, ncol+1
            ja(k) = ja(k) + shift
         end do
      end if

      do kk = 1, nzv
         k = ja(jpos) + kk - 1
         ia(k) = iv(kk)
         a(k) = v(kk)
      end do

   end subroutine chgcol
!_______________________________________________________________________
!
   subroutine chgcol_cmplx( ncol, a, ia, ja, jpos, v, iv, nv )

      integer, intent(in) :: ncol, jpos, iv(:)
      complex(kind=MF_DOUBLE), intent(in) :: v(:)
      integer, optional, intent(in) :: nv
      integer :: ia(:), ja(:)
      complex(kind=MF_DOUBLE) :: a(:)
      !------ API end ------

      !-----------------------------------------------------------------
      ! version complexe de chgcol
      !-----------------------------------------------------------------

      integer :: k, kk, shift, nzv, nzv_old

   !------ end of declarations -- execution starts hereafter  ------

      ! compute shift (neg. or pos. value)
      if( present(nv) ) then
         nzv = nv
      else
         nzv = size(v)
      end if
      nzv_old = ja(jpos+1) - ja(jpos)
      shift = nzv - nzv_old

      if( shift > 0 ) then
         ! effective length of ia(:) and a(:) is going to increase
         do k = ja(ncol+1)-1, ja(jpos+1), -1
            ia(k+shift) = ia(k)
            a(k+shift) = a(k)
         end do
         do k = jpos+1, ncol+1
            ja(k) = ja(k) + shift
         end do
      else if( shift < 0 ) then
         ! effective length of ia(:) and a(:) is going to decrease
         do k = ja(jpos+1), ja(ncol+1)-1
            ia(k+shift) = ia(k)
            a(k+shift) = a(k)
         end do
         do k = jpos+1, ncol+1
            ja(k) = ja(k) + shift
         end do
      end if

      do kk = 1, nzv
         k = ja(jpos) + kk - 1
         ia(k) = iv(kk)
         a(k) = v(kk)
      end do

   end subroutine chgcol_cmplx
!_______________________________________________________________________
!
   subroutine chgcol_cmplx_r8( ncol, a, ia, ja, jpos, v, iv, nv )

      integer, intent(in) :: ncol, jpos, iv(:)
      real(kind=MF_DOUBLE), intent(in) :: v(:)
      integer, optional, intent(in) :: nv
      integer :: ia(:), ja(:)
      complex(kind=MF_DOUBLE) :: a(:)
      !------ API end ------

      !-----------------------------------------------------------------
      ! version complexe de chgcol
      !-----------------------------------------------------------------

      integer :: k, kk, shift, nzv, nzv_old

   !------ end of declarations -- execution starts hereafter  ------

      ! compute shift (neg. or pos. value)
      if( present(nv) ) then
         nzv = nv
      else
         nzv = size(v)
      end if
      nzv_old = ja(jpos+1) - ja(jpos)
      shift = nzv - nzv_old

      if( shift > 0 ) then
         ! effective length of ia(:) and a(:) is going to increase
         do k = ja(ncol+1)-1, ja(jpos+1), -1
            ia(k+shift) = ia(k)
            a(k+shift) = a(k)
         end do
         do k = jpos+1, ncol+1
            ja(k) = ja(k) + shift
         end do
      else if( shift < 0 ) then
         ! effective length of ia(:) and a(:) is going to decrease
         do k = ja(jpos+1), ja(ncol+1)-1
            ia(k+shift) = ia(k)
            a(k+shift) = a(k)
         end do
         do k = jpos+1, ncol+1
            ja(k) = ja(k) + shift
         end do
      end if

      do kk = 1, nzv
         k = ja(jpos) + kk - 1
         ia(k) = iv(kk)
         a(k) = v(kk)
      end do

   end subroutine chgcol_cmplx_r8
