! f90 include file

!_______________________________________________________________________
!
   subroutine atmub( ncol, ncolb, a, ia, ja, b, ib, jb,           &
                     c, ic, jc, nzmax, jerr )

      integer,              intent(in) :: ncol, ncolb, nzmax
      real(kind=MF_DOUBLE), intent(in) :: a(:), b(:)
      integer,              intent(in) :: ia(:), ja(:), ib(:), jb(:)
      real(kind=MF_DOUBLE)             :: c(:)
      integer                          :: ic(:), jc(:), jerr
      !------ API end ------

      !-----------------------------------------------------------------
      ! performs the matrix by matrix product C = A'*B
      ! É. Canot -- 24 feb 2012
      !-----------------------------------------------------------------
      ! on entry:
      ! ---------
      ! ncol = column dimension of A.
      ! ncolb = column dimension of B.
      !
      ! a, ia, ja = Matrix A in CSC format (must be row sorted).
      !
      ! b, ib, jb = Matrix B in CSC format (must be row sorted).
      !
      ! nzmax = integer. The length of the arrays c and jc.
      !         atmub will stop if the result matrix C has a number
      !         of elements that exceeds nzmax. See jerr.
      !
      ! on return:
      !----------
      ! c, ic, jc = resulting matrix C in CSC sparse format.
      !
      ! jerr  = integer. serving as error message.
      !         jerr = 0 means normal return,
      !         jerr > 0 means that amub stopped while computing the
      !                  j-th col of C with j=jerr, because the number
      !                  of elements in C exceeds nzmax.
      !
      ! note: returned matrix automatically row sorted !
      !-----------------------------------------------------------------

      integer :: nnz, j, jj, ka, kb, ka_end
      real(kind=MF_DOUBLE) :: tmp

   !------ end of declarations -- execution starts hereafter  ------

!### TODO 2:
!###############################################################
!###############################################################
! Warning, algo cost is in O(N^2), whereas that of 'amub' is in O(N) !
! (however, the current routine is not used...)
!###############################################################
!###############################################################

      nnz = 0
      jc(1) = 1
      jerr = 0

      ! builds column vectors of C
      do j = 1, ncolb
         do jj = 1, ncol
            tmp = 0.0d0
            ! dot product of the two (sparse) vectors
            ka = ja(jj)
            ka_end = ja(jj+1) - 1
            if( ka_end < ka ) then
               ! empty column of A: no need to compute the dot product
               cycle
            end if
            do kb = jb(j), jb(j+1)-1
               ! looking for ia(ka) = ib(kb)
               if( ia(ka) < ib(kb) ) then
                  if( ka == ka_end ) then ! end of dot product
                     exit
                  end if
                  ! increase ka
                  do
                     if( ka == ka_end ) then
                        exit
                     end if
                     ka = ka + 1
                     if( ia(ka) >= ib(kb) ) exit
                  end do
               end if
               if( ia(ka) == ib(kb) ) then
                  tmp = tmp + a(ka)*b(kb)
               end if
            end do
            ! store only non zero elements
            if( tmp /= 0.0d0 ) then
               nnz = nnz + 1
               if( nnz > nzmax ) then
                  jerr = j
                  return
               end if
               ic(nnz) = jj
               c(nnz) = tmp
            end if
         end do
         ! end of col., we can update pointer to col.
         jc(j+1) = nnz + 1
      end do

   end subroutine atmub
