! f90 include file

!_______________________________________________________________________
!
   subroutine apply_bin_ops_to_sp_dble( nrow, ncol, a, ia, ja,          &
                                        ops, val, c, ic, jc )
      real(kind=MF_DOUBLE), intent(in)  :: a(:), val
      integer,              intent(in)  :: ia(:), ja(:), nrow, ncol
      character(len=*),     intent(in)  :: ops
      real(kind=MF_DOUBLE), pointer     :: c(:)
      integer,              pointer     :: ic(:), jc(:)
      !------ API end ------

      integer :: i, j, k, kk, nnz, nnz_A, ia_expected
      logical :: bool, bool_zero

#ifndef _OPTIM
      ! in DEBUG mode only: check that columns are sorted
      integer :: ia_old
#endif

      !-----------------------------------------------------------------
      ! purpose:
      ! --------
      ! Apply a binary logical operation to a real, sparse matrix A
      ! which must be row-sorted.
      !-----
      ! (written by É. Canot) December 2, 2023
      !-----------------------------------------------------------------
      ! parameters:
      ! -----------
      ! on entry:
      !----------
      ! a, ia, ja = a sparse matrix A in CSC format (input)
      ! ops = a string which specify what logical binary operation has to
      !       be applied to each element of the matrix.
      !       (e.g. ".eq.", ".gt.", ... see below the list)
      ! val = the real value to be compared.
      ! nrow, ncol = the number of rows and columns of A
      !
      ! on exit:
      !---------
      ! c, ic, jc = the element of the resulting sparse boolean matrix
      !             (1=TRUE, 0=FALSE) in CSC format.
      !             Memory is allocated for these data.
      !             [The CSC structure is not row-sorted]
      !-----------------------------------------------------------------

      if( associated(c) ) then
         print *, "apply_bin_ops_to_sp_dble: internal error"
         print *, "  -> array 'c' must be unallocated!"
         pause "for debugging purpose only..."
         stop
      end if

      if( associated(ic) ) then
         print *, "apply_bin_ops_to_sp_dble: internal error"
         print *, "  -> array 'c' must be unallocated!"
         pause "for debugging purpose only..."
         stop
      end if

      if( associated(jc) ) then
         print *, "apply_bin_ops_to_sp_dble: internal error"
         print *, "  -> array 'c' must be unallocated!"
         pause "for debugging purpose only..."
         stop
      end if

      ! >>>>>>>>>>>>>>>  Implemented operations  <<<<<<<<<<<<<<<
      select case( ops )
         case( ".eq." )
         case( ".gt." )
         case( ".ge." )
         case( ".lt." )
         case( ".le." )
         case default
            print *, "apply_bin_ops_to_sp_dble: internal error"
            print *, "  -> unknown logical operation: ", trim(ops)
            pause "for debugging purpose only..."
            stop
      end select

      ! Count the number of non-zero elements in the output matrix
      ! (i.e. TRUE values)
      nnz = 0
      ! first examine non-zero elements
      nnz_A = ja(ncol+1) - 1
!!print "(A,I0)", "current nnz = ", nnz_A
      do k = 1, nnz_A
         bool = x_ops_y( a(k), ops, val )
         if( bool ) nnz = nnz + 1
      end do
!!print "(A,I0)", "among non-zero elements, found nnz = ", nnz
      ! then examine the special case of zero
      bool_zero = x_ops_y( 0.0d0, ops, val )
      if( bool_zero ) nnz = nnz + ( nrow*ncol - nnz_A )
!!print "(A,I0)", "expected nnz in apply_bin_ops_to_sp_dble (line 90): ", nnz

      ! Build the output sparse matrix, by columns...
      allocate( jc(ncol+1), ic(nnz), c(nnz) )
!!jc(:) = -1 ; ic(:) = -1 ; c(:) = 1.1111111d11
      kk = 0
      jc(1) = 1
      if( bool_zero ) then

         do j = 1, ncol
!!print "(A,I0)", "col j = ", j
            ia_expected = 1
#ifndef _OPTIM
            ia_old = 0
#endif
            do k = ja(j), ja(j+1) - 1
#ifndef _OPTIM
               if( ia(k) < ia_old ) then
                  print *, "[DBG Muesli:] apply_bin_ops_to_sp_dble: line 115"
                  print *, "              -> internal error."
                  print *, "              matrix A must be row-sorted!"
                  pause "for debugging purpose only..."
                  stop
               else
                  ia_old = ia(k)
               end if
#endif
               if( ia(k) /= ia_expected ) then
                  do i = ia_expected, ia(k)-1
                     kk = kk + 1
                     c(kk) = 1.0d0 ! TRUE
!!print "(A,I0,A)", "   inserting ghost element kk = ", kk, " with TRUE value."
                     ic(kk) = i
                  end do
               end if
               bool = x_ops_y( a(k), ops, val )
               if( bool ) then
                  kk = kk + 1
                  c(kk) = 1.0d0 ! TRUE
!!print "(A,I0,A)", "   inserting pres element kk = ", kk, " with TRUE value."
                  ic(kk) = ia(k)
               end if
               ia_expected = ia(k) + 1
            end do
!!print *, "   end of col: ia_expected = ", ia_expected
            if( ia_expected <= nrow ) then
               do i = ia_expected, nrow
                  kk = kk + 1
                  c(kk) = 1.0d0 ! TRUE
!!print "(A,I0,A)", "   inserting ghost element kk = ", kk, " with TRUE value."
                  ic(kk) = i
               end do
            end if
            jc(j+1) = kk + 1
         end do

      else

         do j = 1, ncol
            do k = ja(j), ja(j+1) - 1
               bool = x_ops_y( a(k), ops, val )
               if( bool ) then
                  kk = kk + 1
                  c(kk) = 1.0d0 ! TRUE
                  ic(kk) = ia(k)
               end if
            end do
            jc(j+1) = kk + 1
         end do

      end if
!!print "(/,A)",              "Check:"
!!print "(A,2X,I0)",          "  CSC sparse matrix: ncol =", ncol
!!print "(A,99(2X,I0))",      "    pointer to columns jc =", jc(:)
!!print "(A,999(2X,I0))",     "           row indices ic =", ic(:)
!!print "(A,999(2X,ES10.3))", "                 values c =", c(:)
!!print "(A,999(2X,L0))",     "                          =", c(:) == 1.0d0
!!pause "in apply_bin_ops_to_sp_dble, line 153"

   contains !- - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

      function x_ops_y( x, ops, y ) result( bool )
         real(kind=MF_DOUBLE), intent(in) :: x, y
         character(len=*),     intent(in) :: ops
         logical                          :: bool
         select case( ops )
            case( ".eq." )
               bool = x == y
            case( ".gt." )
               bool = x >  y
            case( ".ge." )
               bool = x >= y
            case( ".lt." )
               bool = x <  y
            case( ".le." )
               bool = x <= y
         end select
      end function x_ops_y

   end subroutine apply_bin_ops_to_sp_dble
