! f90 include file

!_______________________________________________________________________
!
   subroutine aplib( nrow, ncol, a, ia, ja, b, ib, jb,                  &
                     c, ic, jc, nzmax, jerr )
      real(kind=MF_DOUBLE),    intent(in)  :: a(:), b(:)
      integer,                 intent(in)  :: ia(:), ib(:), ja(:), jb(:)
      integer,                 intent(in)  :: nrow, ncol, nzmax
      complex(kind=MF_DOUBLE), intent(out) :: c(:)
      integer,                 intent(out) :: ic(:), jc(:), jerr
      !------ API end ------

      !-----------------------------------------------------------------
      ! performs the matrix sum  C = A + i*B
      ! A and B don't need to be row sorted.
      ! (adapted from 'aplb' of É. Canot)
      !-----------------------------------------------------------------
      ! on entry:
      ! ---------
      ! nrow = integer. The row dimension of A and B
      ! ncol = integer. The column dimension of A and B.
      !
      ! a, ia, ja = Matrix A in CSC format.
      !
      ! b, ib, jb = Matrix B in CSC format.
      !
      ! nzmax = integer. The length of the arrays c and ic.
      !         aplib will stop if the result matrix C has a number
      !         of elements that exceeds nzmax. See jerr.
      !
      ! on return:
      !----------
      ! c, ic, jc  = resulting matrix C in CSC format.
      !
      ! jerr = integer. serving as error message.
      !        jerr = 0 means normal return,
      !        jerr > 0 means that aplib stopped while computing the
      !                 j-th col of C with j=jerr, because the number
      !                 of elements in C exceeds nzmax.
      !-----------------------------------------------------------------

      integer :: iw(nrow)
      integer :: j, k, len, irow, ipos

   !------ end of declarations -- execution starts hereafter  ------

      jerr = 0
      len = 0
      jc(1) = 1
      iw(:) = 0

      do j = 1, ncol
         do k = ja(j), ja(j+1)-1
            len = len + 1
            irow = ia(k)
            if( len > nzmax ) goto 99
            ic(len) = irow
            c(len) = a(k)
            iw(irow)= len
         end do
         do k = jb(j), jb(j+1)-1
            irow = ib(k)
            ipos = iw(irow)
            if( ipos == 0 ) then
               len = len + 1
               if( len > nzmax ) goto 99
               ic(len) = irow
               c(len) = (0.0d0,1.0d0)*b(k)
            else
               c(ipos) = c(ipos) + (0.0d0,1.0d0)*b(k)
            end if
         end do
         do k = jc(j), len
            iw(ic(k)) = 0
         end do
         jc(j+1) = len + 1
      end do
      return
 99   jerr = j

   end subroutine aplib
