! f90 include file

!_______________________________________________________________________
!
   subroutine aplb( nrow, ncol, a, ia, ja, b, ib, jb,                   &
                    c, ic, jc, nzmax, jerr )

      real(kind=MF_DOUBLE), intent(in)  :: a(:), b(:)
      integer,              intent(in)  :: ia(:), ib(:), ja(:), jb(:)
      integer,              intent(in)  :: nrow, ncol, nzmax
      real(kind=MF_DOUBLE), intent(out) :: c(:)
      integer,              intent(out) :: ic(:), jc(:), jerr
      !------ API end ------

      !-----------------------------------------------------------------
      ! performs the matrix sum  C = A + B
      ! A and B don't need to be row sorted.
      ! (adapted from SPARSKIT2 (Mar 8 2005) 'aplb' by É. Canot)
      ! (see also the variant 'aplb1' for row-sorted matrices)
      ! (small fix: remove the unnecessary line : iw(irow)= nnz
      !             before the third 'k' loop -- this is incoherent
      !             with the non detection of duplicated entries for A;
      !             see below)
      ! (new behavior: zeros found in c(:) are removed -- Dec 5 2023)
      !-----------------------------------------------------------------
      ! on entry:
      ! ---------
      ! nrow = integer. The row dimension of A and B
      ! ncol = integer. The column dimension of A and B.
      !
      ! a, ia, ja = Matrix A in CSC format.
      !
      ! b, ib, jb = Matrix B in CSC format.
      !
      ! nzmax = integer. The length of the arrays c and ic.
      !         aplb will stop if the result matrix C has a number
      !         of elements that exceeds nzmax. See jerr.
      !
      ! on return:
      !----------
      ! c, ic, jc = resulting matrix C in CSC format.
      !
      ! jerr = integer. serving as error message.
      !        jerr = 0 means normal return,
      !        jerr > 0 means that aplb stopped while computing the
      !                 j-th col of C with j=jerr, because the number
      !                 of elements in C exceeds nzmax.
      !-----------------------------------------------------------------

      integer :: iw(nrow)
      integer :: i, j, k, nnz, irow, ipos
      logical :: unexpected_zeros, found

   !------ end of declarations -- execution starts hereafter  ------

      jerr = 0
      nnz = 0
      jc(1) = 1
      iw(:) = 0

      do j = 1, ncol
!!print *, "col j = ", j
         do k = ja(j), ja(j+1)-1
            nnz = nnz + 1
            if( nnz > nzmax ) goto 99
            irow = ia(k)
            ic(nnz) = irow
            c(nnz) = a(k)
! A must have no duplicated entries... in order to process
! duplicated entries, we should test iw(irow)
if( iw(irow) /= 0 ) then
   print *, "(MUESLI operator(+):) internal error in 'aplb':"
   print *, "                      duplicated entries detected in matrix 'A'"
   pause "for debugging purpose only..."
   stop
end if
            iw(irow)= nnz
         end do
unexpected_zeros = .false.
         do k = jb(j), jb(j+1)-1
            irow = ib(k)
            ipos = iw(irow)
            if( ipos == 0 ) then
               nnz = nnz + 1
               if( nnz > nzmax ) goto 99
               ic(nnz) = irow
               c(nnz) = b(k)
! updating iw(:) is needed only when matrix B have duplicated entries
!!               iw(irow)= nnz
            else
               c(ipos) = c(ipos) + b(k)
if( c(ipos) == 0.0d0 ) then
!!print *, "   found zero in c(ipos)!"
   unexpected_zeros = .true.
end if
            end if
         end do
         do k = jc(j), nnz
            iw(ic(k)) = 0
         end do
if( unexpected_zeros ) then
   ! We have to remove some elements in the current column...
   k = jc(j)
!!print "(A,10(ES8.1,2X))", "   process col: c(:) = ", c(jc(j):nnz)
   if( k == nnz ) then
      ! only one element in the column
      if( c(k) == 0.0d0 ) then
         ! zero to be removed!
!!print *, "   one zero removed (case #0)"
         nnz = nnz - 1
      end if
   else
      do while( k < nnz )
         if( c(k) == 0.0d0 ) then
            ! retrieve last non-zero in the column
            ! (this avoid shifting many elements)
            if( c(nnz) == 0.0d0 ) then
               ! search for a non-zero element
               found = .false.
               do i = nnz-1, k+1, -1
                  if( c(i) /= 0.0d0 ) then
                     found = .true.
                     exit
                  end if
               end do
               if( found ) then
                  ic(k) = ic(i)
                  c(k) = c(i)
!!print "(2X,I0,A)", nnz-(i-1), " zeros removed (case #1)"
                  nnz = i - 1
               else
!!print "(2X,I0,A)", nnz-(k-1), " zeros removed (case #2)"
                  nnz = k - 1
                  exit
               end if
            else
               ic(k) = ic(nnz)
               c(k) = c(nnz)
!!print *, "   one zero removed (case #3)"
               nnz = nnz - 1
            end if
         end if
         k = k + 1
      end do
   end if
end if
         jc(j+1) = nnz + 1
      end do
      return
 99   jerr = j

   end subroutine aplb
!_______________________________________________________________________
!
   subroutine aplb_cmplx_cmplx( nrow, ncol,                             &
                                a, ia, ja, b, ib, jb, c, ic, jc,        &
                                nzmax, jerr )

      complex(kind=MF_DOUBLE), intent(in)  :: a(:), b(:)
      integer,                 intent(in)  :: ia(:), ib(:), ja(:), jb(:)
      integer,                 intent(in)  :: nrow, ncol, nzmax
      complex(kind=MF_DOUBLE), intent(out) :: c(:)
      integer,                 intent(out) :: ic(:), jc(:), jerr
      !------ API end ------

      !-----------------------------------------------------------------
      ! (complex/complex version of 'aplb')
      !-----------------------------------------------------------------

      integer :: iw(nrow)
      integer :: i, j, k, nnz, irow, ipos
      logical :: unexpected_zeros, found

   !------ end of declarations -- execution starts hereafter  ------

      jerr = 0
      nnz = 0
      jc(1) = 1
      iw(:) = 0

      do j = 1, ncol
         do k = ja(j), ja(j+1)-1
            nnz = nnz + 1
            if( nnz > nzmax ) goto 99
            irow = ia(k)
            ic(nnz) = irow
            c(nnz) = a(k)
! A must have no duplicated entries... in order to process
! duplicated entries, we should test iw(irow)
if( iw(irow) /= 0 ) then
   print *, "(MUESLI operator(+):) internal error in 'aplb_cmplx_cmplx':"
   print *, "                      duplicated entries detected in matrix 'A'"
   pause "for debugging purpose only..."
   stop
end if
            iw(irow)= nnz
         end do
unexpected_zeros = .false.
         do k = jb(j), jb(j+1)-1
            irow = ib(k)
            ipos = iw(irow)
            if( ipos == 0 ) then
               nnz = nnz + 1
               if( nnz > nzmax ) goto 99
               ic(nnz) = irow
               c(nnz) = b(k)
! updating iw(:) is needed only when matrix B have duplicated entries
!!               iw(irow)= nnz
            else
               c(ipos) = c(ipos) + b(k)
if( c(ipos) == 0.0d0 ) then
   unexpected_zeros = .true.
end if
            end if
         end do
         do k = jc(j), nnz
            iw(ic(k)) = 0
         end do
if( unexpected_zeros ) then
   ! We have to remove some elements in the current column...
   k = jc(j)
   if( k == nnz ) then
      ! only one element in the column
      if( c(k) == 0.0d0 ) then
         ! zero to be removed!
         nnz = nnz - 1
      end if
   else
      do while( k < nnz )
         if( c(k) == 0.0d0 ) then
            ! retrieve last non-zero in the column
            ! (this avoid shifting many elements)
            if( c(nnz) == 0.0d0 ) then
               ! search for a non-zero element
               found = .false.
               do i = nnz-1, k+1, -1
                  if( c(i) /= 0.0d0 ) then
                     found = .true.
                     exit
                  end if
               end do
               if( found ) then
                  ic(k) = ic(i)
                  c(k) = c(i)
                  nnz = i - 1
               else
                  nnz = k - 1
                  exit
               end if
            else
               ic(k) = ic(nnz)
               c(k) = c(nnz)
               nnz = nnz - 1
            end if
         end if
         k = k + 1
      end do
   end if
end if
         jc(j+1) = nnz + 1
      end do
      return
 99   jerr = j

   end subroutine aplb_cmplx_cmplx
!_______________________________________________________________________
!
   subroutine aplb_real_cmplx( nrow, ncol,                              &
                               a, ia, ja, b, ib, jb, c, ic, jc,         &
                               nzmax, jerr )

      real(kind=MF_DOUBLE),    intent(in)  :: a(:)
      complex(kind=MF_DOUBLE), intent(in)  :: b(:)
      integer,                 intent(in)  :: ia(:), ib(:), ja(:), jb(:)
      integer,                 intent(in)  :: nrow, ncol, nzmax
      complex(kind=MF_DOUBLE), intent(out) :: c(:)
      integer,                 intent(out) :: ic(:), jc(:), jerr
      !------ API end ------

      !-----------------------------------------------------------------
      ! (real/complex version of 'aplb')
      !-----------------------------------------------------------------

      integer :: iw(nrow)
      integer :: i, j, k, nnz, irow, ipos
      logical :: unexpected_zeros, found

   !------ end of declarations -- execution starts hereafter  ------

      jerr = 0
      nnz = 0
      jc(1) = 1
      iw(:) = 0

      do j = 1, ncol
         do k = ja(j), ja(j+1)-1
            nnz = nnz + 1
            if( nnz > nzmax ) goto 99
            irow = ia(k)
            ic(nnz) = irow
            c(nnz) = a(k)
! A must have no duplicated entries... in order to process
! duplicated entries, we should test iw(irow)
if( iw(irow) /= 0 ) then
   print *, "(MUESLI operator(+):) internal error in 'aplb_real_cmplx':"
   print *, "                      duplicated entries detected in matrix 'A'"
   pause "for debugging purpose only..."
   stop
end if
            iw(irow)= nnz
         end do
unexpected_zeros = .false.
         do k = jb(j), jb(j+1)-1
            irow = ib(k)
            ipos = iw(irow)
            if( ipos == 0 ) then
               nnz = nnz + 1
               if( nnz > nzmax ) goto 99
               ic(nnz) = irow
               c(nnz) = b(k)
! updating iw(:) is needed only when matrix B have duplicated entries
!!               iw(irow)= nnz
            else
               c(ipos) = c(ipos) + b(k)
if( c(ipos) == 0.0d0 ) then
   unexpected_zeros = .true.
end if
            end if
         end do
         do k = jc(j), nnz
            iw(ic(k)) = 0
         end do
if( unexpected_zeros ) then
   ! We have to remove some elements in the current column...
   k = jc(j)
   if( k == nnz ) then
      ! only one element in the column
      if( c(k) == 0.0d0 ) then
         ! zero to be removed!
         nnz = nnz - 1
      end if
   else
      do while( k < nnz )
         if( c(k) == 0.0d0 ) then
            ! retrieve last non-zero in the column
            ! (this avoid shifting many elements)
            if( c(nnz) == 0.0d0 ) then
               ! search for a non-zero element
               found = .false.
               do i = nnz-1, k+1, -1
                  if( c(i) /= 0.0d0 ) then
                     found = .true.
                     exit
                  end if
               end do
               if( found ) then
                  ic(k) = ic(i)
                  c(k) = c(i)
                  nnz = i - 1
               else
                  nnz = k - 1
                  exit
               end if
            else
               ic(k) = ic(nnz)
               c(k) = c(nnz)
               nnz = nnz - 1
            end if
         end if
         k = k + 1
      end do
   end if
end if
         jc(j+1) = nnz + 1
      end do
      return
 99   jerr = j

   end subroutine aplb_real_cmplx
!_______________________________________________________________________
!
   subroutine aplb_cmplx_real( nrow, ncol,                              &
                               a, ia, ja, b, ib, jb, c, ic, jc,         &
                               nzmax, jerr )

      complex(kind=MF_DOUBLE), intent(in)  :: a(:)
      real(kind=MF_DOUBLE),    intent(in)  :: b(:)
      integer,                 intent(in)  :: ia(:), ib(:), ja(:), jb(:)
      integer,                 intent(in)  :: nrow, ncol, nzmax
      complex(kind=MF_DOUBLE), intent(out) :: c(:)
      integer,                 intent(out) :: ic(:), jc(:), jerr
      !------ API end ------

      !-----------------------------------------------------------------
      ! (complex/real version of 'aplb')
      !-----------------------------------------------------------------

      integer :: iw(nrow)
      integer :: i, j, k, nnz, irow, ipos
      logical :: unexpected_zeros, found

   !------ end of declarations -- execution starts hereafter  ------

      jerr = 0
      nnz = 0
      jc(1) = 1
      iw(:) = 0

      do j = 1, ncol
         do k = ja(j), ja(j+1)-1
            nnz = nnz + 1
            if( nnz > nzmax ) goto 99
            irow = ia(k)
            ic(nnz) = irow
            c(nnz) = a(k)
! A must have no duplicated entries... in order to process
! duplicated entries, we should test iw(irow)
if( iw(irow) /= 0 ) then
   print *, "(MUESLI operator(+):) internal error in 'aplb_cmplx_real':"
   print *, "                      duplicated entries detected in matrix 'A'"
   pause "for debugging purpose only..."
   stop
end if
            iw(irow)= nnz
         end do
unexpected_zeros = .false.
         do k = jb(j), jb(j+1)-1
            irow = ib(k)
            ipos = iw(irow)
            if( ipos == 0 ) then
               nnz = nnz + 1
               if( nnz > nzmax ) goto 99
               ic(nnz) = irow
               c(nnz) = b(k)
! updating iw(:) is needed only when matrix B have duplicated entries
!!               iw(irow)= nnz
            else
               c(ipos) = c(ipos) + b(k)
if( c(ipos) == 0.0d0 ) then
   unexpected_zeros = .true.
end if
            end if
         end do
         do k = jc(j), nnz
            iw(ic(k)) = 0
         end do
if( unexpected_zeros ) then
   ! We have to remove some elements in the current column...
   k = jc(j)
   if( k == nnz ) then
      ! only one element in the column
      if( c(k) == 0.0d0 ) then
         ! zero to be removed!
         nnz = nnz - 1
      end if
   else
      do while( k < nnz )
         if( c(k) == 0.0d0 ) then
            ! retrieve last non-zero in the column
            ! (this avoid shifting many elements)
            if( c(nnz) == 0.0d0 ) then
               ! search for a non-zero element
               found = .false.
               do i = nnz-1, k+1, -1
                  if( c(i) /= 0.0d0 ) then
                     found = .true.
                     exit
                  end if
               end do
               if( found ) then
                  ic(k) = ic(i)
                  c(k) = c(i)
                  nnz = i - 1
               else
                  nnz = k - 1
                  exit
               end if
            else
               ic(k) = ic(nnz)
               c(k) = c(nnz)
               nnz = nnz - 1
            end if
         end if
         k = k + 1
      end do
   end if
end if
         jc(j+1) = nnz + 1
      end do
      return
 99   jerr = j

   end subroutine aplb_cmplx_real
