! f90 include file

!_______________________________________________________________________
!
   subroutine amux( ncol, x, y, a, ia, ja )

      integer,              intent(in) :: ncol
      real(kind=MF_DOUBLE), intent(in) :: x(:), a(:)
      integer,              intent(in) :: ia(:), ja(:)
      real(kind=MF_DOUBLE), intent(out) :: y(:)
      !------ API end ------

      !-----------------------------------------------------------------
      !         A times a vector
      ! (written by É. Canot)
      !-----------------------------------------------------------------
      ! multiplies a matrix by a vector;
      ! Matrix A is stored in CSC storage, not necessarily row sorted.
      !
      ! on entry:
      !----------
      ! ncol  = column dimension of A
      ! x     = real array of length equal to the column dimension of
      !         the A matrix.
      ! a, ia, ja = input matrix in CSC format.
      !
      ! on return:
      !-----------
      ! y = dense vector (real array of length nrow) containing the
      !     product A*x
      !-----------------------------------------------------------------

      integer :: i, j, k

   !------ end of declarations -- execution starts hereafter  ------

      y(:) = 0.0d0

      do j = 1, ncol
         ! examine if x(j) is non-zero
         if( x(j) /= 0.0d0 ) then
            do k = ja(j), ja(j+1)-1
               i = ia(k)
               y(i) = y(i) + a(k)*x(j)
            end do
         end if
      end do

   end subroutine amux
!_______________________________________________________________________
!
   subroutine amux_real_cmplx( ncol, x, y, a, ia, ja )

      integer,                 intent(in) :: ncol
      real(kind=MF_DOUBLE),    intent(in) ::  a(:)
      complex(kind=MF_DOUBLE), intent(in) ::  x(:)
      integer,                 intent(in) :: ia(:), ja(:)
      complex(kind=MF_DOUBLE), intent(out) :: y(:)
      !------ API end ------

      !-----------------------------------------------------------------
      !         A times a vector
      ! (written by É. Canot)
      ! (real/complex case of 'amux')
      !-----------------------------------------------------------------

      integer :: i, j, k

   !------ end of declarations -- execution starts hereafter  ------

      y(:) = (0.0d0,0.0d0)

      do j = 1, ncol
         ! examine if x(j) is non-zero
         if( x(j) /= (0.0d0,0.0d0) ) then
            do k = ja(j), ja(j+1)-1
               i = ia(k)
               y(i) = y(i) + a(k)*x(j)
            end do
         end if
      end do

   end subroutine amux_real_cmplx
!_______________________________________________________________________
!
   subroutine amux_cmplx_real( ncol, x, y, a, ia, ja )

      integer,                 intent(in) :: ncol
      complex(kind=MF_DOUBLE), intent(in) ::  a(:)
      real(kind=MF_DOUBLE),    intent(in) ::  x(:)
      integer,                 intent(in) :: ia(:), ja(:)
      complex(kind=MF_DOUBLE), intent(out) :: y(:)
      !------ API end ------

      !-----------------------------------------------------------------
      !         A times a vector
      ! (written by É. Canot)
      ! (complex/real case of 'amux')
      !-----------------------------------------------------------------

      integer :: i, j, k

   !------ end of declarations -- execution starts hereafter  ------

      y(:) = (0.0d0,0.0d0)

      do j = 1, ncol
         ! examine if x(j) is non-zero
         if( x(j) /= 0.0d0 ) then
            do k = ja(j), ja(j+1)-1
               i = ia(k)
               y(i) = y(i) + a(k)*x(j)
            end do
         end if
      end do

   end subroutine amux_cmplx_real
!_______________________________________________________________________
!
   subroutine amux_cmplx_cmplx( ncol, x, y, a, ia, ja )

      integer,                 intent(in) :: ncol
      complex(kind=MF_DOUBLE), intent(in) ::  a(:)
      complex(kind=MF_DOUBLE), intent(in) ::  x(:)
      integer,                 intent(in) :: ia(:), ja(:)
      complex(kind=MF_DOUBLE), intent(out) :: y(:)
      !------ API end ------

      !-----------------------------------------------------------------
      !         A times a vector
      ! (written by É. Canot)
      ! (complex/complex case of 'amux')
      !-----------------------------------------------------------------

      integer :: i, j, k

   !------ end of declarations -- execution starts hereafter  ------

      y(:) = (0.0d0,0.0d0)

      do j = 1, ncol
         ! examine if x(j) is non-zero
         if( x(j) /= (0.0d0,0.0d0) ) then
            do k = ja(j), ja(j+1)-1
               i = ia(k)
               y(i) = y(i) + a(k)*x(j)
            end do
         end if
      end do

   end subroutine amux_cmplx_cmplx
