! f90 include file

!_______________________________________________________________________
!
   subroutine amub( nrow, ncolb, a, ia, ja, b, ib, jb,                  &
                    c, ic, jc, nzmax, ierr )

      integer,              intent(in) :: nrow, ncolb, nzmax
      real(kind=MF_DOUBLE), intent(in) :: a(:), b(:)
      integer,              intent(in) :: ia(:), ja(:), ib(:), jb(:)
      real(kind=MF_DOUBLE)             :: c(:)
      integer                          :: ic(:), jc(:), ierr
      !------ API end ------

      !-----------------------------------------------------------------
      ! performs the matrix by matrix product C = A*B
      ! (adapted from 'amub' of SPARSKIT)
      !-----------------------------------------------------------------
      ! on entry:
      ! ---------
      ! nrow = row dimension of A.
      ! ncolb = column dimension of B.
      !
      ! a, ia, ja = Matrix A in CSC format.
      !
      ! b, ib, jb = Matrix B in CSC format.
      !
      ! nzmax = integer. The length of the arrays c and jc.
      !         amub will stop if the result matrix C has a number
      !         of elements that exceeds nzmax. See ierr.
      !
      ! on return:
      !----------
      ! c, ic, jc = resulting matrix C in CSC sparse format.
      !
      ! ierr  = integer. serving as error message.
      !         ierr = 0 means normal return,
      !         ierr > 0 means that amub stopped while computing the
      !                  j-th col of C with j=ierr, because the number
      !                  of elements in C exceeds nzmax.
      !
      ! note: returned matrix is row sorted if, at least, A is row sorted !
      !-----------------------------------------------------------------

      integer :: iw(nrow)
      integer :: nnz, j, k, ka, kb, irowa, irowb, ipos
      integer :: nnz_col, shift

   !------ end of declarations -- execution starts hereafter  ------

      nnz = 0
      jc(1) = 1
      ierr = 0

      ! builds column vectors of C
      do j = 1, ncolb
         iw(:) = 0
         do kb = jb(j), jb(j+1)-1
            irowb = ib(kb)
            do ka = ja(irowb), ja(irowb+1)-1
               irowa = ia(ka)
               ipos = iw(irowa)
               if( ipos == 0 ) then
                  nnz = nnz + 1
                  if( nnz > nzmax ) then
                     ierr = j
                     return
                  end if
                  ic(nnz) = irowa
                  iw(irowa) = nnz
                  c(nnz) = a(ka)*b(kb)
               else
                  c(ipos) = c(ipos) + a(ka)*b(kb)
               end if
            end do
         end do
         ! remove null elements
         nnz_col = 0
         do k = jc(j), nnz
            if( c(k) /= 0.0d0 ) then
               nnz_col = nnz_col + 1
               iw(nnz_col) = k
            end if
         end do
         shift = nnz-jc(j)+1 - nnz_col
         if( shift /= 0 ) then
            ic(jc(j):nnz-shift) = ic(iw(1:nnz_col))
            c(jc(j):nnz-shift) = c(iw(1:nnz_col))
            nnz = nnz - shift
         end if
         jc(j+1) = nnz + 1
      end do

   end subroutine amub
!_______________________________________________________________________
!
   subroutine amub_real_cmplx( nrow, ncolb, a, ia, ja, b, ib, jb, &
                               c, ic, jc, nzmax, ierr )

      integer,                 intent(in) :: nrow, ncolb, nzmax
      real(kind=MF_DOUBLE),    intent(in) :: a(:)
      complex(kind=MF_DOUBLE), intent(in) :: b(:)
      integer,                 intent(in) :: ia(:), ja(:), ib(:), jb(:)
      complex(kind=MF_DOUBLE)             :: c(:)
      integer                             :: ic(:), jc(:), ierr
      !------ API end ------

      !-----------------------------------------------------------------
      ! performs the matrix by matrix product C = A*B
      ! (adapted from 'amub' of SPARSKIT)
      ! (real/complex case of 'amub')
      !-----------------------------------------------------------------

      integer :: iw(nrow)
      integer :: nnz, j, k, ka, kb, irowa, irowb, ipos
      integer :: nnz_col, shift

   !------ end of declarations -- execution starts hereafter  ------

      nnz = 0
      jc(1) = 1
      ierr = 0

      ! builds column vectors of C
      do j = 1, ncolb
         iw(:) = 0
         do kb = jb(j), jb(j+1)-1
            irowb = ib(kb)
            do ka = ja(irowb), ja(irowb+1)-1
               irowa = ia(ka)
               ipos = iw(irowa)
               if( ipos == 0 ) then
                  nnz = nnz + 1
                  if( nnz > nzmax ) then
                     ierr = j
                     return
                  end if
                  ic(nnz) = irowa
                  iw(irowa) = nnz
                  c(nnz) = a(ka)*b(kb)
               else
                  c(ipos) = c(ipos) + a(ka)*b(kb)
               end if
            end do
         end do
         ! remove null elements
         nnz_col = 0
         do k = jc(j), nnz
            if( c(k) /= 0.0d0 ) then
               nnz_col = nnz_col + 1
               iw(nnz_col) = k
            end if
         end do
         shift = nnz-jc(j)+1 - nnz_col
         if( shift /= 0 ) then
            ic(jc(j):nnz-shift) = ic(iw(1:nnz_col))
            c(jc(j):nnz-shift) = c(iw(1:nnz_col))
            nnz = nnz - shift
         end if
         jc(j+1) = nnz + 1
      end do

   end subroutine amub_real_cmplx
!_______________________________________________________________________
!
   subroutine amub_cmplx_real( nrow, ncolb, a, ia, ja, b, ib, jb, &
                               c, ic, jc, nzmax, ierr )

      integer,                 intent(in) :: nrow, ncolb, nzmax
      complex(kind=MF_DOUBLE), intent(in) :: a(:)
      real(kind=MF_DOUBLE),    intent(in) :: b(:)
      integer,                 intent(in) :: ia(:), ja(:), ib(:), jb(:)
      complex(kind=MF_DOUBLE)             :: c(:)
      integer                             :: ic(:), jc(:), ierr
      !------ API end ------

      !-----------------------------------------------------------------
      ! performs the matrix by matrix product C = A*B
      ! (adapted from 'amub' of SPARSKIT)
      ! (complex/real case of 'amub')
      !-----------------------------------------------------------------

      integer :: iw(nrow)
      integer :: nnz, j, k, ka, kb, irowa, irowb, ipos
      integer :: nnz_col, shift

   !------ end of declarations -- execution starts hereafter  ------

      nnz = 0
      jc(1) = 1
      ierr = 0

      ! builds column vectors of C
      do j = 1, ncolb
         iw(:) = 0
         do kb = jb(j), jb(j+1)-1
            irowb = ib(kb)
            do ka = ja(irowb), ja(irowb+1)-1
               irowa = ia(ka)
               ipos = iw(irowa)
               if( ipos == 0 ) then
                  nnz = nnz + 1
                  if( nnz > nzmax ) then
                     ierr = j
                     return
                  end if
                  ic(nnz) = irowa
                  iw(irowa) = nnz
                  c(nnz) = a(ka)*b(kb)
               else
                  c(ipos) = c(ipos) + a(ka)*b(kb)
               end if
            end do
         end do
         ! remove null elements
         nnz_col = 0
         do k = jc(j), nnz
            if( c(k) /= 0.0d0 ) then
               nnz_col = nnz_col + 1
               iw(nnz_col) = k
            end if
         end do
         shift = nnz-jc(j)+1 - nnz_col
         if( shift /= 0 ) then
            ic(jc(j):nnz-shift) = ic(iw(1:nnz_col))
            c(jc(j):nnz-shift) = c(iw(1:nnz_col))
            nnz = nnz - shift
         end if
         jc(j+1) = nnz + 1
      end do

   end subroutine amub_cmplx_real
!_______________________________________________________________________
!
   subroutine amub_cmplx_cmplx( nrow, ncolb, a, ia, ja, b, ib, jb, &
                                c, ic, jc, nzmax, ierr )

      integer,                 intent(in) :: nrow, ncolb, nzmax
      complex(kind=MF_DOUBLE), intent(in) :: a(:), b(:)
      integer,                 intent(in) :: ia(:), ja(:), ib(:), jb(:)
      complex(kind=MF_DOUBLE)             :: c(:)
      integer                             :: ic(:), jc(:), ierr
      !------ API end ------

      !-----------------------------------------------------------------
      ! performs the matrix by matrix product C = A*B
      ! (adapted from 'amub' of SPARSKIT)
      ! (complex/complex case of 'amub')
      !-----------------------------------------------------------------

      integer :: iw(nrow)
      integer :: nnz, j, k, ka, kb, irowa, irowb, ipos
      integer :: nnz_col, shift

   !------ end of declarations -- execution starts hereafter  ------

      nnz = 0
      jc(1) = 1
      ierr = 0

      ! builds column vectors of C
      do j = 1, ncolb
         iw(:) = 0
         do kb = jb(j), jb(j+1)-1
            irowb = ib(kb)
            do ka = ja(irowb), ja(irowb+1)-1
               irowa = ia(ka)
               ipos = iw(irowa)
               if( ipos == 0 ) then
                  nnz = nnz + 1
                  if( nnz > nzmax ) then
                     ierr = j
                     return
                  end if
                  ic(nnz) = irowa
                  iw(irowa) = nnz
                  c(nnz) = a(ka)*b(kb)
               else
                  c(ipos) = c(ipos) + a(ka)*b(kb)
               end if
            end do
         end do
         ! remove null elements
         nnz_col = 0
         do k = jc(j), nnz
            if( c(k) /= 0.0d0 ) then
               nnz_col = nnz_col + 1
               iw(nnz_col) = k
            end if
         end do
         shift = nnz-jc(j)+1 - nnz_col
         if( shift /= 0 ) then
            ic(jc(j):nnz-shift) = ic(iw(1:nnz_col))
            c(jc(j):nnz-shift) = c(iw(1:nnz_col))
            nnz = nnz - shift
         end if
         jc(j+1) = nnz + 1
      end do

   end subroutine amub_cmplx_cmplx
